/* Generated By:JavaCC: Do not edit this line. VRML97Parser.java */
package org.cybergarage.x3d.parser.vrml97;

import java.io.IOException;
import java.io.Reader;

import org.cybergarage.x3d.field.MFColor;
import org.cybergarage.x3d.field.MFFloat;
import org.cybergarage.x3d.field.MFInt32;
import org.cybergarage.x3d.field.MFRotation;
import org.cybergarage.x3d.field.MFString;
import org.cybergarage.x3d.field.MFTime;
import org.cybergarage.x3d.field.MFVec2f;
import org.cybergarage.x3d.field.MFVec3f;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFColor;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.field.SFInt32;
import org.cybergarage.x3d.field.SFNode;
import org.cybergarage.x3d.field.SFRotation;
import org.cybergarage.x3d.field.SFString;
import org.cybergarage.x3d.field.SFTime;
import org.cybergarage.x3d.field.SFVec2f;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.AnchorNode;
import org.cybergarage.x3d.node.AppearanceNode;
import org.cybergarage.x3d.node.AudioClipNode;
import org.cybergarage.x3d.node.BackgroundNode;
import org.cybergarage.x3d.node.BillboardNode;
import org.cybergarage.x3d.node.BoxNode;
import org.cybergarage.x3d.node.CollisionNode;
import org.cybergarage.x3d.node.ColorInterpolatorNode;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.ConeNode;
import org.cybergarage.x3d.node.CoordinateInterpolatorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.CylinderNode;
import org.cybergarage.x3d.node.CylinderSensorNode;
import org.cybergarage.x3d.node.DirectionalLightNode;
import org.cybergarage.x3d.node.ElevationGridNode;
import org.cybergarage.x3d.node.ExtrusionNode;
import org.cybergarage.x3d.node.FogNode;
import org.cybergarage.x3d.node.FontStyleNode;
import org.cybergarage.x3d.node.GroupNode;
import org.cybergarage.x3d.node.ImageTextureNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.IndexedLineSetNode;
import org.cybergarage.x3d.node.InlineNode;
import org.cybergarage.x3d.node.LODNode;
import org.cybergarage.x3d.node.MaterialNode;
import org.cybergarage.x3d.node.MovieTextureNode;
import org.cybergarage.x3d.node.NavigationInfoNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NormalInterpolatorNode;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.OrientationInterpolatorNode;
import org.cybergarage.x3d.node.PixelTextureNode;
import org.cybergarage.x3d.node.PlaneSensorNode;
import org.cybergarage.x3d.node.PointLightNode;
import org.cybergarage.x3d.node.PointSetNode;
import org.cybergarage.x3d.node.PositionInterpolatorNode;
import org.cybergarage.x3d.node.ProximitySensorNode;
import org.cybergarage.x3d.node.ScalarInterpolatorNode;
import org.cybergarage.x3d.node.ScriptNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.node.SoundNode;
import org.cybergarage.x3d.node.SphereNode;
import org.cybergarage.x3d.node.SphereSensorNode;
import org.cybergarage.x3d.node.SpotLightNode;
import org.cybergarage.x3d.node.SwitchNode;
import org.cybergarage.x3d.node.TextNode;
import org.cybergarage.x3d.node.TextureCoordinateNode;
import org.cybergarage.x3d.node.TextureTransformNode;
import org.cybergarage.x3d.node.TimeSensorNode;
import org.cybergarage.x3d.node.TouchSensorNode;
import org.cybergarage.x3d.node.TransformNode;
import org.cybergarage.x3d.node.ViewpointNode;
import org.cybergarage.x3d.node.VisibilitySensorNode;
import org.cybergarage.x3d.node.WorldInfoNode;
import org.cybergarage.x3d.parser.Parser;

public class VRML97Parser extends Parser implements VRML97ParserType,
        VRML97ParserConstants {

    public VRML97Parser() {
    }

    // /////////////////////////////////////////////
    // Parse
    // /////////////////////////////////////////////

    public boolean parse(Reader reader) {
        try {
            initResult();
            setParseResult(false);
            Input();
            setParseResult(true);
            reader.close();
        } catch (org.cybergarage.x3d.parser.vrml97.ParseException e) {
            System.out.println(e.getMessage());
            setErrorMessage(e.getMessage());
        } catch (org.cybergarage.x3d.parser.vrml97.TokenMgrError e) {
            System.out.println(e.getMessage());
            setErrorMessage(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            setErrorMessage(e.getMessage());
        }

        try {
            reader.close();
        } catch (IOException e) {
        }

        return getParseResult();
    }

    // /////////////////////////////////////////////
    // Praser action
    // /////////////////////////////////////////////

    public void addSFInt32(int value) {
        switch (getCurrentType()) {
        case parserTypeIdxFaceSetCoordIndex: {
            ((IndexedFaceSetNode) getCurrentNode()).addCoordIndex(value);
        }
            break;
        case parserTypeIdxFaceSetTexCoordIndex: {
            ((IndexedFaceSetNode) getCurrentNode()).addTexCoordIndex(value);
        }
            break;
        case parserTypeIdxFaceSetNormalIndex: {
            ((IndexedFaceSetNode) getCurrentNode()).addNormalIndex(value);
        }
            break;
        case parserTypeIdxFaceSetColorIndex: {
            ((IndexedFaceSetNode) getCurrentNode()).addColorIndex(value);
        }
            break;
        case parserTypeIdxLineSetCoordIndex: {
            ((IndexedLineSetNode) getCurrentNode()).addCoordIndex(value);
        }
            break;
        case parserTypeIdxLineSetColorIndex: {
            ((IndexedLineSetNode) getCurrentNode()).addColorIndex(value);
        }
            break;
        case parserTypePixelTextureImage: {
            ((PixelTextureNode) getCurrentNode()).addImage(value);
        }
            break;
        }
    }

    public void addSFFloat(float value) {
        switch (getCurrentType()) {
        case parserTypeCoordinateInterpolatorKey: {
            ((CoordinateInterpolatorNode) getCurrentNode()).addKey(value);
        }
            break;
        case parserTypePositionInterpolatorKey: {
            ((PositionInterpolatorNode) getCurrentNode()).addKey(value);
        }
            break;
        case parserTypeNormalInterpolatorKey: {
            ((NormalInterpolatorNode) getCurrentNode()).addKey(value);
        }
            break;
        case parserTypeColorInterpolatorKey: {
            ((ColorInterpolatorNode) getCurrentNode()).addKey(value);
        }
            break;
        case parserTypeScalarInterpolatorKey: {
            ((ScalarInterpolatorNode) getCurrentNode()).addKey(value);
        }
            break;
        case parserTypeScalarInterpolatorKeyValue: {
            ((ScalarInterpolatorNode) getCurrentNode()).addKeyValue(value);
        }
            break;
        case parserTypeOrientationInterpolatorKey: {
            ((OrientationInterpolatorNode) getCurrentNode()).addKey(value);
        }
            break;
        case parserTypeLODRange: {
            ((LODNode) getCurrentNode()).addRange(value);
        }
            break;
        case parserTypeElevationGridHeight: {
            ((ElevationGridNode) getCurrentNode()).addHeight(value);
        }
            break;
        case parserTypeTextLength: {
            ((TextNode) getCurrentNode()).addLength(value);
        }
            break;
        case parserTypeBackgroundGroundAngle: {
            ((BackgroundNode) getCurrentNode()).addGroundAngle(value);
        }
            break;
        case parserTypeBackgroundSkyAngle: {
            ((BackgroundNode) getCurrentNode()).addSkyAngle(value);
        }
            break;
        case parserTypeNavigationInfoAvatarSize: {
            ((NavigationInfoNode) getCurrentNode()).addAvatarSize(value);
        }
            break;
        }
    }

    public void addSFTime(double value) {
    }

    public void addSFVec2f(float vector[]) {
        switch (getCurrentType()) {
        case parserTypeTextureCoordinate: {
            ((TextureCoordinateNode) getCurrentNode()).addPoint(vector);
        }
            break;
        case parserTypeExtrusionCrossSection: {
            ((ExtrusionNode) getCurrentNode()).addCrossSection(vector);
        }
            break;
        case parserTypeExtrusionScale: {
            ((ExtrusionNode) getCurrentNode()).addScale(vector);
        }
            break;
        }
    }

    public void addSFVec3f(float vector[]) {
        switch (getCurrentType()) {
        case parserTypeCoordinate: {
            ((CoordinateNode) getCurrentNode()).addPoint(vector);
        }
            break;
        case parserTypeNormal: {
            ((NormalNode) getCurrentNode()).addVector(vector);
        }
            break;
        case parserTypeCoordinateInterpolatorKeyValue: {
            ((CoordinateInterpolatorNode) getCurrentNode()).addKeyValue(vector);
        }
            break;
        case parserTypePositionInterpolatorKeyValue: {
            ((PositionInterpolatorNode) getCurrentNode()).addKeyValue(vector);
        }
            break;
        case parserTypeNormalInterpolatorKeyValue: {
            ((NormalInterpolatorNode) getCurrentNode()).addKeyValue(vector);
        }
            break;
        case parserTypeExtrusionSpine: {
            ((ExtrusionNode) getCurrentNode()).addSpine(vector);
        }
            break;
        }
    }

    public void addSFColor(float color[]) {
        switch (getCurrentType()) {
        case parserTypeColor: {
            ((ColorNode) getCurrentNode()).addColor(color);
        }
            break;
        case parserTypeColorInterpolatorKeyValue: {
            ((ColorInterpolatorNode) getCurrentNode()).addKeyValue(color);
        }
            break;
        case parserTypeBackgroundGroundColor: {
            ((BackgroundNode) getCurrentNode()).addGroundColor(color);
        }
            break;
        case parserTypeBackgroundSkyColor: {
            ((BackgroundNode) getCurrentNode()).addSkyColor(color);
        }
            break;
        }
    }

    public void addSFRotation(float rotation[]) {
        switch (getCurrentType()) {
        case parserTypeOrientationInterpolatorKeyValue: {
            ((OrientationInterpolatorNode) getCurrentNode())
                    .addKeyValue(rotation);
        }
            break;
        case parserTypeExtrusionOrientation: {
            ((ExtrusionNode) getCurrentNode()).addOrientation(rotation);
        }
            break;
        }
    }

    public void addSFString(String string) {
        switch (getCurrentType()) {
        case parserTypeWorldInfoInfo: {
            ((WorldInfoNode) getCurrentNode()).addInfo(string);
        }
            break;
        case parserTypeScriptURL: {
            ((ScriptNode) getCurrentNode()).addURL(string);
        }
            break;
        case parserTypeAnchorURL: {
            ((AnchorNode) getCurrentNode()).addURL(string);
        }
            break;
        case parserTypeAnchorParameter: {
            ((AnchorNode) getCurrentNode()).addParameter(string);
        }
            break;
        case parserTypeInlineURL: {
            ((InlineNode) getCurrentNode()).addURL(string);
        }
            break;
        case parserTypeAudioClipURL: {
            ((AudioClipNode) getCurrentNode()).addURL(string);
        }
            break;
        case parserTypeTextString: {
            ((TextNode) getCurrentNode()).addString(string);
        }
            break;
        case parserTypeFontStyleFamily: {
            ((FontStyleNode) getCurrentNode()).addFamily(string);
        }
            break;
        case parserTypeFontStyleJustify: {
            ((FontStyleNode) getCurrentNode()).addJustify(string);
        }
            break;
        case parserTypeImageTextureURL: {
            ((ImageTextureNode) getCurrentNode()).addURL(string);
        }
            break;
        case parserTypeMovieTextureURL: {
            ((MovieTextureNode) getCurrentNode()).addURL(string);
        }
            break;
        case parserTypeBackgroundBackURL: {
            ((BackgroundNode) getCurrentNode()).addBackURL(string);
        }
            break;
        case parserTypeBackgroundBottomURL: {
            ((BackgroundNode) getCurrentNode()).addBottomURL(string);
        }
            break;
        case parserTypeBackgroundFrontURL: {
            ((BackgroundNode) getCurrentNode()).addFrontURL(string);
        }
            break;
        case parserTypeBackgroundLeftURL: {
            ((BackgroundNode) getCurrentNode()).addLeftURL(string);
        }
            break;
        case parserTypeBackgroundRightURL: {
            ((BackgroundNode) getCurrentNode()).addRightURL(string);
        }
            break;
        case parserTypeBackgroundTopURL: {
            ((BackgroundNode) getCurrentNode()).addTopURL(string);
        }
            break;
        case parserTypeNavigationInfoType: {
            ((NavigationInfoNode) getCurrentNode()).addType(string);
        }
            break;
        }
    }

    // /////////////////////////////////////////////
    // NodeBegin() / NodeEnd()
    // /////////////////////////////////////////////
    final public void NodeBegin() throws ParseException {
        jj_consume_token(8);
    }

    final public void NodeEnd() throws ParseException {
        jj_consume_token(9);
        label_1: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 10:
                ;
                break;
            default:
                jj_la1[0] = jj_gen;
                break label_1;
            }
            jj_consume_token(10);
        }
    }

    final public boolean SFBoolToken() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case TRUE:
            jj_consume_token(TRUE);
            {
                if (true)
                    return true;
            }
            break;
        case FALSE:
            jj_consume_token(FALSE);
            {
                if (true)
                    return false;
            }
            break;
        default:
            jj_la1[1] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    // /////////////////////////////////////////////
    // SF/MFFloat
    // /////////////////////////////////////////////
    final public float SFFloatToken() throws ParseException {
        Token t;
        Float floatObj;
        float value;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case NUMBER:
            t = jj_consume_token(NUMBER);
            value = (float) Integer.parseInt(t.image);
            addSFFloat(value);
            {
                if (true)
                    return value;
            }
            break;
        case FLOAT_NUMBER:
            t = jj_consume_token(FLOAT_NUMBER);
            floatObj = new Float(t.image);
            value = floatObj.floatValue();
            // value = Float.parseFloat(t.image);
            addSFFloat(value);
            {
                if (true)
                    return value;
            }
            break;
        default:
            jj_la1[2] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final public void MFFloatToken() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 13:
            jj_consume_token(13);
            label_2: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case NUMBER:
                case FLOAT_NUMBER:
                    ;
                    break;
                default:
                    jj_la1[3] = jj_gen;
                    break label_2;
                }
                SFFloatToken();
                label_3: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case 10:
                        ;
                        break;
                    default:
                        jj_la1[4] = jj_gen;
                        break label_3;
                    }
                    jj_consume_token(10);
                }
            }
            jj_consume_token(14);
            break;
        case NUMBER:
        case FLOAT_NUMBER:
            SFFloatToken();
            break;
        default:
            jj_la1[5] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // /////////////////////////////////////////////
    // SF/MFTime
    // /////////////////////////////////////////////
    final public double SFTimeToken() throws ParseException {
        Token t;
        Double doubleObj;
        double value;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case NUMBER:
            t = jj_consume_token(NUMBER);
            value = (double) Integer.parseInt(t.image);
            addSFTime(value);
            {
                if (true)
                    return value;
            }
            break;
        case FLOAT_NUMBER:
            t = jj_consume_token(FLOAT_NUMBER);
            doubleObj = new Double(t.image);
            value = doubleObj.doubleValue();
            // value = Double.parseDouble(t.image);
            addSFTime(value);
            {
                if (true)
                    return value;
            }
            break;
        default:
            jj_la1[6] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final public void MFTimeToken() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 13:
            jj_consume_token(13);
            label_4: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case NUMBER:
                case FLOAT_NUMBER:
                    ;
                    break;
                default:
                    jj_la1[7] = jj_gen;
                    break label_4;
                }
                SFTimeToken();
                label_5: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case 10:
                        ;
                        break;
                    default:
                        jj_la1[8] = jj_gen;
                        break label_5;
                    }
                    jj_consume_token(10);
                }
            }
            jj_consume_token(14);
            break;
        case NUMBER:
        case FLOAT_NUMBER:
            SFTimeToken();
            break;
        default:
            jj_la1[9] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // /////////////////////////////////////////////
    // SF/MFInt32
    // /////////////////////////////////////////////
    final public int SFInt32Token() throws ParseException {
        Token t;
        int value;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case NUMBER:
            t = jj_consume_token(NUMBER);
            value = Integer.parseInt(t.image);
            addSFInt32(value);
            {
                if (true)
                    return value;
            }
            break;
        case HEX_NUMBER:
            t = jj_consume_token(HEX_NUMBER);
            value = Integer.parseInt(
                    new String(t.image.getBytes(), 2, (t.image.length() - 2)),
                    16);
            addSFInt32(value);
            {
                if (true)
                    return value;
            }
            break;
        default:
            jj_la1[10] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    final public void MFInt32Token() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 13:
            jj_consume_token(13);
            label_6: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case NUMBER:
                case HEX_NUMBER:
                    ;
                    break;
                default:
                    jj_la1[11] = jj_gen;
                    break label_6;
                }
                SFInt32Token();
                label_7: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case 10:
                        ;
                        break;
                    default:
                        jj_la1[12] = jj_gen;
                        break label_7;
                    }
                    jj_consume_token(10);
                }
            }
            jj_consume_token(14);
            break;
        case NUMBER:
        case HEX_NUMBER:
            SFInt32Token();
            break;
        default:
            jj_la1[13] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // /////////////////////////////////////////////
    // SF/MFVec3f
    // /////////////////////////////////////////////
    final public void SFVec2fToken(float value[]) throws ParseException {
        float x, y;
        x = SFFloatToken();
        y = SFFloatToken();
        value[0] = x;
        value[1] = y;
        addSFVec2f(value);
        // System.out.println("MFVec3fToken : " + value[0] + ", "+ value[1] +
        // ", " + value[2] );

    }

    final public void MFVec2fToken() throws ParseException {
        float value[] = new float[2];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 13:
            jj_consume_token(13);
            label_8: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case NUMBER:
                case FLOAT_NUMBER:
                    ;
                    break;
                default:
                    jj_la1[14] = jj_gen;
                    break label_8;
                }
                SFVec2fToken(value);
                label_9: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case 10:
                        ;
                        break;
                    default:
                        jj_la1[15] = jj_gen;
                        break label_9;
                    }
                    jj_consume_token(10);
                }
            }
            jj_consume_token(14);
            break;
        case NUMBER:
        case FLOAT_NUMBER:
            SFVec2fToken(value);
            break;
        default:
            jj_la1[16] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // /////////////////////////////////////////////
    // SF/MFVec3f
    // /////////////////////////////////////////////
    final public void SFVec3fToken(float value[]) throws ParseException {
        float x, y, z;
        x = SFFloatToken();
        y = SFFloatToken();
        z = SFFloatToken();
        value[0] = x;
        value[1] = y;
        value[2] = z;
        addSFVec3f(value);
        // System.out.println("MFVec3fToken : " + value[0] + ", "+ value[1] +
        // ", " + value[2] );

    }

    final public void MFVec3fToken() throws ParseException {
        float value[] = new float[3];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 13:
            jj_consume_token(13);
            label_10: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case NUMBER:
                case FLOAT_NUMBER:
                    ;
                    break;
                default:
                    jj_la1[17] = jj_gen;
                    break label_10;
                }
                SFVec3fToken(value);
                label_11: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case 10:
                        ;
                        break;
                    default:
                        jj_la1[18] = jj_gen;
                        break label_11;
                    }
                    jj_consume_token(10);
                }
            }
            jj_consume_token(14);
            break;
        case NUMBER:
        case FLOAT_NUMBER:
            SFVec3fToken(value);
            break;
        default:
            jj_la1[19] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // /////////////////////////////////////////////
    // SF/MFRotation
    // /////////////////////////////////////////////
    final public void SFRotationToken(float value[]) throws ParseException {
        float x, y, z, w;
        x = SFFloatToken();
        y = SFFloatToken();
        z = SFFloatToken();
        w = SFFloatToken();
        value[0] = x;
        value[1] = y;
        value[2] = z;
        value[3] = w;
        addSFRotation(value);
    }

    final public void MFRotationToken() throws ParseException {
        float value[] = new float[4];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 13:
            jj_consume_token(13);
            label_12: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case NUMBER:
                case FLOAT_NUMBER:
                    ;
                    break;
                default:
                    jj_la1[20] = jj_gen;
                    break label_12;
                }
                SFRotationToken(value);
                label_13: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case 10:
                        ;
                        break;
                    default:
                        jj_la1[21] = jj_gen;
                        break label_13;
                    }
                    jj_consume_token(10);
                }
            }
            jj_consume_token(14);
            break;
        case NUMBER:
        case FLOAT_NUMBER:
            SFRotationToken(value);
            break;
        default:
            jj_la1[22] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // /////////////////////////////////////////////
    // SF/MFColor
    // /////////////////////////////////////////////
    final public void SFColorToken(float color[]) throws ParseException {
        float x, y, z;
        x = SFFloatToken();
        y = SFFloatToken();
        z = SFFloatToken();
        color[0] = x;
        color[1] = y;
        color[2] = z;
        addSFColor(color);
        // System.out.println("MFVec3fToken : " + value[0] + ", "+ value[1] +
        // ", " + value[2] );

    }

    final public void MFColorToken() throws ParseException {
        float color[] = new float[3];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 13:
            jj_consume_token(13);
            label_14: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case NUMBER:
                case FLOAT_NUMBER:
                    ;
                    break;
                default:
                    jj_la1[23] = jj_gen;
                    break label_14;
                }
                SFColorToken(color);
                label_15: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case 10:
                        ;
                        break;
                    default:
                        jj_la1[24] = jj_gen;
                        break label_15;
                    }
                    jj_consume_token(10);
                }
            }
            jj_consume_token(14);
            break;
        case NUMBER:
        case FLOAT_NUMBER:
            SFColorToken(color);
            break;
        default:
            jj_la1[25] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // /////////////////////////////////////////////
    // SF/MFString
    // /////////////////////////////////////////////
    final public String SFStringToken() throws ParseException {
        String value;
        Token t;
        t = jj_consume_token(STRING);
        value = t.image.substring(1, t.image.length() - 1);
        addSFString(value);
        {
            if (true)
                return value;
        }
        throw new Error("Missing return statement in function");
    }

    final public void MFStringToken() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case 13:
            jj_consume_token(13);
            label_16: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case STRING:
                    ;
                    break;
                default:
                    jj_la1[26] = jj_gen;
                    break label_16;
                }
                SFStringToken();
                label_17: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case 10:
                        ;
                        break;
                    default:
                        jj_la1[27] = jj_gen;
                        break label_17;
                    }
                    jj_consume_token(10);
                }
            }
            jj_consume_token(14);
            break;
        case STRING:
            SFStringToken();
            break;
        default:
            jj_la1[28] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // /////////////////////////////////////////////
    // SFImage
    // /////////////////////////////////////////////
    final public void SFImageToken() throws ParseException {
        label_18: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case NUMBER:
            case HEX_NUMBER:
                ;
                break;
            default:
                jj_la1[29] = jj_gen;
                break label_18;
            }
            SFInt32Token();
        }
    }

    final public String Def() throws ParseException {
        jj_consume_token(DEF);
        String nodeName = getNextToken().image;
        setDefName(nodeName);
        {
            if (true)
                return nodeName;
        }
        throw new Error("Missing return statement in function");
    }

    final public Node Use() throws ParseException {
        jj_consume_token(USE);
        String nodeName = getNextToken().image;
        Node defNode = findNode(nodeName);

        Node instanceNode = null;
        if (defNode != null) {
            Node parentNode = getCurrentNode();
            if (parentNode == null) {
                instanceNode = defNode.createInstanceNode();
                addNode(instanceNode);
            } else if (parentNode != defNode
                    && parentNode.isAncestorNode(defNode) == false) {
                instanceNode = defNode.createInstanceNode();
                addNode(instanceNode);
            }
        }

        {
            if (true)
                return instanceNode;
        }
        throw new Error("Missing return statement in function");
    }

    final public String RouteNodeName() throws ParseException {
        Token t;
        t = jj_consume_token(ID);
        {
            if (true)
                return t.image;
        }
        throw new Error("Missing return statement in function");
    }

    final public String RouteFieldName() throws ParseException {
        Token t;
        t = jj_consume_token(ID);
        {
            if (true)
                return t.image;
        }
        throw new Error("Missing return statement in function");
    }

    final public void Route() throws ParseException {
        String eventOutNodeName;
        String eventOutFieldName;
        String eventInNodeName;
        String eventInFieldName;
        jj_consume_token(ROUTE);
        eventOutNodeName = RouteNodeName();
        jj_consume_token(19);
        eventOutFieldName = RouteFieldName();
        jj_consume_token(TO);
        eventInNodeName = RouteNodeName();
        jj_consume_token(19);
        eventInFieldName = getNextToken().image;
        addRoute(eventOutNodeName, eventOutFieldName, eventInNodeName,
                eventInFieldName);
    }

    // /////////////////////////////////////////////
    //
    // Nodes
    //
    // /////////////////////////////////////////////
    final public void Node() throws ParseException {
        label_19: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
                ;
                break;
            default:
                jj_la1[30] = jj_gen;
                break label_19;
            }
            Def();
        }
        SFNode();
    }

    final public void SFNode() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case Anchor:
        case Billboard:
        case Collision:
        case Group:
        case Inline:
        case LOD:
        case Switch:
        case Transform:
            GroupingNode();
            break;
        case DirectionalLight:
        case PointLight:
        case SpotLight:
            LightNode();
            break;
        case TimeSensor:
            TimeSensor();
            break;
        case ColorInterpolator:
        case CoordinateInterpolator:
        case NormalInterpolator:
        case OrientationInterpolator:
        case PositionInterpolator:
        case ScalarInterpolator:
            InterpolatorNode();
            break;
        case CylinderSensor:
        case PlaneSensor:
        case ProximitySensor:
        case SphereSensor:
        case TouchSensor:
        case VisibilitySensor:
            SensorNode();
            break;
        case Script:
            Script();
            break;
        case AudioClip:
        case Sound:
        case Shape:
            CommonNode();
            break;
        case Background:
        case Fog:
        case NavigationInfo:
        case Viewpoint:
        case WorldInfo:
            BindableNode();
            break;
        case USE:
            Use();
            break;
        default:
            jj_la1[31] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void MFNode() throws ParseException {
        jj_consume_token(13);
        label_20: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case USE:
            case Anchor:
            case AudioClip:
            case Background:
            case Billboard:
            case Collision:
            case ColorInterpolator:
            case CoordinateInterpolator:
            case CylinderSensor:
            case DirectionalLight:
            case Fog:
            case Group:
            case Inline:
            case LOD:
            case NavigationInfo:
            case NormalInterpolator:
            case OrientationInterpolator:
            case PlaneSensor:
            case PointLight:
            case PositionInterpolator:
            case ProximitySensor:
            case ScalarInterpolator:
            case Script:
            case Sound:
            case SphereSensor:
            case SpotLight:
            case Shape:
            case Switch:
            case TimeSensor:
            case TouchSensor:
            case Transform:
            case Viewpoint:
            case VisibilitySensor:
            case WorldInfo:
                ;
                break;
            default:
                jj_la1[32] = jj_gen;
                break label_20;
            }
            SFNode();
        }
        jj_consume_token(14);
    }

    final public void SensorNode() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case CylinderSensor:
            CylinderSensor();
            break;
        case PlaneSensor:
            PlaneSensor();
            break;
        case ProximitySensor:
            ProximitySensor();
            break;
        case SphereSensor:
            SphereSensor();
            break;
        case TouchSensor:
            TouchSensor();
            break;
        case VisibilitySensor:
            VisibilitySensor();
            break;
        default:
            jj_la1[33] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void InterpolatorNode() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case CoordinateInterpolator:
            CoordinateInterpolator();
            break;
        case ScalarInterpolator:
            ScalarInterpolator();
            break;
        case PositionInterpolator:
            PositionInterpolator();
            break;
        case OrientationInterpolator:
            OrientationInterpolator();
            break;
        case NormalInterpolator:
            NormalInterpolator();
            break;
        case ColorInterpolator:
            ColorInterpolator();
            break;
        default:
            jj_la1[34] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void LightNode() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case DirectionalLight:
            DirectionalLight();
            break;
        case PointLight:
            PointLight();
            break;
        case SpotLight:
            SpotLight();
            break;
        default:
            jj_la1[35] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void GroupingNode() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case Anchor:
            Anchor();
            break;
        case Billboard:
            Billboard();
            break;
        case Collision:
            Collision();
            break;
        case Inline:
            Inline();
            break;
        case LOD:
            LOD();
            break;
        case Switch:
            Switch();
            break;
        case Transform:
            Transform();
            break;
        case Group:
            Group();
            break;
        default:
            jj_la1[36] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void CommonNode() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case AudioClip:
            AudioClip();
            break;
        case Sound:
            Sound();
            break;
        case Shape:
            Shape();
            break;
        default:
            jj_la1[37] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void GeometryNode() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case IndexedFaceSet:
            IndexedFaceSet();
            break;
        case IndexedLineSet:
            IndexedLineSet();
            break;
        case Box:
            Box();
            break;
        case Cone:
            Cone();
            break;
        case Extrusion:
            Extrusion();
            break;
        case PointSet:
            PointSet();
            break;
        case Sphere:
            Sphere();
            break;
        case Cylinder:
            Cylinder();
            break;
        case ElevationGrid:
            ElevationGrid();
            break;
        case Text:
            Text();
            break;
        default:
            jj_la1[38] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void BindableNode() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case Background:
            Background();
            break;
        case Viewpoint:
            Viewpoint();
            break;
        case Fog:
            Fog();
            break;
        case NavigationInfo:
            NavigationInfo();
            break;
        case WorldInfo:
            WorldInfo();
            break;
        default:
            jj_la1[39] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    // ////////////////////////////////////////////
    // Children
    // /////////////////////////////////////////////
    final public void ChildrenElement() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case USE:
        case Anchor:
        case AudioClip:
        case Background:
        case Billboard:
        case Collision:
        case ColorInterpolator:
        case CoordinateInterpolator:
        case CylinderSensor:
        case DirectionalLight:
        case Fog:
        case Group:
        case Inline:
        case LOD:
        case NavigationInfo:
        case NormalInterpolator:
        case OrientationInterpolator:
        case PlaneSensor:
        case PointLight:
        case PositionInterpolator:
        case ProximitySensor:
        case ScalarInterpolator:
        case Script:
        case Sound:
        case SphereSensor:
        case SpotLight:
        case Shape:
        case Switch:
        case TimeSensor:
        case TouchSensor:
        case Transform:
        case Viewpoint:
        case VisibilitySensor:
        case WorldInfo:
            SFNode();
            break;
        case NULL:
            jj_consume_token(NULL);
            break;
        default:
            jj_la1[40] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void Children() throws ParseException {
        jj_consume_token(children);
        label_21: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 13:
                ;
                break;
            default:
                jj_la1[41] = jj_gen;
                break label_21;
            }
            jj_consume_token(13);
        }
        label_22: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case NULL:
            case DEF:
            case USE:
            case Anchor:
            case AudioClip:
            case Background:
            case Billboard:
            case Collision:
            case ColorInterpolator:
            case CoordinateInterpolator:
            case CylinderSensor:
            case DirectionalLight:
            case Fog:
            case Group:
            case Inline:
            case LOD:
            case NavigationInfo:
            case NormalInterpolator:
            case OrientationInterpolator:
            case PlaneSensor:
            case PointLight:
            case PositionInterpolator:
            case ProximitySensor:
            case ScalarInterpolator:
            case Script:
            case Sound:
            case SphereSensor:
            case SpotLight:
            case Shape:
            case Switch:
            case TimeSensor:
            case TouchSensor:
            case Transform:
            case Viewpoint:
            case VisibilitySensor:
            case WorldInfo:
                ;
                break;
            default:
                jj_la1[42] = jj_gen;
                break label_22;
            }
            label_23: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case DEF:
                    ;
                    break;
                default:
                    jj_la1[43] = jj_gen;
                    break label_23;
                }
                Def();
            }
            ChildrenElement();
        }
        label_24: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 14:
                ;
                break;
            default:
                jj_la1[44] = jj_gen;
                break label_24;
            }
            jj_consume_token(14);
        }
    }

    final public void AddChildren() throws ParseException {
        jj_consume_token(addChildren);
        label_25: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 13:
                ;
                break;
            default:
                jj_la1[45] = jj_gen;
                break label_25;
            }
            jj_consume_token(13);
        }
        label_26: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case NULL:
            case DEF:
            case USE:
            case Anchor:
            case AudioClip:
            case Background:
            case Billboard:
            case Collision:
            case ColorInterpolator:
            case CoordinateInterpolator:
            case CylinderSensor:
            case DirectionalLight:
            case Fog:
            case Group:
            case Inline:
            case LOD:
            case NavigationInfo:
            case NormalInterpolator:
            case OrientationInterpolator:
            case PlaneSensor:
            case PointLight:
            case PositionInterpolator:
            case ProximitySensor:
            case ScalarInterpolator:
            case Script:
            case Sound:
            case SphereSensor:
            case SpotLight:
            case Shape:
            case Switch:
            case TimeSensor:
            case TouchSensor:
            case Transform:
            case Viewpoint:
            case VisibilitySensor:
            case WorldInfo:
                ;
                break;
            default:
                jj_la1[46] = jj_gen;
                break label_26;
            }
            label_27: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case DEF:
                    ;
                    break;
                default:
                    jj_la1[47] = jj_gen;
                    break label_27;
                }
                Def();
            }
            ChildrenElement();
        }
        label_28: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 14:
                ;
                break;
            default:
                jj_la1[48] = jj_gen;
                break label_28;
            }
            jj_consume_token(14);
        }
    }

    final public void RemoveChildren() throws ParseException {
        jj_consume_token(removeChildren);
        label_29: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 13:
                ;
                break;
            default:
                jj_la1[49] = jj_gen;
                break label_29;
            }
            jj_consume_token(13);
        }
        label_30: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case NULL:
            case DEF:
            case USE:
            case Anchor:
            case AudioClip:
            case Background:
            case Billboard:
            case Collision:
            case ColorInterpolator:
            case CoordinateInterpolator:
            case CylinderSensor:
            case DirectionalLight:
            case Fog:
            case Group:
            case Inline:
            case LOD:
            case NavigationInfo:
            case NormalInterpolator:
            case OrientationInterpolator:
            case PlaneSensor:
            case PointLight:
            case PositionInterpolator:
            case ProximitySensor:
            case ScalarInterpolator:
            case Script:
            case Sound:
            case SphereSensor:
            case SpotLight:
            case Shape:
            case Switch:
            case TimeSensor:
            case TouchSensor:
            case Transform:
            case Viewpoint:
            case VisibilitySensor:
            case WorldInfo:
                ;
                break;
            default:
                jj_la1[50] = jj_gen;
                break label_30;
            }
            label_31: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case DEF:
                    ;
                    break;
                default:
                    jj_la1[51] = jj_gen;
                    break label_31;
                }
                Def();
            }
            ChildrenElement();
        }
        label_32: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 14:
                ;
                break;
            default:
                jj_la1[52] = jj_gen;
                break label_32;
            }
            jj_consume_token(14);
        }
    }

    final public void AnchorURLID() throws ParseException {
        jj_consume_token(url);
        pushNode(getCurrentNode(), parserTypeAnchorURL);
    }

    final public void AnchorParameterID() throws ParseException {
        jj_consume_token(parameter);
        pushNode(getCurrentNode(), parserTypeAnchorParameter);
    }

    final public void AnchorElement() throws ParseException {
        float vec[] = new float[3];
        String value;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case url:
            AnchorURLID();
            MFStringToken();
            popNode();
            break;
        case parameter:
            AnchorParameterID();
            MFStringToken();
            popNode();
            break;
        case description:
            jj_consume_token(description);
            value = SFStringToken();
            ((AnchorNode) getCurrentNode()).setDescription(value);
            break;
        case bboxCenter:
            jj_consume_token(bboxCenter);
            SFVec3fToken(vec);
            ((AnchorNode) getCurrentNode()).setBoundingBoxCenter(vec);
            break;
        case bboxSize:
            jj_consume_token(bboxSize);
            SFVec3fToken(vec);
            ((AnchorNode) getCurrentNode()).setBoundingBoxSize(vec);
            break;
        case children:
            Children();
            break;
        default:
            jj_la1[53] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void AnchorID() throws ParseException {
        jj_consume_token(Anchor);
        AnchorNode anchor = new AnchorNode();
        anchor.setName(getDefName());
        addNode(anchor);
        pushNode(anchor, parserTypeAnchor);
    }

    final public void Anchor() throws ParseException {
        AnchorID();
        NodeBegin();
        label_33: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case children:
            case url:
            case parameter:
            case description:
            case bboxCenter:
            case bboxSize:
                ;
                break;
            default:
                jj_la1[54] = jj_gen;
                break label_33;
            }
            AnchorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void AppearanceElement() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case material:
            jj_consume_token(material);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Material:
                label_34: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[55] = jj_gen;
                        break label_34;
                    }
                    Def();
                }
                Material();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[56] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case textureTransform:
            jj_consume_token(textureTransform);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case TextureTransform:
                label_35: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[57] = jj_gen;
                        break label_35;
                    }
                    Def();
                }
                TextureTransform();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[58] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case texture:
            jj_consume_token(texture);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case ImageTexture:
            case MovieTexture:
            case PixelTexture:
                label_36: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[59] = jj_gen;
                        break label_36;
                    }
                    Def();
                }
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case ImageTexture:
                    ImageTexture();
                    break;
                case MovieTexture:
                    MovieTexture();
                    break;
                case PixelTexture:
                    PixelTexture();
                    break;
                default:
                    jj_la1[60] = jj_gen;
                    jj_consume_token(-1);
                    throw new ParseException();
                }
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[61] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        default:
            jj_la1[62] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void AppearanceID() throws ParseException {
        jj_consume_token(Appearance);
        AppearanceNode apper = new AppearanceNode();
        apper.setName(getDefName());
        addNode(apper);
        pushNode(apper, parserTypeAppearance);
    }

    final public void Appearance() throws ParseException {
        AppearanceID();
        NodeBegin();
        label_37: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case material:
            case textureTransform:
            case texture:
                ;
                break;
            default:
                jj_la1[63] = jj_gen;
                break label_37;
            }
            AppearanceElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void AudioClipURLID() throws ParseException {
        jj_consume_token(url);
        pushNode(getCurrentNode(), parserTypeAudioClipURL);
    }

    final public void AudioClipElement() throws ParseException {
        String svalue;
        boolean bvalue;
        float fvalue;
        double dvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case url:
            AudioClipURLID();
            MFStringToken();
            popNode();
            break;
        case description:
            jj_consume_token(description);
            svalue = SFStringToken();
            ((AudioClipNode) getCurrentNode()).setDescription(svalue);
            break;
        case loop:
            jj_consume_token(loop);
            bvalue = SFBoolToken();
            ((AudioClipNode) getCurrentNode()).setLoop(bvalue);
            break;
        case pitch:
            jj_consume_token(pitch);
            fvalue = SFFloatToken();
            ((AudioClipNode) getCurrentNode()).setPitch(fvalue);
            break;
        case startTime:
            jj_consume_token(startTime);
            dvalue = SFTimeToken();
            ((AudioClipNode) getCurrentNode()).setStartTime(dvalue);
            break;
        case stopTime:
            jj_consume_token(stopTime);
            dvalue = SFTimeToken();
            ((AudioClipNode) getCurrentNode()).setStopTime(dvalue);
            break;
        default:
            jj_la1[64] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void AudioClipID() throws ParseException {
        jj_consume_token(AudioClip);
        AudioClipNode aclip = new AudioClipNode();
        aclip.setName(getDefName());
        addNode(aclip);
        pushNode(aclip, parserTypeAudioClip);
    }

    final public void AudioClip() throws ParseException {
        AudioClipID();
        NodeBegin();
        label_38: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case url:
            case description:
            case loop:
            case pitch:
            case startTime:
            case stopTime:
                ;
                break;
            default:
                jj_la1[65] = jj_gen;
                break label_38;
            }
            AudioClipElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void BackgroundBackURLID() throws ParseException {
        jj_consume_token(backURL);
        pushNode(getCurrentNode(), parserTypeBackgroundBackURL);
    }

    final public void BackgroundBottomURLID() throws ParseException {
        jj_consume_token(bottomURL);
        pushNode(getCurrentNode(), parserTypeBackgroundBottomURL);
    }

    final public void BackgroundFrontURLID() throws ParseException {
        jj_consume_token(frontURL);
        pushNode(getCurrentNode(), parserTypeBackgroundFrontURL);
    }

    final public void BackgroundLeftURLID() throws ParseException {
        jj_consume_token(leftURL);
        pushNode(getCurrentNode(), parserTypeBackgroundLeftURL);
    }

    final public void BackgroundRightURLID() throws ParseException {
        jj_consume_token(rightURL);
        pushNode(getCurrentNode(), parserTypeBackgroundRightURL);
    }

    final public void BackgroundTopURLID() throws ParseException {
        jj_consume_token(topURL);
        pushNode(getCurrentNode(), parserTypeBackgroundTopURL);
    }

    final public void BackgroundGroundAngleID() throws ParseException {
        jj_consume_token(groundAngle);
        pushNode(getCurrentNode(), parserTypeBackgroundGroundAngle);
    }

    final public void BackgroundSkyAngleID() throws ParseException {
        jj_consume_token(skyAngle);
        pushNode(getCurrentNode(), parserTypeBackgroundSkyAngle);
    }

    final public void BackgroundGroundColorID() throws ParseException {
        jj_consume_token(groundColor);
        pushNode(getCurrentNode(), parserTypeBackgroundGroundColor);
    }

    final public void BackgroundSkyColorID() throws ParseException {
        jj_consume_token(skyColor);
        pushNode(getCurrentNode(), parserTypeBackgroundSkyColor);
    }

    final public void BackgroundElement() throws ParseException {
        float vec[] = new float[3];
        String value;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case backURL:
            BackgroundBackURLID();
            MFStringToken();
            popNode();
            break;
        case bottomURL:
            BackgroundBottomURLID();
            MFStringToken();
            popNode();
            break;
        case frontURL:
            BackgroundFrontURLID();
            MFStringToken();
            popNode();
            break;
        case leftURL:
            BackgroundLeftURLID();
            MFStringToken();
            popNode();
            break;
        case rightURL:
            BackgroundRightURLID();
            MFStringToken();
            popNode();
            break;
        case topURL:
            BackgroundTopURLID();
            MFStringToken();
            popNode();
            break;
        case groundAngle:
            BackgroundGroundAngleID();
            MFFloatToken();
            popNode();
            break;
        case skyAngle:
            BackgroundSkyAngleID();
            MFFloatToken();
            popNode();
            break;
        case groundColor:
            BackgroundGroundColorID();
            MFColorToken();
            popNode();
            break;
        case skyColor:
            BackgroundSkyColorID();
            MFColorToken();
            popNode();
            break;
        default:
            jj_la1[66] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void BackgroundID() throws ParseException {
        jj_consume_token(Background);
        BackgroundNode bg = new BackgroundNode();
        bg.setName(getDefName());
        addNode(bg);
        pushNode(bg, parserTypeBackground);
    }

    final public void Background() throws ParseException {
        BackgroundID();
        NodeBegin();
        label_39: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case backURL:
            case bottomURL:
            case frontURL:
            case leftURL:
            case rightURL:
            case topURL:
            case groundAngle:
            case skyAngle:
            case groundColor:
            case skyColor:
                ;
                break;
            default:
                jj_la1[67] = jj_gen;
                break label_39;
            }
            BackgroundElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void BillboardElement() throws ParseException {
        float vec[] = new float[3];
        float value[] = new float[3];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case axisOfRotation:
            jj_consume_token(axisOfRotation);
            SFVec3fToken(value);
            ((BillboardNode) getCurrentNode()).setAxisOfRotation(value);
            break;
        case bboxCenter:
            jj_consume_token(bboxCenter);
            SFVec3fToken(vec);
            ((BillboardNode) getCurrentNode()).setBoundingBoxCenter(vec);
            break;
        case bboxSize:
            jj_consume_token(bboxSize);
            SFVec3fToken(vec);
            ((BillboardNode) getCurrentNode()).setBoundingBoxSize(vec);
            break;
        case children:
            Children();
            break;
        default:
            jj_la1[68] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void BillboardID() throws ParseException {
        jj_consume_token(Billboard);
        BillboardNode billboard = new BillboardNode();
        billboard.setName(getDefName());
        addNode(billboard);
        pushNode(billboard, parserTypeBillboard);
    }

    final public void Billboard() throws ParseException {
        BillboardID();
        NodeBegin();
        label_40: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case children:
            case bboxCenter:
            case bboxSize:
            case axisOfRotation:
                ;
                break;
            default:
                jj_la1[69] = jj_gen;
                break label_40;
            }
            BillboardElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void BoxElement() throws ParseException {
        float value[] = new float[3];
        jj_consume_token(size);
        SFVec3fToken(value);
        ((BoxNode) getCurrentNode()).setSize(value);
    }

    final public void BoxID() throws ParseException {
        jj_consume_token(Box);
        BoxNode box = new BoxNode();
        box.setName(getDefName());
        addNode(box);
        pushNode(box, parserTypeBox);
    }

    final public void Box() throws ParseException {
        BoxID();
        NodeBegin();
        label_41: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case size:
                ;
                break;
            default:
                jj_la1[70] = jj_gen;
                break label_41;
            }
            BoxElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void CollisionElement() throws ParseException {
        float vec[] = new float[3];
        boolean value;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case collide:
            jj_consume_token(collide);
            value = SFBoolToken();
            ((CollisionNode) getCurrentNode()).setCollide(value);
            break;
        case bboxCenter:
            jj_consume_token(bboxCenter);
            SFVec3fToken(vec);
            ((CollisionNode) getCurrentNode()).setBoundingBoxCenter(vec);
            break;
        case bboxSize:
            jj_consume_token(bboxSize);
            SFVec3fToken(vec);
            ((CollisionNode) getCurrentNode()).setBoundingBoxSize(vec);
            break;
        case children:
            Children();
            break;
        case proxy:
            jj_consume_token(proxy);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case USE:
            case Anchor:
            case AudioClip:
            case Background:
            case Billboard:
            case Collision:
            case ColorInterpolator:
            case CoordinateInterpolator:
            case CylinderSensor:
            case DirectionalLight:
            case Fog:
            case Group:
            case Inline:
            case LOD:
            case NavigationInfo:
            case NormalInterpolator:
            case OrientationInterpolator:
            case PlaneSensor:
            case PointLight:
            case PositionInterpolator:
            case ProximitySensor:
            case ScalarInterpolator:
            case Script:
            case Sound:
            case SphereSensor:
            case SpotLight:
            case Shape:
            case Switch:
            case TimeSensor:
            case TouchSensor:
            case Transform:
            case Viewpoint:
            case VisibilitySensor:
            case WorldInfo:
                SFNode();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[71] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        default:
            jj_la1[72] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void CollisionID() throws ParseException {
        jj_consume_token(Collision);
        CollisionNode collision = new CollisionNode();
        collision.setName(getDefName());
        addNode(collision);
        pushNode(collision, parserTypeCollision);
    }

    final public void Collision() throws ParseException {
        CollisionID();
        NodeBegin();
        label_42: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case children:
            case bboxCenter:
            case bboxSize:
            case collide:
            case proxy:
                ;
                break;
            default:
                jj_la1[73] = jj_gen;
                break label_42;
            }
            CollisionElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void ColorID() throws ParseException {
        jj_consume_token(Color);
        ColorNode color = new ColorNode();
        color.setName(getDefName());
        addNode(color);
        pushNode(color, parserTypeColor);
    }

    final public void Color() throws ParseException {
        ColorID();
        NodeBegin();
        jj_consume_token(color);
        MFColorToken();
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void ColorInterpolatorKeyID() throws ParseException {
        jj_consume_token(key);
        pushNode(getCurrentNode(), parserTypeColorInterpolatorKey);
    }

    final public void ColorInterpolatorKeyValueID() throws ParseException {
        jj_consume_token(keyValue);
        pushNode(getCurrentNode(), parserTypeColorInterpolatorKeyValue);
    }

    final public void ColorInterpolatorID() throws ParseException {
        jj_consume_token(ColorInterpolator);
        ColorInterpolatorNode colorInterp = new ColorInterpolatorNode();
        colorInterp.setName(getDefName());
        addNode(colorInterp);
        pushNode(colorInterp, parserTypeColorInterpolator);
    }

    final public void ColorInterpolatorElement() throws ParseException {
        float value3f[] = new float[3];
        float value;
        boolean ok;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case key:
            ColorInterpolatorKeyID();
            MFFloatToken();
            popNode();
            break;
        case keyValue:
            ColorInterpolatorKeyValueID();
            MFColorToken();
            popNode();
            break;
        default:
            jj_la1[74] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void ColorInterpolator() throws ParseException {
        ColorInterpolatorID();
        NodeBegin();
        label_43: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case key:
            case keyValue:
                ;
                break;
            default:
                jj_la1[75] = jj_gen;
                break label_43;
            }
            ColorInterpolatorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void ConeElement() throws ParseException {
        boolean bvalue;
        float fvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case side:
            jj_consume_token(side);
            bvalue = SFBoolToken();
            ((ConeNode) getCurrentNode()).setSide(bvalue);
            break;
        case bottom:
            jj_consume_token(bottom);
            bvalue = SFBoolToken();
            ((ConeNode) getCurrentNode()).setBottom(bvalue);
            break;
        case height:
            jj_consume_token(height);
            fvalue = SFFloatToken();
            ((ConeNode) getCurrentNode()).setHeight(fvalue);
            break;
        case bottomRadius:
            jj_consume_token(bottomRadius);
            fvalue = SFFloatToken();
            ((ConeNode) getCurrentNode()).setBottomRadius(fvalue);
            break;
        default:
            jj_la1[76] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void ConeID() throws ParseException {
        jj_consume_token(Cone);
        ConeNode cone = new ConeNode();
        cone.setName(getDefName());
        addNode(cone);
        pushNode(cone, parserTypeCone);
    }

    final public void Cone() throws ParseException {
        ConeID();
        NodeBegin();
        label_44: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case height:
            case bottomRadius:
            case side:
            case bottom:
                ;
                break;
            default:
                jj_la1[77] = jj_gen;
                break label_44;
            }
            ConeElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void CoordinateID() throws ParseException {
        jj_consume_token(Coordinate);
        CoordinateNode coord = new CoordinateNode();
        coord.setName(getDefName());
        addNode(coord);
        pushNode(coord, parserTypeCoordinate);
    }

    final public void Coordinate() throws ParseException {
        CoordinateID();
        NodeBegin();
        jj_consume_token(point);
        MFVec3fToken();
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void CoordinateInterpolatorKeyID() throws ParseException {
        jj_consume_token(key);
        pushNode(getCurrentNode(), parserTypeCoordinateInterpolatorKey);
    }

    final public void CoordinateInterpolatorKeyValueID() throws ParseException {
        jj_consume_token(keyValue);
        pushNode(getCurrentNode(), parserTypeCoordinateInterpolatorKeyValue);
    }

    final public void CoordinateInterpolatorID() throws ParseException {
        jj_consume_token(CoordinateInterpolator);
        CoordinateInterpolatorNode coordInterp = new CoordinateInterpolatorNode();
        coordInterp.setName(getDefName());
        addNode(coordInterp);
        pushNode(coordInterp, parserTypeCoordinateInterpolator);
    }

    final public void CoordinateInterpolatorElement() throws ParseException {
        float value3f[] = new float[3];
        float value;
        boolean ok;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case key:
            CoordinateInterpolatorKeyID();
            MFFloatToken();
            popNode();
            break;
        case keyValue:
            CoordinateInterpolatorKeyValueID();
            MFVec3fToken();
            popNode();
            break;
        default:
            jj_la1[78] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void CoordinateInterpolator() throws ParseException {
        CoordinateInterpolatorID();
        NodeBegin();
        label_45: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case key:
            case keyValue:
                ;
                break;
            default:
                jj_la1[79] = jj_gen;
                break label_45;
            }
            CoordinateInterpolatorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void CylinderElement() throws ParseException {
        boolean bvalue;
        float fvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case side:
            jj_consume_token(side);
            bvalue = SFBoolToken();
            ((CylinderNode) getCurrentNode()).setSide(bvalue);
            break;
        case bottom:
            jj_consume_token(bottom);
            bvalue = SFBoolToken();
            ((CylinderNode) getCurrentNode()).setBottom(bvalue);
            break;
        case top:
            jj_consume_token(top);
            bvalue = SFBoolToken();
            ((CylinderNode) getCurrentNode()).setTop(bvalue);
            break;
        case height:
            jj_consume_token(height);
            fvalue = SFFloatToken();
            ((CylinderNode) getCurrentNode()).setHeight(fvalue);
            break;
        case radius:
            jj_consume_token(radius);
            fvalue = SFFloatToken();
            ((CylinderNode) getCurrentNode()).setRadius(fvalue);
            break;
        default:
            jj_la1[80] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void CylinderID() throws ParseException {
        jj_consume_token(Cylinder);
        CylinderNode cylinder = new CylinderNode();
        cylinder.setName(getDefName());
        addNode(cylinder);
        pushNode(cylinder, parserTypeCylinder);
    }

    final public void Cylinder() throws ParseException {
        CylinderID();
        NodeBegin();
        label_46: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case height:
            case side:
            case bottom:
            case top:
            case radius:
                ;
                break;
            default:
                jj_la1[81] = jj_gen;
                break label_46;
            }
            CylinderElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void CylinderSensorElement() throws ParseException {
        boolean bvalue;
        float fvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case minAngle:
            jj_consume_token(minAngle);
            fvalue = SFFloatToken();
            ((CylinderSensorNode) getCurrentNode()).setMinAngle(fvalue);
            break;
        case maxAngle:
            jj_consume_token(maxAngle);
            fvalue = SFFloatToken();
            ((CylinderSensorNode) getCurrentNode()).setMaxAngle(fvalue);
            break;
        case diskAngle:
            jj_consume_token(diskAngle);
            fvalue = SFFloatToken();
            ((CylinderSensorNode) getCurrentNode()).setDiskAngle(fvalue);
            break;
        case offset:
            jj_consume_token(offset);
            fvalue = SFFloatToken();
            ((CylinderSensorNode) getCurrentNode()).setOffset(fvalue);
            break;
        case enabled:
            jj_consume_token(enabled);
            bvalue = SFBoolToken();
            ((CylinderSensorNode) getCurrentNode()).setEnabled(bvalue);
            break;
        case autoOffset:
            jj_consume_token(autoOffset);
            bvalue = SFBoolToken();
            ((CylinderSensorNode) getCurrentNode()).setAutoOffset(bvalue);
            break;
        default:
            jj_la1[82] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void CylinderSensorID() throws ParseException {
        jj_consume_token(CylinderSensor);
        CylinderSensorNode sensor = new CylinderSensorNode();
        sensor.setName(getDefName());
        addNode(sensor);
        pushNode(sensor, parserTypeCylinderSensor);
    }

    final public void CylinderSensor() throws ParseException {
        CylinderSensorID();
        NodeBegin();
        label_47: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case minAngle:
            case maxAngle:
            case enabled:
            case diskAngle:
            case offset:
            case autoOffset:
                ;
                break;
            default:
                jj_la1[83] = jj_gen;
                break label_47;
            }
            CylinderSensorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void DirectionalLightElement() throws ParseException {
        float value3f[] = new float[3];
        float value;
        boolean ok;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case on:
            jj_consume_token(on);
            ok = SFBoolToken();
            ((DirectionalLightNode) getCurrentNode()).setOn(ok);
            break;
        case intensity:
            jj_consume_token(intensity);
            value = SFFloatToken();
            ((DirectionalLightNode) getCurrentNode()).setIntensity(value);
            break;
        case ambientIntensity:
            jj_consume_token(ambientIntensity);
            value = SFFloatToken();
            ((DirectionalLightNode) getCurrentNode())
                    .setAmbientIntensity(value);
            break;
        case color:
            jj_consume_token(color);
            SFColorToken(value3f);
            ((DirectionalLightNode) getCurrentNode()).setColor(value3f);
            break;
        case direction:
            jj_consume_token(direction);
            SFVec3fToken(value3f);
            ((DirectionalLightNode) getCurrentNode()).setDirection(value3f);
            break;
        default:
            jj_la1[84] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void DirectionalLightID() throws ParseException {
        jj_consume_token(DirectionalLight);
        DirectionalLightNode light = new DirectionalLightNode();
        light.setName(getDefName());
        addNode(light);
        pushNode(light, parserTypeDirectionalLight);
    }

    final public void DirectionalLight() throws ParseException {
        DirectionalLightID();
        NodeBegin();
        label_48: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case color:
            case on:
            case intensity:
            case ambientIntensity:
            case direction:
                ;
                break;
            default:
                jj_la1[85] = jj_gen;
                break label_48;
            }
            DirectionalLightElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void ElevationGridHeightID() throws ParseException {
        jj_consume_token(height);
        pushNode(getCurrentNode(), parserTypeElevationGridHeight);
    }

    final public void ElevationGridElement() throws ParseException {
        boolean bvalue;
        float fvalue;
        int ivalue;
        double dvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case height:
            ElevationGridHeightID();
            MFFloatToken();
            popNode();
            break;
        case ccw:
            jj_consume_token(ccw);
            bvalue = SFBoolToken();
            ((ElevationGridNode) getCurrentNode()).setCCW(bvalue);
            break;
        case colorPerVertex:
            jj_consume_token(colorPerVertex);
            bvalue = SFBoolToken();
            ((ElevationGridNode) getCurrentNode()).setColorPerVertex(bvalue);
            break;
        case creaseAngle:
            jj_consume_token(creaseAngle);
            fvalue = SFFloatToken();
            ((ElevationGridNode) getCurrentNode()).setCreaseAngle(fvalue);
            break;
        case solid:
            jj_consume_token(solid);
            bvalue = SFBoolToken();
            ((ElevationGridNode) getCurrentNode()).setSolid(bvalue);
            break;
        case normalPerVertex:
            jj_consume_token(normalPerVertex);
            bvalue = SFBoolToken();
            ((ElevationGridNode) getCurrentNode()).setNormalPerVertex(bvalue);
            break;
        case xDimension:
            jj_consume_token(xDimension);
            ivalue = SFInt32Token();
            ((ElevationGridNode) getCurrentNode()).setXDimension(ivalue);
            break;
        case xSpacing:
            jj_consume_token(xSpacing);
            fvalue = SFFloatToken();
            ((ElevationGridNode) getCurrentNode()).setXSpacing(fvalue);
            break;
        case zDimension:
            jj_consume_token(zDimension);
            ivalue = SFInt32Token();
            ((ElevationGridNode) getCurrentNode()).setZDimension(ivalue);
            break;
        case zSpacing:
            jj_consume_token(zSpacing);
            fvalue = SFFloatToken();
            ((ElevationGridNode) getCurrentNode()).setZSpacing(fvalue);
            break;
        case normal:
            jj_consume_token(normal);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Normal:
                label_49: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[86] = jj_gen;
                        break label_49;
                    }
                    Def();
                }
                Normal();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[87] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case color:
            jj_consume_token(color);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Color:
                label_50: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[88] = jj_gen;
                        break label_50;
                    }
                    Def();
                }
                Color();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[89] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case texCoord:
            jj_consume_token(texCoord);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case TextureCoordinate:
                label_51: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[90] = jj_gen;
                        break label_51;
                    }
                    Def();
                }
                TextureCoordinate();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[91] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        default:
            jj_la1[92] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void ElevationGridID() throws ParseException {
        jj_consume_token(ElevationGrid);
        ElevationGridNode egrid = new ElevationGridNode();
        egrid.setName(getDefName());
        addNode(egrid);
        pushNode(egrid, parserTypeElevationGrid);
    }

    final public void ElevationGrid() throws ParseException {
        ElevationGridID();
        NodeBegin();
        label_52: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case color:
            case height:
            case ccw:
            case colorPerVertex:
            case creaseAngle:
            case normalPerVertex:
            case solid:
            case xDimension:
            case xSpacing:
            case zDimension:
            case zSpacing:
            case normal:
            case texCoord:
                ;
                break;
            default:
                jj_la1[93] = jj_gen;
                break label_52;
            }
            ElevationGridElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void ExtrusionCrossSectionID() throws ParseException {
        jj_consume_token(crossSection);
        pushNode(getCurrentNode(), parserTypeExtrusionCrossSection);
    }

    final public void ExtrusionOrientationID() throws ParseException {
        jj_consume_token(orientation);
        pushNode(getCurrentNode(), parserTypeExtrusionOrientation);
    }

    final public void ExtrusionScaleID() throws ParseException {
        jj_consume_token(scale);
        pushNode(getCurrentNode(), parserTypeExtrusionScale);
    }

    final public void ExtrusionSpineID() throws ParseException {
        jj_consume_token(spine);
        pushNode(getCurrentNode(), parserTypeExtrusionSpine);
    }

    final public void ExtrusionElement() throws ParseException {
        boolean bvalue;
        float fvalue;
        int ivalue;
        double dvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case crossSection:
            ExtrusionCrossSectionID();
            MFVec2fToken();
            popNode();
            break;
        case orientation:
            ExtrusionOrientationID();
            MFRotationToken();
            popNode();
            break;
        case scale:
            ExtrusionScaleID();
            MFVec2fToken();
            popNode();
            break;
        case spine:
            ExtrusionSpineID();
            MFVec3fToken();
            popNode();
            break;
        case ccw:
            jj_consume_token(ccw);
            bvalue = SFBoolToken();
            ((ExtrusionNode) getCurrentNode()).setCCW(bvalue);
            break;
        case convex:
            jj_consume_token(convex);
            bvalue = SFBoolToken();
            ((ExtrusionNode) getCurrentNode()).setConvex(bvalue);
            break;
        case beginCap:
            jj_consume_token(beginCap);
            bvalue = SFBoolToken();
            ((ExtrusionNode) getCurrentNode()).setBeginCap(bvalue);
            break;
        case endCap:
            jj_consume_token(endCap);
            bvalue = SFBoolToken();
            ((ExtrusionNode) getCurrentNode()).setEndCap(bvalue);
            break;
        case creaseAngle:
            jj_consume_token(creaseAngle);
            fvalue = SFFloatToken();
            ((ExtrusionNode) getCurrentNode()).setCreaseAngle(fvalue);
            break;
        case solid:
            jj_consume_token(solid);
            bvalue = SFBoolToken();
            ((ExtrusionNode) getCurrentNode()).setSolid(bvalue);
            break;
        default:
            jj_la1[94] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void ExtrusionID() throws ParseException {
        jj_consume_token(Extrusion);
        ExtrusionNode extrusion = new ExtrusionNode();
        extrusion.setName(getDefName());
        addNode(extrusion);
        pushNode(extrusion, parserTypeExtrusion);
    }

    final public void Extrusion() throws ParseException {
        ExtrusionID();
        NodeBegin();
        label_53: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case ccw:
            case creaseAngle:
            case solid:
            case beginCap:
            case endCap:
            case crossSection:
            case spine:
            case convex:
            case scale:
            case orientation:
                ;
                break;
            default:
                jj_la1[95] = jj_gen;
                break label_53;
            }
            ExtrusionElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void FogElement() throws ParseException {
        String svalue;
        float fvalue;
        float value3[] = new float[3];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case color:
            jj_consume_token(color);
            SFColorToken(value3);
            ((FogNode) getCurrentNode()).setColor(value3);
            break;
        case fogType:
            jj_consume_token(fogType);
            svalue = SFStringToken();
            ((FogNode) getCurrentNode()).setFogType(svalue);
            break;
        case visibilityRange:
            jj_consume_token(visibilityRange);
            fvalue = SFFloatToken();
            ((FogNode) getCurrentNode()).setVisibilityRange(fvalue);
            break;
        default:
            jj_la1[96] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void FogID() throws ParseException {
        jj_consume_token(Fog);
        FogNode fog = new FogNode();
        fog.setName(getDefName());
        addNode(fog);
        pushNode(fog, parserTypeFog);
    }

    final public void Fog() throws ParseException {
        FogID();
        NodeBegin();
        label_54: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case color:
            case fogType:
            case visibilityRange:
                ;
                break;
            default:
                jj_la1[97] = jj_gen;
                break label_54;
            }
            FogElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void FontStyleFamilyID() throws ParseException {
        jj_consume_token(family);
        pushNode(getCurrentNode(), parserTypeFontStyleFamily);
    }

    final public void FontStyleJustifyID() throws ParseException {
        jj_consume_token(justify);
        pushNode(getCurrentNode(), parserTypeFontStyleJustify);
    }

    final public void FontStyleElement() throws ParseException {
        String value;
        boolean bvalue;
        float fvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case family:
            FontStyleFamilyID();
            MFStringToken();
            popNode();
            break;
        case justify:
            FontStyleJustifyID();
            MFStringToken();
            popNode();
            break;
        case language:
            jj_consume_token(language);
            value = SFStringToken();
            ((FontStyleNode) getCurrentNode()).setLanguage(value);
            break;
        case style:
            jj_consume_token(style);
            value = SFStringToken();
            ((FontStyleNode) getCurrentNode()).setStyle(value);
            break;
        case horizontal:
            jj_consume_token(horizontal);
            bvalue = SFBoolToken();
            ((FontStyleNode) getCurrentNode()).setHorizontal(bvalue);
            break;
        case leftToRight:
            jj_consume_token(leftToRight);
            bvalue = SFBoolToken();
            ((FontStyleNode) getCurrentNode()).setLeftToRight(bvalue);
            break;
        case topToBottom:
            jj_consume_token(topToBottom);
            bvalue = SFBoolToken();
            ((FontStyleNode) getCurrentNode()).setTopToBottom(bvalue);
            break;
        case size:
            jj_consume_token(size);
            fvalue = SFFloatToken();
            ((FontStyleNode) getCurrentNode()).setSize(fvalue);
            break;
        case spacing:
            jj_consume_token(spacing);
            fvalue = SFFloatToken();
            ((FontStyleNode) getCurrentNode()).setSpacing(fvalue);
            break;
        default:
            jj_la1[98] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void FontStyleID() throws ParseException {
        jj_consume_token(FontStyle);
        FontStyleNode fontStyle = new FontStyleNode();
        fontStyle.setName(getDefName());
        addNode(fontStyle);
        pushNode(fontStyle, parserTypeFontStyle);
    }

    final public void FontStyle() throws ParseException {
        FontStyleID();
        NodeBegin();
        label_55: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case size:
            case justify:
            case family:
            case style:
            case horizontal:
            case leftToRight:
            case topToBottom:
            case language:
            case spacing:
                ;
                break;
            default:
                jj_la1[99] = jj_gen;
                break label_55;
            }
            FontStyleElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void GroupElement() throws ParseException {
        float vec[] = new float[3];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case bboxCenter:
            jj_consume_token(bboxCenter);
            SFVec3fToken(vec);
            ((GroupNode) getCurrentNode()).setBoundingBoxCenter(vec);
            break;
        case bboxSize:
            jj_consume_token(bboxSize);
            SFVec3fToken(vec);
            ((GroupNode) getCurrentNode()).setBoundingBoxSize(vec);
            break;
        case children:
            Children();
            break;
        case addChildren:
            AddChildren();
            break;
        case removeChildren:
            RemoveChildren();
            break;
        default:
            jj_la1[100] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void GroupID() throws ParseException {
        String name = null;
        jj_consume_token(Group);
        GroupNode group = new GroupNode();
        group.setName(getDefName());
        addNode(group);
        pushNode(group, parserTypeGroup);
    }

    final public void Group() throws ParseException {
        GroupID();
        NodeBegin();
        label_56: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case children:
            case addChildren:
            case removeChildren:
            case bboxCenter:
            case bboxSize:
                ;
                break;
            default:
                jj_la1[101] = jj_gen;
                break label_56;
            }
            GroupElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void ImageTextureURLID() throws ParseException {
        jj_consume_token(url);
        pushNode(getCurrentNode(), parserTypeImageTextureURL);
    }

    final public void ImageTextureElement() throws ParseException {
        boolean bvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case url:
            ImageTextureURLID();
            MFStringToken();
            popNode();
            break;
        case repeatS:
            jj_consume_token(repeatS);
            bvalue = SFBoolToken();
            ((ImageTextureNode) getCurrentNode()).setRepeatS(bvalue);
            break;
        case repeatT:
            jj_consume_token(repeatT);
            bvalue = SFBoolToken();
            ((ImageTextureNode) getCurrentNode()).setRepeatT(bvalue);
            break;
        default:
            jj_la1[102] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void ImageTextureID() throws ParseException {
        jj_consume_token(ImageTexture);
        ImageTextureNode texture = new ImageTextureNode();
        texture.setName(getDefName());
        addNode(texture);
        pushNode(texture, parserTypeImageTexture);
    }

    final public void ImageTexture() throws ParseException {
        ImageTextureID();
        NodeBegin();
        label_57: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case url:
            case repeatS:
            case repeatT:
                ;
                break;
            default:
                jj_la1[103] = jj_gen;
                break label_57;
            }
            ImageTextureElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void IdxFaceSetCoordIndexID() throws ParseException {
        jj_consume_token(coordIndex);
        pushNode(getCurrentNode(), parserTypeIdxFaceSetCoordIndex);
    }

    final public void IdxFaceSetColorIndexID() throws ParseException {
        jj_consume_token(colorIndex);
        pushNode(getCurrentNode(), parserTypeIdxFaceSetColorIndex);
    }

    final public void IdxFaceSetNormalIndexID() throws ParseException {
        jj_consume_token(normalIndex);
        pushNode(getCurrentNode(), parserTypeIdxFaceSetNormalIndex);
    }

    final public void IdxFaceSetTexCoordIndexID() throws ParseException {
        jj_consume_token(texCoordIndex);
        pushNode(getCurrentNode(), parserTypeIdxFaceSetTexCoordIndex);
    }

    final public void IdxFaceSetElement() throws ParseException {
        boolean ok;
        float angle;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case coord:
            jj_consume_token(coord);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Coordinate:
                label_58: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[104] = jj_gen;
                        break label_58;
                    }
                    Def();
                }
                Coordinate();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[105] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case normal:
            jj_consume_token(normal);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Normal:
                label_59: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[106] = jj_gen;
                        break label_59;
                    }
                    Def();
                }
                Normal();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[107] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case color:
            jj_consume_token(color);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Color:
                label_60: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[108] = jj_gen;
                        break label_60;
                    }
                    Def();
                }
                Color();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[109] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case texCoord:
            jj_consume_token(texCoord);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case TextureCoordinate:
                label_61: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[110] = jj_gen;
                        break label_61;
                    }
                    Def();
                }
                TextureCoordinate();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[111] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case coordIndex:
            IdxFaceSetCoordIndexID();
            MFInt32Token();
            popNode();
            break;
        case texCoordIndex:
            IdxFaceSetTexCoordIndexID();
            MFInt32Token();
            popNode();
            break;
        case colorIndex:
            IdxFaceSetColorIndexID();
            MFInt32Token();
            popNode();
            break;
        case normalIndex:
            IdxFaceSetNormalIndexID();
            MFInt32Token();
            popNode();
            break;
        case creaseAngle:
            jj_consume_token(creaseAngle);
            angle = SFFloatToken();
            ((IndexedFaceSetNode) getCurrentNode()).setCreaseAngle(angle);
            break;
        case ccw:
            jj_consume_token(ccw);
            ok = SFBoolToken();
            ((IndexedFaceSetNode) getCurrentNode()).setCCW(ok);
            break;
        case solid:
            jj_consume_token(solid);
            ok = SFBoolToken();
            ((IndexedFaceSetNode) getCurrentNode()).setSolid(ok);
            break;
        case convex:
            jj_consume_token(convex);
            ok = SFBoolToken();
            ((IndexedFaceSetNode) getCurrentNode()).setConvex(ok);
            break;
        case colorPerVertex:
            jj_consume_token(colorPerVertex);
            ok = SFBoolToken();
            ((IndexedFaceSetNode) getCurrentNode()).setColorPerVertex(ok);
            break;
        case normalPerVertex:
            jj_consume_token(normalPerVertex);
            ok = SFBoolToken();
            ((IndexedFaceSetNode) getCurrentNode()).setNormalPerVertex(ok);
            break;
        default:
            jj_la1[112] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void IdxFaceSetID() throws ParseException {
        jj_consume_token(IndexedFaceSet);
        IndexedFaceSetNode idxFaceset = new IndexedFaceSetNode();
        idxFaceset.setName(getDefName());
        addNode(idxFaceset);
        pushNode(idxFaceset, parserTypeIdxFaceSet);
    }

    final public void IndexedFaceSet() throws ParseException {
        IdxFaceSetID();
        NodeBegin();
        label_62: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case color:
            case ccw:
            case colorPerVertex:
            case creaseAngle:
            case normalPerVertex:
            case solid:
            case coord:
            case normal:
            case texCoord:
            case coordIndex:
            case colorIndex:
            case texCoordIndex:
            case normalIndex:
            case convex:
                ;
                break;
            default:
                jj_la1[113] = jj_gen;
                break label_62;
            }
            IdxFaceSetElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void IdxLineSetCoordIndexID() throws ParseException {
        jj_consume_token(coordIndex);
        pushNode(getCurrentNode(), parserTypeIdxLineSetCoordIndex);
    }

    final public void IdxLineSetColorIndexID() throws ParseException {
        jj_consume_token(colorIndex);
        pushNode(getCurrentNode(), parserTypeIdxLineSetColorIndex);
    }

    final public void IdxLineSetElement() throws ParseException {
        boolean ok;
        float angle;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case coord:
            jj_consume_token(coord);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Coordinate:
                label_63: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[114] = jj_gen;
                        break label_63;
                    }
                    Def();
                }
                Coordinate();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[115] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case color:
            jj_consume_token(color);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Color:
                label_64: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[116] = jj_gen;
                        break label_64;
                    }
                    Def();
                }
                Color();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[117] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case coordIndex:
            IdxLineSetCoordIndexID();
            MFInt32Token();
            popNode();
            break;
        case colorIndex:
            IdxLineSetColorIndexID();
            MFInt32Token();
            popNode();
            break;
        case colorPerVertex:
            jj_consume_token(colorPerVertex);
            ok = SFBoolToken();
            ((IndexedLineSetNode) getCurrentNode()).setColorPerVertex(ok);
            break;
        default:
            jj_la1[118] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void IdxLineSetID() throws ParseException {
        jj_consume_token(IndexedLineSet);
        IndexedLineSetNode idxLineSet = new IndexedLineSetNode();
        idxLineSet.setName(getDefName());
        addNode(idxLineSet);
        pushNode(idxLineSet, parserTypeIdxLineSet);
    }

    final public void IndexedLineSet() throws ParseException {
        IdxLineSetID();
        NodeBegin();
        label_65: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case color:
            case colorPerVertex:
            case coord:
            case coordIndex:
            case colorIndex:
                ;
                break;
            default:
                jj_la1[119] = jj_gen;
                break label_65;
            }
            IdxLineSetElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void InlineURLID() throws ParseException {
        jj_consume_token(url);
        pushNode(getCurrentNode(), parserTypeInlineURL);
    }

    final public void InlineElement() throws ParseException {
        float vec[] = new float[3];
        String value;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case url:
            InlineURLID();
            MFStringToken();
            popNode();
            break;
        case bboxCenter:
            jj_consume_token(bboxCenter);
            SFVec3fToken(vec);
            ((InlineNode) getCurrentNode()).setBoundingBoxCenter(vec);
            break;
        case bboxSize:
            jj_consume_token(bboxSize);
            SFVec3fToken(vec);
            ((InlineNode) getCurrentNode()).setBoundingBoxSize(vec);
            break;
        default:
            jj_la1[120] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void InlineID() throws ParseException {
        jj_consume_token(Inline);
        InlineNode inline = new InlineNode();
        inline.setName(getDefName());
        addNode(inline);
        pushNode(inline, parserTypeInline);
    }

    final public void Inline() throws ParseException {
        InlineID();
        NodeBegin();
        label_66: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case url:
            case bboxCenter:
            case bboxSize:
                ;
                break;
            default:
                jj_la1[121] = jj_gen;
                break label_66;
            }
            InlineElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void Level() throws ParseException {
        jj_consume_token(level);
        label_67: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 13:
                ;
                break;
            default:
                jj_la1[122] = jj_gen;
                break label_67;
            }
            jj_consume_token(13);
        }
        label_68: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case NULL:
            case DEF:
            case USE:
            case Anchor:
            case AudioClip:
            case Background:
            case Billboard:
            case Collision:
            case ColorInterpolator:
            case CoordinateInterpolator:
            case CylinderSensor:
            case DirectionalLight:
            case Fog:
            case Group:
            case Inline:
            case LOD:
            case NavigationInfo:
            case NormalInterpolator:
            case OrientationInterpolator:
            case PlaneSensor:
            case PointLight:
            case PositionInterpolator:
            case ProximitySensor:
            case ScalarInterpolator:
            case Script:
            case Sound:
            case SphereSensor:
            case SpotLight:
            case Shape:
            case Switch:
            case TimeSensor:
            case TouchSensor:
            case Transform:
            case Viewpoint:
            case VisibilitySensor:
            case WorldInfo:
                ;
                break;
            default:
                jj_la1[123] = jj_gen;
                break label_68;
            }
            label_69: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case DEF:
                    ;
                    break;
                default:
                    jj_la1[124] = jj_gen;
                    break label_69;
                }
                Def();
            }
            ChildrenElement();
        }
        label_70: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 14:
                ;
                break;
            default:
                jj_la1[125] = jj_gen;
                break label_70;
            }
            jj_consume_token(14);
        }
    }

    final public void LODRangeID() throws ParseException {
        jj_consume_token(range);
        pushNode(getCurrentNode(), parserTypeLODRange);
    }

    final public void LODElement() throws ParseException {
        float vector[] = new float[3];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case range:
            LODRangeID();
            MFFloatToken();
            popNode();
            break;
        case center:
            jj_consume_token(center);
            SFVec3fToken(vector);
            ((LODNode) getCurrentNode()).setCenter(vector);
            break;
        case level:
            Level();
            break;
        default:
            jj_la1[126] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void LODID() throws ParseException {
        jj_consume_token(LOD);
        LODNode lod = new LODNode();
        lod.setName(getDefName());
        addNode(lod);
        pushNode(lod, parserTypeLOD);
    }

    final public void LOD() throws ParseException {
        LODID();
        NodeBegin();
        label_71: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case center:
            case range:
            case level:
                ;
                break;
            default:
                jj_la1[127] = jj_gen;
                break label_71;
            }
            LODElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void MaterialElement() throws ParseException {
        float color[] = new float[3];
        float value;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case ambientIntensity:
            jj_consume_token(ambientIntensity);
            value = SFFloatToken();
            ((MaterialNode) getCurrentNode()).setAmbientIntensity(value);
            break;
        case shininess:
            jj_consume_token(shininess);
            value = SFFloatToken();
            ((MaterialNode) getCurrentNode()).setShininess(value);
            break;
        case transparency:
            jj_consume_token(transparency);
            value = SFFloatToken();
            ((MaterialNode) getCurrentNode()).setTransparency(value);
            break;
        case diffuseColor:
            jj_consume_token(diffuseColor);
            SFColorToken(color);
            ((MaterialNode) getCurrentNode()).setDiffuseColor(color);
            break;
        case specularColor:
            jj_consume_token(specularColor);
            SFColorToken(color);
            ((MaterialNode) getCurrentNode()).setSpecularColor(color);
            break;
        case emissiveColor:
            jj_consume_token(emissiveColor);
            SFColorToken(color);
            ((MaterialNode) getCurrentNode()).setEmissiveColor(color);
            break;
        default:
            jj_la1[128] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void MaterialID() throws ParseException {
        jj_consume_token(Material);
        MaterialNode mat = new MaterialNode();
        mat.setName(getDefName());
        addNode(mat);
        pushNode(mat, parserTypeMaterial);
    }

    final public void Material() throws ParseException {
        MaterialID();
        NodeBegin();
        label_72: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case ambientIntensity:
            case diffuseColor:
            case specularColor:
            case emissiveColor:
            case shininess:
            case transparency:
                ;
                break;
            default:
                jj_la1[129] = jj_gen;
                break label_72;
            }
            MaterialElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void MovieTextureURLID() throws ParseException {
        jj_consume_token(url);
        pushNode(getCurrentNode(), parserTypeMovieTextureURL);
    }

    final public void MovieTextureElement() throws ParseException {
        boolean bvalue;
        double dvalue;
        float fvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case url:
            MovieTextureURLID();
            MFStringToken();
            popNode();
            break;
        case repeatS:
            jj_consume_token(repeatS);
            bvalue = SFBoolToken();
            ((MovieTextureNode) getCurrentNode()).setRepeatS(bvalue);
            break;
        case repeatT:
            jj_consume_token(repeatT);
            bvalue = SFBoolToken();
            ((MovieTextureNode) getCurrentNode()).setRepeatT(bvalue);
            break;
        case loop:
            jj_consume_token(loop);
            bvalue = SFBoolToken();
            ((MovieTextureNode) getCurrentNode()).setLoop(bvalue);
            break;
        case startTime:
            jj_consume_token(startTime);
            dvalue = SFTimeToken();
            ((MovieTextureNode) getCurrentNode()).setStartTime(dvalue);
            break;
        case stopTime:
            jj_consume_token(stopTime);
            dvalue = SFTimeToken();
            ((MovieTextureNode) getCurrentNode()).setStopTime(dvalue);
            break;
        case speed:
            jj_consume_token(speed);
            fvalue = SFFloatToken();
            ((MovieTextureNode) getCurrentNode()).setSpeed(fvalue);
            break;
        default:
            jj_la1[130] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void MovieTextureID() throws ParseException {
        jj_consume_token(MovieTexture);
        MovieTextureNode texture = new MovieTextureNode();
        texture.setName(getDefName());
        addNode(texture);
        pushNode(texture, parserTypeMovieTexture);
    }

    final public void MovieTexture() throws ParseException {
        MovieTextureID();
        NodeBegin();
        label_73: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case url:
            case loop:
            case startTime:
            case stopTime:
            case repeatS:
            case repeatT:
            case speed:
                ;
                break;
            default:
                jj_la1[131] = jj_gen;
                break label_73;
            }
            MovieTextureElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void NavigationInfoAvatarSizeID() throws ParseException {
        jj_consume_token(avatarSize);
        pushNode(getCurrentNode(), parserTypeNavigationInfoAvatarSize);
    }

    final public void NavigationInfoTypeID() throws ParseException {
        jj_consume_token(type);
        pushNode(getCurrentNode(), parserTypeNavigationInfoType);
    }

    final public void NavigationInfoID() throws ParseException {
        jj_consume_token(NavigationInfo);
        NavigationInfoNode navInfo = new NavigationInfoNode();
        navInfo.setName(getDefName());
        addNode(navInfo);
        pushNode(navInfo, parserTypeNavigationInfo);
    }

    final public void NavigationInfoElement() throws ParseException {
        String svalue;
        boolean bvalue;
        float fvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case avatarSize:
            NavigationInfoAvatarSizeID();
            MFFloatToken();
            popNode();
            break;
        case type:
            NavigationInfoTypeID();
            MFStringToken();
            popNode();
            break;
        case headlight:
            jj_consume_token(headlight);
            bvalue = SFBoolToken();
            ((NavigationInfoNode) getCurrentNode()).setHeadlight(bvalue);
            break;
        case speed:
            jj_consume_token(speed);
            fvalue = SFFloatToken();
            ((NavigationInfoNode) getCurrentNode()).setSpeed(fvalue);
            break;
        case visibilityLimit:
            jj_consume_token(visibilityLimit);
            fvalue = SFFloatToken();
            ((NavigationInfoNode) getCurrentNode()).setVisibilityLimit(fvalue);
            break;
        default:
            jj_la1[132] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void NavigationInfo() throws ParseException {
        NavigationInfoID();
        NodeBegin();
        label_74: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case speed:
            case avatarSize:
            case headlight:
            case type:
            case visibilityLimit:
                ;
                break;
            default:
                jj_la1[133] = jj_gen;
                break label_74;
            }
            NavigationInfoElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void NormalID() throws ParseException {
        jj_consume_token(Normal);
        NormalNode normal = new NormalNode();
        normal.setName(getDefName());
        addNode(normal);
        pushNode(normal, parserTypeNormal);
    }

    final public void Normal() throws ParseException {
        NormalID();
        NodeBegin();
        jj_consume_token(vector);
        MFVec3fToken();
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void NormalInterpolatorKeyID() throws ParseException {
        jj_consume_token(key);
        pushNode(getCurrentNode(), parserTypeNormalInterpolatorKey);
    }

    final public void NormalInterpolatorKeyValueID() throws ParseException {
        jj_consume_token(keyValue);
        pushNode(getCurrentNode(), parserTypeNormalInterpolatorKeyValue);
    }

    final public void NormalInterpolatorID() throws ParseException {
        jj_consume_token(NormalInterpolator);
        NormalInterpolatorNode normalInterp = new NormalInterpolatorNode();
        normalInterp.setName(getDefName());
        addNode(normalInterp);
        pushNode(normalInterp, parserTypeNormalInterpolator);
    }

    final public void NormalInterpolatorElement() throws ParseException {
        float value3f[] = new float[3];
        float value;
        boolean ok;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case key:
            NormalInterpolatorKeyID();
            MFFloatToken();
            popNode();
            break;
        case keyValue:
            NormalInterpolatorKeyValueID();
            MFVec3fToken();
            popNode();
            break;
        default:
            jj_la1[134] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void NormalInterpolator() throws ParseException {
        NormalInterpolatorID();
        NodeBegin();
        label_75: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case key:
            case keyValue:
                ;
                break;
            default:
                jj_la1[135] = jj_gen;
                break label_75;
            }
            NormalInterpolatorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void OrientationInterpolatorKeyID() throws ParseException {
        jj_consume_token(key);
        pushNode(getCurrentNode(), parserTypeOrientationInterpolatorKey);
    }

    final public void OrientationInterpolatorKeyValueID() throws ParseException {
        jj_consume_token(keyValue);
        pushNode(getCurrentNode(), parserTypeOrientationInterpolatorKeyValue);
    }

    final public void OrientationInterpolatorID() throws ParseException {
        jj_consume_token(OrientationInterpolator);
        OrientationInterpolatorNode oriInterp = new OrientationInterpolatorNode();
        oriInterp.setName(getDefName());
        addNode(oriInterp);
        pushNode(oriInterp, parserTypeOrientationInterpolator);
    }

    final public void OrientationInterpolatorElement() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case key:
            OrientationInterpolatorKeyID();
            MFFloatToken();
            popNode();
            break;
        case keyValue:
            OrientationInterpolatorKeyValueID();
            MFRotationToken();
            popNode();
            break;
        default:
            jj_la1[136] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void OrientationInterpolator() throws ParseException {
        OrientationInterpolatorID();
        NodeBegin();
        label_76: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case key:
            case keyValue:
                ;
                break;
            default:
                jj_la1[137] = jj_gen;
                break label_76;
            }
            OrientationInterpolatorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void PixelTextureImageID() throws ParseException {
        jj_consume_token(image);
        pushNode(getCurrentNode(), parserTypePixelTextureImage);
    }

    final public void PixelTextureElement() throws ParseException {
        boolean bvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case image:
            PixelTextureImageID();
            SFImageToken();
            popNode();
            break;
        case repeatS:
            jj_consume_token(repeatS);
            bvalue = SFBoolToken();
            ((PixelTextureNode) getCurrentNode()).setRepeatS(bvalue);
            break;
        case repeatT:
            jj_consume_token(repeatT);
            bvalue = SFBoolToken();
            ((PixelTextureNode) getCurrentNode()).setRepeatT(bvalue);
            break;
        default:
            jj_la1[138] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void PixelTextureID() throws ParseException {
        jj_consume_token(PixelTexture);
        PixelTextureNode texture = new PixelTextureNode();
        texture.setName(getDefName());
        addNode(texture);
        pushNode(texture, parserTypePixelTexture);
    }

    final public void PixelTexture() throws ParseException {
        PixelTextureID();
        NodeBegin();
        label_77: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case repeatS:
            case repeatT:
            case image:
                ;
                break;
            default:
                jj_la1[139] = jj_gen;
                break label_77;
            }
            PixelTextureElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void PlaneSensorElement() throws ParseException {
        boolean bvalue;
        float fvalue;
        float v2value[] = new float[2];
        float v3value[] = new float[3];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case minPosition:
            jj_consume_token(minPosition);
            SFVec2fToken(v2value);
            ((PlaneSensorNode) getCurrentNode()).setMinPosition(v2value);
            break;
        case maxPosition:
            jj_consume_token(maxPosition);
            SFVec2fToken(v2value);
            ((PlaneSensorNode) getCurrentNode()).setMaxPosition(v2value);
            break;
        case offset:
            jj_consume_token(offset);
            SFVec3fToken(v3value);
            ((PlaneSensorNode) getCurrentNode()).setOffset(v3value);
            break;
        case enabled:
            jj_consume_token(enabled);
            bvalue = SFBoolToken();
            ((PlaneSensorNode) getCurrentNode()).setEnabled(bvalue);
            break;
        case autoOffset:
            jj_consume_token(autoOffset);
            bvalue = SFBoolToken();
            ((PlaneSensorNode) getCurrentNode()).setAutoOffset(bvalue);
            break;
        default:
            jj_la1[140] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void PlaneSensorID() throws ParseException {
        jj_consume_token(PlaneSensor);
        PlaneSensorNode sensor = new PlaneSensorNode();
        sensor.setName(getDefName());
        addNode(sensor);
        pushNode(sensor, parserTypePlaneSensor);
    }

    final public void PlaneSensor() throws ParseException {
        PlaneSensorID();
        NodeBegin();
        label_78: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case enabled:
            case offset:
            case autoOffset:
            case minPosition:
            case maxPosition:
                ;
                break;
            default:
                jj_la1[141] = jj_gen;
                break label_78;
            }
            PlaneSensorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void PointLightElement() throws ParseException {
        float value3f[] = new float[3];
        float value;
        boolean ok;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case on:
            jj_consume_token(on);
            ok = SFBoolToken();
            ((PointLightNode) getCurrentNode()).setOn(ok);
            break;
        case intensity:
            jj_consume_token(intensity);
            value = SFFloatToken();
            ((PointLightNode) getCurrentNode()).setIntensity(value);
            break;
        case ambientIntensity:
            jj_consume_token(ambientIntensity);
            value = SFFloatToken();
            ((PointLightNode) getCurrentNode()).setAmbientIntensity(value);
            break;
        case color:
            jj_consume_token(color);
            SFColorToken(value3f);
            ((PointLightNode) getCurrentNode()).setColor(value3f);
            break;
        case radius:
            jj_consume_token(radius);
            value = SFFloatToken();
            ((PointLightNode) getCurrentNode()).setRadius(value);
            break;
        case location:
            jj_consume_token(location);
            SFVec3fToken(value3f);
            ((PointLightNode) getCurrentNode()).setLocation(value3f);
            break;
        case attenuation:
            jj_consume_token(attenuation);
            SFVec3fToken(value3f);
            ((PointLightNode) getCurrentNode()).setAttenuation(value3f);
            break;
        default:
            jj_la1[142] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void PointLightID() throws ParseException {
        jj_consume_token(PointLight);
        PointLightNode light = new PointLightNode();
        light.setName(getDefName());
        addNode(light);
        pushNode(light, parserTypePointLight);
    }

    final public void PointLight() throws ParseException {
        PointLightID();
        NodeBegin();
        label_79: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case color:
            case radius:
            case on:
            case intensity:
            case ambientIntensity:
            case location:
            case attenuation:
                ;
                break;
            default:
                jj_la1[143] = jj_gen;
                break label_79;
            }
            PointLightElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void PointSetElement() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case color:
            jj_consume_token(color);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Color:
                label_80: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[144] = jj_gen;
                        break label_80;
                    }
                    Def();
                }
                Color();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[145] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case coord:
            jj_consume_token(coord);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Coordinate:
                label_81: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[146] = jj_gen;
                        break label_81;
                    }
                    Def();
                }
                Coordinate();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[147] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        default:
            jj_la1[148] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void PointSetID() throws ParseException {
        jj_consume_token(PointSet);
        PointSetNode point = new PointSetNode();
        point.setName(getDefName());
        addNode(point);
        pushNode(point, parserTypePointSet);
    }

    final public void PointSet() throws ParseException {
        PointSetID();
        NodeBegin();
        label_82: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case color:
            case coord:
                ;
                break;
            default:
                jj_la1[149] = jj_gen;
                break label_82;
            }
            PointSetElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void PositionInterpolatorKeyID() throws ParseException {
        jj_consume_token(key);
        pushNode(getCurrentNode(), parserTypePositionInterpolatorKey);
    }

    final public void PositionInterpolatorKeyValueID() throws ParseException {
        jj_consume_token(keyValue);
        pushNode(getCurrentNode(), parserTypePositionInterpolatorKeyValue);
    }

    final public void PositionInterpolatorID() throws ParseException {
        jj_consume_token(PositionInterpolator);
        PositionInterpolatorNode posInterp = new PositionInterpolatorNode();
        posInterp.setName(getDefName());
        addNode(posInterp);
        pushNode(posInterp, parserTypePositionInterpolator);
    }

    final public void PositionInterpolatorElement() throws ParseException {
        float value3f[] = new float[3];
        float value;
        boolean ok;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case key:
            PositionInterpolatorKeyID();
            MFFloatToken();
            popNode();
            break;
        case keyValue:
            PositionInterpolatorKeyValueID();
            MFVec3fToken();
            popNode();
            break;
        default:
            jj_la1[150] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void PositionInterpolator() throws ParseException {
        PositionInterpolatorID();
        NodeBegin();
        label_83: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case key:
            case keyValue:
                ;
                break;
            default:
                jj_la1[151] = jj_gen;
                break label_83;
            }
            PositionInterpolatorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void ProximitySensorElement() throws ParseException {
        boolean bvalue;
        float fvalue;
        float v3value[] = new float[3];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case center:
            jj_consume_token(center);
            SFVec3fToken(v3value);
            ((ProximitySensorNode) getCurrentNode()).setCenter(v3value);
            break;
        case size:
            jj_consume_token(size);
            SFVec3fToken(v3value);
            ((ProximitySensorNode) getCurrentNode()).setSize(v3value);
            break;
        case enabled:
            jj_consume_token(enabled);
            bvalue = SFBoolToken();
            ((ProximitySensorNode) getCurrentNode()).setEnabled(bvalue);
            break;
        default:
            jj_la1[152] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void ProximitySensorID() throws ParseException {
        jj_consume_token(ProximitySensor);
        ProximitySensorNode sensor = new ProximitySensorNode();
        sensor.setName(getDefName());
        addNode(sensor);
        pushNode(sensor, parserTypeProximitySensor);
    }

    final public void ProximitySensor() throws ParseException {
        ProximitySensorID();
        NodeBegin();
        label_84: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case size:
            case enabled:
            case center:
                ;
                break;
            default:
                jj_la1[153] = jj_gen;
                break label_84;
            }
            ProximitySensorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void ScalarInterpolatorKeyID() throws ParseException {
        jj_consume_token(key);
        pushNode(getCurrentNode(), parserTypeScalarInterpolatorKey);
    }

    final public void ScalarInterpolatorKeyValueID() throws ParseException {
        jj_consume_token(keyValue);
        pushNode(getCurrentNode(), parserTypeScalarInterpolatorKeyValue);
    }

    final public void ScalarInterpolatorID() throws ParseException {
        jj_consume_token(ScalarInterpolator);
        ScalarInterpolatorNode scalarInterp = new ScalarInterpolatorNode();
        scalarInterp.setName(getDefName());
        addNode(scalarInterp);
        pushNode(scalarInterp, parserTypeScalarInterpolator);
    }

    final public void ScalarInterpolatorElement() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case key:
            ScalarInterpolatorKeyID();
            MFFloatToken();
            popNode();
            break;
        case keyValue:
            ScalarInterpolatorKeyValueID();
            MFFloatToken();
            popNode();
            break;
        default:
            jj_la1[154] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void ScalarInterpolator() throws ParseException {
        ScalarInterpolatorID();
        NodeBegin();
        label_85: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case key:
            case keyValue:
                ;
                break;
            default:
                jj_la1[155] = jj_gen;
                break label_85;
            }
            ScalarInterpolatorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public String FieldName() throws ParseException {
        Token t;
        t = jj_consume_token(ID);
        {
            if (true)
                return t.image;
        }
        throw new Error("Missing return statement in function");
    }

    final public void ScriptURLID() throws ParseException {
        jj_consume_token(url);
        pushNode(getCurrentNode(), parserTypeScriptURL);
    }

    final public void ScriptElement() throws ParseException {
        String fieldTypeName;
        String fieldName;
        String eventInName;
        String eventOutName;
        String initialValue;
        Node instanceNode;
        Node node;

        ScriptNode script;

        String svalue;
        boolean bvalue;
        float fvalue;
        double dvalue;
        int ivalue;
        float value2[] = new float[2];
        float value3[] = new float[3];
        float value4[] = new float[4];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case url:
            ScriptURLID();
            MFStringToken();
            popNode();
            break;
        case directOutput:
            jj_consume_token(directOutput);
            bvalue = SFBoolToken();
            script = (ScriptNode) getCurrentNode();
            script.setDirectOutput(bvalue);
            break;
        case mustEvaluate:
            jj_consume_token(mustEvaluate);
            bvalue = SFBoolToken();
            script = (ScriptNode) getCurrentNode();
            script.setMustEvaluate(bvalue);
            break;
        default:
            jj_la1[156] = jj_gen;
            if (jj_2_1(2)) {
                jj_consume_token(eventIn);
                jj_consume_token(SFBool);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFBool value = new SFBool();
                script.addEventIn(eventInName, value);
            } else if (jj_2_2(2)) {
                jj_consume_token(eventIn);
                jj_consume_token(SFColor);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFColor value = new SFColor();
                script.addEventIn(eventInName, value);
            } else if (jj_2_3(2)) {
                jj_consume_token(eventIn);
                jj_consume_token(SFFloat);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFFloat value = new SFFloat();
                script.addEventIn(eventInName, value);
            } else if (jj_2_4(2)) {
                jj_consume_token(eventIn);
                jj_consume_token(SFInt32);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFInt32 value = new SFInt32();
                script.addEventIn(eventInName, value);
            } else if (jj_2_5(2)) {
                jj_consume_token(eventIn);
                jj_consume_token(SFRotation);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFRotation value = new SFRotation();
                script.addEventIn(eventInName, value);
            } else if (jj_2_6(2)) {
                jj_consume_token(eventIn);
                jj_consume_token(SFString);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFString value = new SFString();
                script.addEventIn(eventInName, value);
            } else if (jj_2_7(2)) {
                jj_consume_token(eventIn);
                jj_consume_token(SFTime);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFTime value = new SFTime();
                script.addEventIn(eventInName, value);
            } else if (jj_2_8(2)) {
                jj_consume_token(eventIn);
                jj_consume_token(SFVec2f);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFVec2f value = new SFVec2f();
                script.addEventIn(eventInName, value);
            } else if (jj_2_9(2)) {
                jj_consume_token(eventIn);
                jj_consume_token(SFVec3f);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFVec3f value = new SFVec3f();
                script.addEventIn(eventInName, value);
            } else if (jj_2_10(3)) {
                jj_consume_token(eventIn);
                jj_consume_token(MFColor);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFColor value = new MFColor();
                script.addEventIn(eventInName, value);
            } else if (jj_2_11(3)) {
                jj_consume_token(eventIn);
                jj_consume_token(MFFloat);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFFloat value = new MFFloat();
                script.addEventIn(eventInName, value);
            } else if (jj_2_12(3)) {
                jj_consume_token(eventIn);
                jj_consume_token(MFInt32);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFInt32 value = new MFInt32();
                script.addEventIn(eventInName, value);
            } else if (jj_2_13(3)) {
                jj_consume_token(eventIn);
                jj_consume_token(MFRotation);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFRotation value = new MFRotation();
                script.addEventIn(eventInName, value);
            } else if (jj_2_14(3)) {
                jj_consume_token(eventIn);
                jj_consume_token(MFString);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFString value = new MFString();
                script.addEventIn(eventInName, value);
            } else if (jj_2_15(3)) {
                jj_consume_token(eventIn);
                jj_consume_token(MFTime);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFTime value = new MFTime();
                script.addEventIn(eventInName, value);
            } else if (jj_2_16(3)) {
                jj_consume_token(eventIn);
                jj_consume_token(MFVec2f);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFVec2f value = new MFVec2f();
                script.addEventIn(eventInName, value);
            } else if (jj_2_17(3)) {
                jj_consume_token(eventIn);
                jj_consume_token(MFVec3f);
                eventInName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFVec3f value = new MFVec3f();
                script.addEventIn(eventInName, value);
            } else if (jj_2_18(2)) {
                jj_consume_token(eventOut);
                jj_consume_token(SFBool);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFBool value = new SFBool();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_19(2)) {
                jj_consume_token(eventOut);
                jj_consume_token(SFColor);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFColor value = new SFColor();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_20(2)) {
                jj_consume_token(eventOut);
                jj_consume_token(SFFloat);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFFloat value = new SFFloat();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_21(2)) {
                jj_consume_token(eventOut);
                jj_consume_token(SFInt32);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFInt32 value = new SFInt32();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_22(2)) {
                jj_consume_token(eventOut);
                jj_consume_token(SFRotation);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFRotation value = new SFRotation();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_23(2)) {
                jj_consume_token(eventOut);
                jj_consume_token(SFString);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFString value = new SFString();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_24(2)) {
                jj_consume_token(eventOut);
                jj_consume_token(SFTime);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFTime value = new SFTime();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_25(2)) {
                jj_consume_token(eventOut);
                jj_consume_token(SFVec2f);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFVec2f value = new SFVec2f();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_26(2)) {
                jj_consume_token(eventOut);
                jj_consume_token(SFVec3f);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                SFVec3f value = new SFVec3f();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_27(3)) {
                jj_consume_token(eventOut);
                jj_consume_token(MFColor);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFColor value = new MFColor();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_28(3)) {
                jj_consume_token(eventOut);
                jj_consume_token(MFFloat);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFFloat value = new MFFloat();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_29(3)) {
                jj_consume_token(eventOut);
                jj_consume_token(MFInt32);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFInt32 value = new MFInt32();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_30(3)) {
                jj_consume_token(eventOut);
                jj_consume_token(MFRotation);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFRotation value = new MFRotation();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_31(3)) {
                jj_consume_token(eventOut);
                jj_consume_token(MFString);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFString value = new MFString();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_32(3)) {
                jj_consume_token(eventOut);
                jj_consume_token(MFTime);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFTime value = new MFTime();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_33(3)) {
                jj_consume_token(eventOut);
                jj_consume_token(MFVec2f);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFVec2f value = new MFVec2f();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_34(3)) {
                jj_consume_token(eventOut);
                jj_consume_token(MFVec3f);
                eventOutName = FieldName();
                script = (ScriptNode) getCurrentNode();
                MFVec3f value = new MFVec3f();
                script.addEventOut(eventOutName, value);
            } else if (jj_2_35(2)) {
                jj_consume_token(field);
                jj_consume_token(SFBool);
                fieldName = FieldName();
                bvalue = SFBoolToken();
                script = (ScriptNode) getCurrentNode();
                SFBool value = new SFBool(bvalue);
                script.addField(fieldName, value);
            } else if (jj_2_36(2)) {
                jj_consume_token(field);
                jj_consume_token(SFColor);
                fieldName = FieldName();
                SFColorToken(value3);
                script = (ScriptNode) getCurrentNode();
                SFColor value = new SFColor(value3);
                script.addField(fieldName, value);
            } else if (jj_2_37(2)) {
                jj_consume_token(field);
                jj_consume_token(SFFloat);
                fieldName = FieldName();
                fvalue = SFFloatToken();
                script = (ScriptNode) getCurrentNode();
                SFFloat value = new SFFloat(fvalue);
                script.addField(fieldName, value);
            } else if (jj_2_38(2)) {
                jj_consume_token(field);
                jj_consume_token(SFInt32);
                fieldName = FieldName();
                ivalue = SFInt32Token();
                script = (ScriptNode) getCurrentNode();
                SFInt32 value = new SFInt32(ivalue);
                script.addField(fieldName, value);
            } else if (jj_2_39(2)) {
                jj_consume_token(field);
                jj_consume_token(SFRotation);
                fieldName = FieldName();
                SFRotationToken(value4);
                script = (ScriptNode) getCurrentNode();
                SFRotation value = new SFRotation(value4);
                script.addField(fieldName, value);
            } else if (jj_2_40(2)) {
                jj_consume_token(field);
                jj_consume_token(SFString);
                fieldName = FieldName();
                svalue = SFStringToken();
                script = (ScriptNode) getCurrentNode();
                SFString value = new SFString(svalue);
                script.addField(fieldName, value);
            } else if (jj_2_41(2)) {
                jj_consume_token(field);
                jj_consume_token(SFTime);
                fieldName = FieldName();
                dvalue = SFTimeToken();
                script = (ScriptNode) getCurrentNode();
                SFTime value = new SFTime(dvalue);
                script.addField(fieldName, value);
            } else if (jj_2_42(2)) {
                jj_consume_token(field);
                jj_consume_token(SFVec2f);
                fieldName = FieldName();
                SFVec2fToken(value2);
                script = (ScriptNode) getCurrentNode();
                SFVec2f value = new SFVec2f(value2);
                script.addField(fieldName, value);
            } else if (jj_2_43(2)) {
                jj_consume_token(field);
                jj_consume_token(SFVec3f);
                fieldName = FieldName();
                SFVec3fToken(value3);
                script = (ScriptNode) getCurrentNode();
                SFVec3f value = new SFVec3f(value3);
                script.addField(fieldName, value);
            } else if (jj_2_44(2)) {
                jj_consume_token(field);
                jj_consume_token(SFNode);
                fieldName = FieldName();
                instanceNode = Use();
                script = (ScriptNode) getCurrentNode();
                node = instanceNode.getReferenceNode();
                SFNode value = new SFNode(node);
                script.addField(fieldName, value);
                instanceNode.remove();
            } else if (jj_2_45(2)) {
                jj_consume_token(field);
                jj_consume_token(SFNode);
                fieldName = FieldName();
                jj_consume_token(NULL);
                script = (ScriptNode) getCurrentNode();
                SFNode value = new SFNode();
                script.addField(fieldName, value);
            } else {
                jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    final public void ScriptID() throws ParseException {
        jj_consume_token(Script);
        ScriptNode script = new ScriptNode();
        script.setName(getDefName());
        addNode(script);
        pushNode(script, parserTypeScript);
    }

    final public void Script() throws ParseException {
        ScriptID();
        NodeBegin();
        label_86: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case url:
            case directOutput:
            case mustEvaluate:
            case eventIn:
            case eventOut:
            case field:
                ;
                break;
            default:
                jj_la1[157] = jj_gen;
                break label_86;
            }
            ScriptElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void SoundElement() throws ParseException {
        boolean bvalue;
        float fvalue;
        float vector[] = new float[3];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case spatialize:
            jj_consume_token(spatialize);
            bvalue = SFBoolToken();
            ((SoundNode) getCurrentNode()).setSpatialize(bvalue);
            break;
        case intensity:
            jj_consume_token(intensity);
            fvalue = SFFloatToken();
            ((SoundNode) getCurrentNode()).setIntensity(fvalue);
            break;
        case maxBack:
            jj_consume_token(maxBack);
            fvalue = SFFloatToken();
            ((SoundNode) getCurrentNode()).setMaxBack(fvalue);
            break;
        case minBack:
            jj_consume_token(minBack);
            fvalue = SFFloatToken();
            ((SoundNode) getCurrentNode()).setMinBack(fvalue);
            break;
        case maxFront:
            jj_consume_token(maxFront);
            fvalue = SFFloatToken();
            ((SoundNode) getCurrentNode()).setMaxFront(fvalue);
            break;
        case minFront:
            jj_consume_token(minFront);
            fvalue = SFFloatToken();
            ((SoundNode) getCurrentNode()).setMinFront(fvalue);
            break;
        case priority:
            jj_consume_token(priority);
            fvalue = SFFloatToken();
            ((SoundNode) getCurrentNode()).setPriority(fvalue);
            break;
        case direction:
            jj_consume_token(direction);
            SFVec3fToken(vector);
            ((SoundNode) getCurrentNode()).setDirection(vector);
            break;
        case location:
            jj_consume_token(location);
            SFVec3fToken(vector);
            ((SoundNode) getCurrentNode()).setLocation(vector);
            break;
        case source:
            jj_consume_token(source);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case AudioClip:
                label_87: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[158] = jj_gen;
                        break label_87;
                    }
                    Def();
                }
                AudioClip();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[159] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        default:
            jj_la1[160] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void SoundID() throws ParseException {
        jj_consume_token(Sound);
        SoundNode sound = new SoundNode();
        sound.setName(getDefName());
        addNode(sound);
        pushNode(sound, parserTypeSound);
    }

    final public void Sound() throws ParseException {
        SoundID();
        NodeBegin();
        label_88: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case intensity:
            case direction:
            case location:
            case spatialize:
            case maxBack:
            case minBack:
            case maxFront:
            case minFront:
            case priority:
            case source:
                ;
                break;
            default:
                jj_la1[161] = jj_gen;
                break label_88;
            }
            SoundElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void SphereElement() throws ParseException {
        float value;
        jj_consume_token(radius);
        value = SFFloatToken();
        ((SphereNode) getCurrentNode()).setRadius(value);
    }

    final public void SphereID() throws ParseException {
        jj_consume_token(Sphere);
        SphereNode sphere = new SphereNode();
        sphere.setName(getDefName());
        addNode(sphere);
        pushNode(sphere, parserTypeSphere);
    }

    final public void Sphere() throws ParseException {
        SphereID();
        NodeBegin();
        label_89: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case radius:
                ;
                break;
            default:
                jj_la1[162] = jj_gen;
                break label_89;
            }
            SphereElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void SphereSensorElement() throws ParseException {
        boolean bvalue;
        float rotvalue[] = new float[4];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case offset:
            jj_consume_token(offset);
            SFRotationToken(rotvalue);
            ((SphereSensorNode) getCurrentNode()).setOffset(rotvalue);
            break;
        case enabled:
            jj_consume_token(enabled);
            bvalue = SFBoolToken();
            ((SphereSensorNode) getCurrentNode()).setEnabled(bvalue);
            break;
        case autoOffset:
            jj_consume_token(autoOffset);
            bvalue = SFBoolToken();
            ((SphereSensorNode) getCurrentNode()).setAutoOffset(bvalue);
            break;
        default:
            jj_la1[163] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void SphereSensorID() throws ParseException {
        jj_consume_token(SphereSensor);
        SphereSensorNode sensor = new SphereSensorNode();
        sensor.setName(getDefName());
        addNode(sensor);
        pushNode(sensor, parserTypeSphereSensor);
    }

    final public void SphereSensor() throws ParseException {
        SphereSensorID();
        NodeBegin();
        label_90: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case enabled:
            case offset:
            case autoOffset:
                ;
                break;
            default:
                jj_la1[164] = jj_gen;
                break label_90;
            }
            SphereSensorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void SpotLightElement() throws ParseException {
        float value3f[] = new float[3];
        float value;
        boolean ok;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case on:
            jj_consume_token(on);
            ok = SFBoolToken();
            ((SpotLightNode) getCurrentNode()).setOn(ok);
            break;
        case intensity:
            jj_consume_token(intensity);
            value = SFFloatToken();
            ((SpotLightNode) getCurrentNode()).setIntensity(value);
            break;
        case ambientIntensity:
            jj_consume_token(ambientIntensity);
            value = SFFloatToken();
            ((SpotLightNode) getCurrentNode()).setAmbientIntensity(value);
            break;
        case beamWidth:
            jj_consume_token(beamWidth);
            value = SFFloatToken();
            ((SpotLightNode) getCurrentNode()).setBeamWidth(value);
            break;
        case cutOffAngle:
            jj_consume_token(cutOffAngle);
            value = SFFloatToken();
            ((SpotLightNode) getCurrentNode()).setCutOffAngle(value);
            break;
        case color:
            jj_consume_token(color);
            SFColorToken(value3f);
            ((SpotLightNode) getCurrentNode()).setColor(value3f);
            break;
        case direction:
            jj_consume_token(direction);
            SFVec3fToken(value3f);
            ((SpotLightNode) getCurrentNode()).setDirection(value3f);
            break;
        case location:
            jj_consume_token(location);
            SFVec3fToken(value3f);
            ((SpotLightNode) getCurrentNode()).setLocation(value3f);
            break;
        case attenuation:
            jj_consume_token(attenuation);
            SFVec3fToken(value3f);
            ((SpotLightNode) getCurrentNode()).setAttenuation(value3f);
            break;
        case radius:
            jj_consume_token(radius);
            value = SFFloatToken();
            ((SpotLightNode) getCurrentNode()).setRadius(value);
            break;
        default:
            jj_la1[165] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void SpotLightID() throws ParseException {
        jj_consume_token(SpotLight);
        SpotLightNode light = new SpotLightNode();
        light.setName(getDefName());
        addNode(light);
        pushNode(light, parserTypeSpotLight);
    }

    final public void SpotLight() throws ParseException {
        SpotLightID();
        NodeBegin();
        label_91: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case color:
            case radius:
            case on:
            case intensity:
            case ambientIntensity:
            case direction:
            case location:
            case attenuation:
            case beamWidth:
            case cutOffAngle:
                ;
                break;
            default:
                jj_la1[166] = jj_gen;
                break label_91;
            }
            SpotLightElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void ShapeElement() throws ParseException {
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case geometry:
            jj_consume_token(geometry);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Box:
            case Cone:
            case Cylinder:
            case ElevationGrid:
            case Extrusion:
            case IndexedFaceSet:
            case IndexedLineSet:
            case PointSet:
            case Sphere:
            case Text:
                label_92: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[167] = jj_gen;
                        break label_92;
                    }
                    Def();
                }
                GeometryNode();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[168] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        case appearance:
            jj_consume_token(appearance);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case Appearance:
                label_93: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[169] = jj_gen;
                        break label_93;
                    }
                    Def();
                }
                Appearance();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[170] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        default:
            jj_la1[171] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void ShapeID() throws ParseException {
        jj_consume_token(Shape);
        ShapeNode shape = new ShapeNode();
        shape.setName(getDefName());
        addNode(shape);
        pushNode(shape, parserTypeShape);
    }

    final public void Shape() throws ParseException {
        ShapeID();
        NodeBegin();
        label_94: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case appearance:
            case geometry:
                ;
                break;
            default:
                jj_la1[172] = jj_gen;
                break label_94;
            }
            ShapeElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void Choice() throws ParseException {
        jj_consume_token(choice);
        label_95: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 13:
                ;
                break;
            default:
                jj_la1[173] = jj_gen;
                break label_95;
            }
            jj_consume_token(13);
        }
        label_96: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case NULL:
            case DEF:
            case USE:
            case Anchor:
            case AudioClip:
            case Background:
            case Billboard:
            case Collision:
            case ColorInterpolator:
            case CoordinateInterpolator:
            case CylinderSensor:
            case DirectionalLight:
            case Fog:
            case Group:
            case Inline:
            case LOD:
            case NavigationInfo:
            case NormalInterpolator:
            case OrientationInterpolator:
            case PlaneSensor:
            case PointLight:
            case PositionInterpolator:
            case ProximitySensor:
            case ScalarInterpolator:
            case Script:
            case Sound:
            case SphereSensor:
            case SpotLight:
            case Shape:
            case Switch:
            case TimeSensor:
            case TouchSensor:
            case Transform:
            case Viewpoint:
            case VisibilitySensor:
            case WorldInfo:
                ;
                break;
            default:
                jj_la1[174] = jj_gen;
                break label_96;
            }
            label_97: while (true) {
                switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                case DEF:
                    ;
                    break;
                default:
                    jj_la1[175] = jj_gen;
                    break label_97;
                }
                Def();
            }
            ChildrenElement();
        }
        label_98: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case 14:
                ;
                break;
            default:
                jj_la1[176] = jj_gen;
                break label_98;
            }
            jj_consume_token(14);
        }
    }

    final public void SwitchElement() throws ParseException {
        int value;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case whichChoice:
            jj_consume_token(whichChoice);
            value = SFInt32Token();
            ((SwitchNode) getCurrentNode()).setWhichChoice(value);
            break;
        case choice:
            Choice();
            break;
        default:
            jj_la1[177] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void SwitchID() throws ParseException {
        jj_consume_token(Switch);
        SwitchNode snode = new SwitchNode();
        snode.setName(getDefName());
        addNode(snode);
        pushNode(snode, parserTypeSwitch);
    }

    final public void Switch() throws ParseException {
        SwitchID();
        NodeBegin();
        label_99: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case whichChoice:
            case choice:
                ;
                break;
            default:
                jj_la1[178] = jj_gen;
                break label_99;
            }
            SwitchElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void TextStringID() throws ParseException {
        jj_consume_token(string);
        pushNode(getCurrentNode(), parserTypeTextString);
    }

    final public void TextLengthID() throws ParseException {
        jj_consume_token(length);
        pushNode(getCurrentNode(), parserTypeTextLength);
    }

    final public void TextElement() throws ParseException {
        float fvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case string:
            TextStringID();
            MFStringToken();
            popNode();
            break;
        case length:
            TextLengthID();
            MFFloatToken();
            popNode();
            break;
        case maxExtent:
            jj_consume_token(maxExtent);
            fvalue = SFFloatToken();
            ((TextNode) getCurrentNode()).setMaxExtent(fvalue);
            break;
        case fontStyle:
            jj_consume_token(fontStyle);
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case FontStyle:
                label_100: while (true) {
                    switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
                    case DEF:
                        ;
                        break;
                    default:
                        jj_la1[179] = jj_gen;
                        break label_100;
                    }
                    Def();
                }
                FontStyle();
                break;
            case USE:
                Use();
                break;
            case NULL:
                jj_consume_token(NULL);
                break;
            default:
                jj_la1[180] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
            break;
        default:
            jj_la1[181] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void TextID() throws ParseException {
        jj_consume_token(Text);
        TextNode text = new TextNode();
        text.setName(getDefName());
        addNode(text);
        pushNode(text, parserTypeText);
    }

    final public void Text() throws ParseException {
        TextID();
        NodeBegin();
        label_101: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case string:
            case length:
            case maxExtent:
            case fontStyle:
                ;
                break;
            default:
                jj_la1[182] = jj_gen;
                break label_101;
            }
            TextElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void TextureCoordinateID() throws ParseException {
        jj_consume_token(TextureCoordinate);
        TextureCoordinateNode texCoord = new TextureCoordinateNode();
        texCoord.setName(getDefName());
        addNode(texCoord);
        pushNode(texCoord, parserTypeTextureCoordinate);
    }

    final public void TextureCoordinate() throws ParseException {
        TextureCoordinateID();
        NodeBegin();
        jj_consume_token(point);
        MFVec2fToken();
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void TextureTransformElement() throws ParseException {
        float vec[] = new float[2];
        float fvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case translation:
            jj_consume_token(translation);
            SFVec2fToken(vec);
            ((TextureTransformNode) getCurrentNode()).setTranslation(vec);
            break;
        case rotation:
            jj_consume_token(rotation);
            fvalue = SFFloatToken();
            ((TextureTransformNode) getCurrentNode()).setRotation(fvalue);
            break;
        case scale:
            jj_consume_token(scale);
            SFVec2fToken(vec);
            ((TextureTransformNode) getCurrentNode()).setScale(vec);
            break;
        case center:
            jj_consume_token(center);
            SFVec2fToken(vec);
            ((TextureTransformNode) getCurrentNode()).setCenter(vec);
            break;
        default:
            jj_la1[183] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void TextureTransformID() throws ParseException {
        jj_consume_token(TextureTransform);
        TextureTransformNode textureTransform = new TextureTransformNode();
        textureTransform.setName(getDefName());
        addNode(textureTransform);
        pushNode(textureTransform, parserTypeTextureTransform);
    }

    final public void TextureTransform() throws ParseException {
        TextureTransformID();
        NodeBegin();
        label_102: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case center:
            case rotation:
            case scale:
            case translation:
                ;
                break;
            default:
                jj_la1[184] = jj_gen;
                break label_102;
            }
            TextureTransformElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void TimeSensorElement() throws ParseException {
        float fvalue;
        boolean bvalue;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case enabled:
            jj_consume_token(enabled);
            bvalue = SFBoolToken();
            ((TimeSensorNode) getCurrentNode()).setEnabled(bvalue);
            break;
        case loop:
            jj_consume_token(loop);
            bvalue = SFBoolToken();
            ((TimeSensorNode) getCurrentNode()).setLoop(bvalue);
            break;
        case cycleInterval:
            jj_consume_token(cycleInterval);
            fvalue = SFFloatToken();
            ((TimeSensorNode) getCurrentNode()).setCycleInterval(fvalue);
            break;
        case startTime:
            jj_consume_token(startTime);
            fvalue = SFFloatToken();
            ((TimeSensorNode) getCurrentNode()).setStartTime(fvalue);
            break;
        case stopTime:
            jj_consume_token(stopTime);
            fvalue = SFFloatToken();
            ((TimeSensorNode) getCurrentNode()).setStopTime(fvalue);
            break;
        default:
            jj_la1[185] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void TimeSensorID() throws ParseException {
        jj_consume_token(TimeSensor);
        TimeSensorNode sensor = new TimeSensorNode();
        sensor.setName(getDefName());
        addNode(sensor);
        pushNode(sensor, parserTypeTimeSensor);
    }

    final public void TimeSensor() throws ParseException {
        TimeSensorID();
        NodeBegin();
        label_103: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case loop:
            case startTime:
            case stopTime:
            case enabled:
            case cycleInterval:
                ;
                break;
            default:
                jj_la1[186] = jj_gen;
                break label_103;
            }
            TimeSensorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void TouchSensorElement() throws ParseException {
        boolean bvalue;
        jj_consume_token(enabled);
        bvalue = SFBoolToken();
        ((TouchSensorNode) getCurrentNode()).setEnabled(bvalue);
    }

    final public void TouchSensorID() throws ParseException {
        jj_consume_token(TouchSensor);
        TouchSensorNode sensor = new TouchSensorNode();
        sensor.setName(getDefName());
        addNode(sensor);
        pushNode(sensor, parserTypeTouchSensor);
    }

    final public void TouchSensor() throws ParseException {
        TouchSensorID();
        NodeBegin();
        label_104: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case enabled:
                ;
                break;
            default:
                jj_la1[187] = jj_gen;
                break label_104;
            }
            TouchSensorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void TransformElement() throws ParseException {
        float vec[] = new float[3];
        float rot[] = new float[4];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case translation:
            jj_consume_token(translation);
            SFVec3fToken(vec);
            ((TransformNode) getCurrentNode()).setTranslation(vec);
            break;
        case rotation:
            jj_consume_token(rotation);
            SFRotationToken(rot);
            ((TransformNode) getCurrentNode()).setRotation(rot);
            break;
        case scale:
            jj_consume_token(scale);
            SFVec3fToken(vec);
            ((TransformNode) getCurrentNode()).setScale(vec);
            break;
        case scaleOrientation:
            jj_consume_token(scaleOrientation);
            SFRotationToken(rot);
            ((TransformNode) getCurrentNode()).setScaleOrientation(rot);
            break;
        case center:
            jj_consume_token(center);
            SFVec3fToken(vec);
            ((TransformNode) getCurrentNode()).setCenter(vec);
            break;
        case bboxCenter:
            jj_consume_token(bboxCenter);
            SFVec3fToken(vec);
            ((TransformNode) getCurrentNode()).setBoundingBoxCenter(vec);
            break;
        case bboxSize:
            jj_consume_token(bboxSize);
            SFVec3fToken(vec);
            ((TransformNode) getCurrentNode()).setBoundingBoxSize(vec);
            break;
        case children:
            Children();
            break;
        case addChildren:
            AddChildren();
            break;
        case removeChildren:
            RemoveChildren();
            break;
        default:
            jj_la1[188] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void TransformID() throws ParseException {
        String name = null;
        jj_consume_token(Transform);
        TransformNode transform = new TransformNode();
        transform.setName(getDefName());
        addNode(transform);
        pushNode(transform, parserTypeTransform);
    }

    final public void Transform() throws ParseException {
        TransformID();
        NodeBegin();
        label_105: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case children:
            case addChildren:
            case removeChildren:
            case bboxCenter:
            case bboxSize:
            case center:
            case rotation:
            case scale:
            case scaleOrientation:
            case translation:
                ;
                break;
            default:
                jj_la1[189] = jj_gen;
                break label_105;
            }
            TransformElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void ViewpointElement() throws ParseException {
        float vec[] = new float[3];
        float rot[] = new float[4];
        float fov;
        boolean ok;
        String string;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case position:
            jj_consume_token(position);
            SFVec3fToken(vec);
            ((ViewpointNode) getCurrentNode()).setPosition(vec);
            break;
        case orientation:
            jj_consume_token(orientation);
            SFRotationToken(rot);
            ((ViewpointNode) getCurrentNode()).setOrientation(rot);
            break;
        case fieldOfView:
            jj_consume_token(fieldOfView);
            fov = SFFloatToken();
            ((ViewpointNode) getCurrentNode()).setFieldOfView(fov);
            break;
        case jump:
            jj_consume_token(jump);
            ok = SFBoolToken();
            ((ViewpointNode) getCurrentNode()).setJump(ok);
            break;
        case description:
            jj_consume_token(description);
            string = SFStringToken();
            ((ViewpointNode) getCurrentNode()).setDescription(string);
            break;
        default:
            jj_la1[190] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void ViewpointID() throws ParseException {
        jj_consume_token(Viewpoint);
        ViewpointNode view = new ViewpointNode();
        view.setName(getDefName());
        addNode(view);
        pushNode(view, parserTypeViewpoint);
    }

    final public void Viewpoint() throws ParseException {
        ViewpointID();
        NodeBegin();
        label_106: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case description:
            case position:
            case orientation:
            case fieldOfView:
            case jump:
                ;
                break;
            default:
                jj_la1[191] = jj_gen;
                break label_106;
            }
            ViewpointElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void VisibilitySensorElement() throws ParseException {
        boolean bvalue;
        float v3value[] = new float[3];
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case center:
            jj_consume_token(center);
            SFVec3fToken(v3value);
            ((VisibilitySensorNode) getCurrentNode()).setCenter(v3value);
            break;
        case size:
            jj_consume_token(size);
            SFVec3fToken(v3value);
            ((VisibilitySensorNode) getCurrentNode()).setSize(v3value);
            break;
        case enabled:
            jj_consume_token(enabled);
            bvalue = SFBoolToken();
            ((VisibilitySensorNode) getCurrentNode()).setEnabled(bvalue);
            break;
        default:
            jj_la1[192] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void VisibilitySensorID() throws ParseException {
        jj_consume_token(VisibilitySensor);
        VisibilitySensorNode sensor = new VisibilitySensorNode();
        sensor.setName(getDefName());
        addNode(sensor);
        pushNode(sensor, parserTypeVisibilitySensor);
    }

    final public void VisibilitySensor() throws ParseException {
        VisibilitySensorID();
        NodeBegin();
        label_107: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case size:
            case enabled:
            case center:
                ;
                break;
            default:
                jj_la1[193] = jj_gen;
                break label_107;
            }
            VisibilitySensorElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void WorldInfoInfoID() throws ParseException {
        jj_consume_token(info);
        WorldInfoNode winfo = (WorldInfoNode) getCurrentNode();
        pushNode(winfo, parserTypeWorldInfoInfo);
    }

    final public void WorldInfoElement() throws ParseException {
        String string;
        switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
        case title:
            jj_consume_token(title);
            string = SFStringToken();
            ((WorldInfoNode) getCurrentNode()).setTitle(string);
            break;
        case info:
            WorldInfoInfoID();
            MFStringToken();
            popNode();
            break;
        default:
            jj_la1[194] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    final public void WorldInfoID() throws ParseException {
        jj_consume_token(WorldInfo);
        WorldInfoNode winfo = new WorldInfoNode();
        winfo.setName(getDefName());
        addNode(winfo);
        pushNode(winfo, parserTypeWorldInfo);
    }

    final public void WorldInfo() throws ParseException {
        WorldInfoID();
        NodeBegin();
        label_108: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case title:
            case info:
                ;
                break;
            default:
                jj_la1[195] = jj_gen;
                break label_108;
            }
            WorldInfoElement();
        }
        NodeEnd();
        getCurrentNode().initialize();
        popNode();
    }

    final public void Input() throws ParseException {
        label_109: while (true) {
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case USE:
            case ROUTE:
            case Anchor:
            case AudioClip:
            case Background:
            case Billboard:
            case Collision:
            case ColorInterpolator:
            case CoordinateInterpolator:
            case CylinderSensor:
            case DirectionalLight:
            case Fog:
            case Group:
            case Inline:
            case LOD:
            case NavigationInfo:
            case NormalInterpolator:
            case OrientationInterpolator:
            case PlaneSensor:
            case PointLight:
            case PositionInterpolator:
            case ProximitySensor:
            case ScalarInterpolator:
            case Script:
            case Sound:
            case SphereSensor:
            case SpotLight:
            case Shape:
            case Switch:
            case TimeSensor:
            case TouchSensor:
            case Transform:
            case Viewpoint:
            case VisibilitySensor:
            case WorldInfo:
                ;
                break;
            default:
                jj_la1[196] = jj_gen;
                break label_109;
            }
            switch ((jj_ntk == -1) ? jj_ntk() : jj_ntk) {
            case DEF:
            case USE:
            case Anchor:
            case AudioClip:
            case Background:
            case Billboard:
            case Collision:
            case ColorInterpolator:
            case CoordinateInterpolator:
            case CylinderSensor:
            case DirectionalLight:
            case Fog:
            case Group:
            case Inline:
            case LOD:
            case NavigationInfo:
            case NormalInterpolator:
            case OrientationInterpolator:
            case PlaneSensor:
            case PointLight:
            case PositionInterpolator:
            case ProximitySensor:
            case ScalarInterpolator:
            case Script:
            case Sound:
            case SphereSensor:
            case SpotLight:
            case Shape:
            case Switch:
            case TimeSensor:
            case TouchSensor:
            case Transform:
            case Viewpoint:
            case VisibilitySensor:
            case WorldInfo:
                Node();
                break;
            case ROUTE:
                Route();
                break;
            default:
                jj_la1[197] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
            }
        }
        jj_consume_token(0);
    }

    final private boolean jj_2_1(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_1();
        jj_save(0, xla);
        return retval;
    }

    final private boolean jj_2_2(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_2();
        jj_save(1, xla);
        return retval;
    }

    final private boolean jj_2_3(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_3();
        jj_save(2, xla);
        return retval;
    }

    final private boolean jj_2_4(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_4();
        jj_save(3, xla);
        return retval;
    }

    final private boolean jj_2_5(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_5();
        jj_save(4, xla);
        return retval;
    }

    final private boolean jj_2_6(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_6();
        jj_save(5, xla);
        return retval;
    }

    final private boolean jj_2_7(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_7();
        jj_save(6, xla);
        return retval;
    }

    final private boolean jj_2_8(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_8();
        jj_save(7, xla);
        return retval;
    }

    final private boolean jj_2_9(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_9();
        jj_save(8, xla);
        return retval;
    }

    final private boolean jj_2_10(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_10();
        jj_save(9, xla);
        return retval;
    }

    final private boolean jj_2_11(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_11();
        jj_save(10, xla);
        return retval;
    }

    final private boolean jj_2_12(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_12();
        jj_save(11, xla);
        return retval;
    }

    final private boolean jj_2_13(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_13();
        jj_save(12, xla);
        return retval;
    }

    final private boolean jj_2_14(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_14();
        jj_save(13, xla);
        return retval;
    }

    final private boolean jj_2_15(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_15();
        jj_save(14, xla);
        return retval;
    }

    final private boolean jj_2_16(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_16();
        jj_save(15, xla);
        return retval;
    }

    final private boolean jj_2_17(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_17();
        jj_save(16, xla);
        return retval;
    }

    final private boolean jj_2_18(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_18();
        jj_save(17, xla);
        return retval;
    }

    final private boolean jj_2_19(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_19();
        jj_save(18, xla);
        return retval;
    }

    final private boolean jj_2_20(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_20();
        jj_save(19, xla);
        return retval;
    }

    final private boolean jj_2_21(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_21();
        jj_save(20, xla);
        return retval;
    }

    final private boolean jj_2_22(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_22();
        jj_save(21, xla);
        return retval;
    }

    final private boolean jj_2_23(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_23();
        jj_save(22, xla);
        return retval;
    }

    final private boolean jj_2_24(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_24();
        jj_save(23, xla);
        return retval;
    }

    final private boolean jj_2_25(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_25();
        jj_save(24, xla);
        return retval;
    }

    final private boolean jj_2_26(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_26();
        jj_save(25, xla);
        return retval;
    }

    final private boolean jj_2_27(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_27();
        jj_save(26, xla);
        return retval;
    }

    final private boolean jj_2_28(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_28();
        jj_save(27, xla);
        return retval;
    }

    final private boolean jj_2_29(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_29();
        jj_save(28, xla);
        return retval;
    }

    final private boolean jj_2_30(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_30();
        jj_save(29, xla);
        return retval;
    }

    final private boolean jj_2_31(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_31();
        jj_save(30, xla);
        return retval;
    }

    final private boolean jj_2_32(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_32();
        jj_save(31, xla);
        return retval;
    }

    final private boolean jj_2_33(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_33();
        jj_save(32, xla);
        return retval;
    }

    final private boolean jj_2_34(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_34();
        jj_save(33, xla);
        return retval;
    }

    final private boolean jj_2_35(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_35();
        jj_save(34, xla);
        return retval;
    }

    final private boolean jj_2_36(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_36();
        jj_save(35, xla);
        return retval;
    }

    final private boolean jj_2_37(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_37();
        jj_save(36, xla);
        return retval;
    }

    final private boolean jj_2_38(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_38();
        jj_save(37, xla);
        return retval;
    }

    final private boolean jj_2_39(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_39();
        jj_save(38, xla);
        return retval;
    }

    final private boolean jj_2_40(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_40();
        jj_save(39, xla);
        return retval;
    }

    final private boolean jj_2_41(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_41();
        jj_save(40, xla);
        return retval;
    }

    final private boolean jj_2_42(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_42();
        jj_save(41, xla);
        return retval;
    }

    final private boolean jj_2_43(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_43();
        jj_save(42, xla);
        return retval;
    }

    final private boolean jj_2_44(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_44();
        jj_save(43, xla);
        return retval;
    }

    final private boolean jj_2_45(int xla) {
        jj_la = xla;
        jj_lastpos = jj_scanpos = token;
        boolean retval = !jj_3_45();
        jj_save(44, xla);
        return retval;
    }

    final private boolean jj_3_10() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFColor))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_25() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFVec2f))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_39() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFRotation))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_24() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFTime))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_9() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFVec3f))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_38() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFInt32))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_23() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFString))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_8() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFVec2f))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3R_110() {
        if (jj_scan_token(ID))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_37() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFFloat))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_22() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFRotation))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_7() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFTime))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_36() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFColor))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_21() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFInt32))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_6() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFString))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_35() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFBool))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_20() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFFloat))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_5() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFRotation))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_19() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFColor))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_4() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFInt32))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_34() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFVec3f))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_18() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFBool))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_3() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFFloat))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_33() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFVec2f))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_2() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFColor))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_32() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFTime))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_17() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFVec3f))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_1() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFBool))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_31() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFString))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_16() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFVec2f))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_45() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFNode))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_30() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFRotation))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_15() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFTime))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_44() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFNode))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_29() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFInt32))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_14() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFString))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_43() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFVec3f))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_28() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFFloat))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_13() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFRotation))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_42() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFVec2f))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_27() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFColor))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_12() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFInt32))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_41() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFTime))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_11() {
        if (jj_scan_token(eventIn))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(MFFloat))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_3R_110())
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_26() {
        if (jj_scan_token(eventOut))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFVec3f))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    final private boolean jj_3_40() {
        if (jj_scan_token(field))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        if (jj_scan_token(SFString))
            return true;
        if (jj_la == 0 && jj_scanpos == jj_lastpos)
            return false;
        return false;
    }

    public VRML97ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token, jj_nt;
    private int jj_ntk;
    private Token jj_scanpos, jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    final private int[] jj_la1 = new int[198];
    final private int[] jj_la1_0 = { 0x400, 0x1800, 0x0, 0x0, 0x400, 0x2000,
            0x0, 0x0, 0x400, 0x2000, 0x0, 0x0, 0x400, 0x2000, 0x0, 0x400,
            0x2000, 0x0, 0x400, 0x2000, 0x0, 0x400, 0x2000, 0x0, 0x400, 0x2000,
            0x0, 0x400, 0x2000, 0x0, 0x8000, 0x410000, 0x410000, 0x0, 0x0, 0x0,
            0x400000, 0x0, 0x0, 0x0, 0x410080, 0x2000, 0x418080, 0x8000,
            0x4000, 0x2000, 0x418080, 0x8000, 0x4000, 0x2000, 0x418080, 0x8000,
            0x4000, 0xf800040, 0xf800040, 0x8000, 0x18080, 0x8000, 0x18080,
            0x8000, 0x0, 0x8080, 0xe0000000, 0xe0000000, 0x2800000, 0x2800000,
            0x0, 0x0, 0xc000040, 0xc000040, 0x0, 0x410080, 0xc000040,
            0xc000040, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x8000, 0x18080, 0x8000, 0x18080, 0x8000, 0x18080, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc300040, 0xc300040, 0x800000,
            0x800000, 0x8000, 0x18080, 0x8000, 0x18080, 0x8000, 0x18080,
            0x8000, 0x18080, 0x0, 0x0, 0x8000, 0x18080, 0x8000, 0x18080, 0x0,
            0x0, 0xc800000, 0xc800000, 0x2000, 0x418080, 0x8000, 0x4000, 0x0,
            0x0, 0x0, 0x0, 0x800000, 0x800000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8000, 0x18080, 0x8000, 0x18080,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800000, 0x800000, 0x8000,
            0x18080, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8000, 0x18080,
            0x8000, 0x10018080, 0x0, 0x0, 0x2000, 0x418080, 0x8000, 0x4000,
            0x0, 0x0, 0x8000, 0x18080, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0xc300040, 0xc300040, 0x2000000, 0x2000000, 0x0, 0x0, 0x0, 0x0,
            0x438000, 0x438000, };
    final private int[] jj_la1_1 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2110021,
            0x2110021, 0x0, 0x2000000, 0x0, 0x110000, 0x1, 0x4040000, 0x20,
            0x2110021, 0x0, 0x2110021, 0x0, 0x0, 0x0, 0x2110021, 0x0, 0x0, 0x0,
            0x2110021, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x1e, 0x1e, 0xffc0, 0xffc0, 0x20000, 0x20000, 0x80000,
            0x2110021, 0x600000, 0x600000, 0x0, 0x0, 0x78000000, 0x78000000,
            0x0, 0x0, 0x68000000, 0x68000000, 0x0, 0x0, 0x1000000, 0x1000000,
            0x0, 0x0, 0x0, 0x800000, 0x0, 0x0, 0x9000000, 0x9000000, 0x0, 0x0,
            0x1000000, 0x1000000, 0x80000, 0x80000, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x80000000, 0x0, 0x0, 0x0, 0x800000, 0x0, 0x0, 0x1000000,
            0x1000000, 0x0, 0x80000000, 0x0, 0x800000, 0x1000000, 0x1000000,
            0x0, 0x0, 0x0, 0x2110021, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1a, 0x1a,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1000000,
            0x1000000, 0x0, 0x800000, 0x0, 0x80000000, 0x1000000, 0x1000000,
            0x0, 0x0, 0x80000, 0x80000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x1000000, 0x1000000, 0x0, 0x4040000, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x2110021, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x1a, 0x1a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80000, 0x80000, 0x0,
            0x0, 0x2110021, 0x2110021, };
    final private int[] jj_la1_2 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4082, 0x4082,
            0x80, 0x2, 0x4000, 0x0, 0x0, 0x20080010, 0x0, 0x4082, 0x0, 0x4082,
            0x0, 0x0, 0x0, 0x4082, 0x0, 0x0, 0x0, 0x4082, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x4082, 0x0, 0x0, 0xc, 0xc, 0x0, 0x0, 0xc, 0xc,
            0x60, 0x60, 0x3f00, 0x3f00, 0x78000, 0x78000, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x1ff00000, 0x1ff00000, 0xc1500000, 0xc1500000, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x1f00000, 0x1f00000, 0x0, 0x0, 0x0, 0x0, 0x200000, 0x200000,
            0x0, 0x0, 0x0, 0x4082, 0x0, 0x0, 0x0, 0x0, 0x20000, 0x20000, 0x0,
            0x0, 0x0, 0x0, 0xc, 0xc, 0xc, 0xc, 0x0, 0x0, 0x3400, 0x3400,
            0x38040, 0x38040, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x400,
            0x400, 0xc, 0xc, 0x0, 0x0, 0x0, 0x0, 0x50000, 0x50000, 0x40,
            0x3400, 0x3400, 0x78040, 0x78040, 0x0, 0x20080010, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x4082, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x400, 0x400, 0x400, 0x0, 0x0, 0x0, 0x0, 0x400, 0x400, 0x0, 0x0,
            0x4082, 0x4082, };
    final private int[] jj_la1_3 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30004004,
            0x30004004, 0x0, 0x0, 0x0, 0x30004000, 0x0, 0x8040000, 0x4,
            0x30004004, 0x0, 0x30004004, 0x0, 0x0, 0x0, 0x30004004, 0x0, 0x0,
            0x0, 0x30004004, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x8000, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x30004004, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x300000, 0x300000,
            0x4000003, 0x4000003, 0x18, 0x18, 0x3fc0, 0x3fc0, 0x0, 0x0,
            0x30000, 0x30000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x7f80000, 0x7f80000, 0x0, 0x0, 0x0, 0x0, 0xc80000, 0xc80000, 0x0,
            0x0, 0x0, 0x30004004, 0x0, 0x0, 0xc0000000, 0xc0000000, 0x0, 0x0,
            0x30000, 0x30000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30000, 0x30000,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80000, 0x80000, 0x0, 0x0,
            0x40000000, 0x40000000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8040000, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x30004004, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x40000000,
            0x40000000, 0x0, 0x0, 0x0, 0x40000000, 0x40000000, 0x0, 0x0,
            0x40000000, 0x40000000, 0x0, 0x0, 0x30004004, 0x30004004, };
    final private int[] jj_la1_4 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x78930200,
            0x78930200, 0x10100000, 0x28030000, 0x800000, 0x0, 0x0, 0x4000000,
            0x200, 0x78930200, 0x0, 0x78930200, 0x0, 0x0, 0x0, 0x78930200, 0x0,
            0x0, 0x0, 0x78930200, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0,
            0x40080, 0x40080, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x78930200, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x4000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4000, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x78930200, 0x0, 0x0, 0x1, 0x1, 0x7c, 0x7c, 0x100, 0x100,
            0x3d00, 0x3d00, 0x0, 0x0, 0x0, 0x0, 0x80000, 0x80000, 0x600000,
            0x600000, 0x3000000, 0x3000000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x80000000, 0x80000000, 0x0, 0x0,
            0x1000000, 0x1000000, 0x0, 0x0, 0x0, 0x3000000, 0x3000000, 0x0,
            0x4000000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x78930200, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x78930200, 0x78930200, };
    final private int[] jj_la1_5 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800000,
            0x800000, 0x0, 0x0, 0x0, 0x0, 0x800000, 0x80000000, 0x0, 0x800000,
            0x0, 0x800000, 0x0, 0x0, 0x0, 0x800000, 0x0, 0x0, 0x0, 0x800000,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800000, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800000, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x1, 0xf, 0x0, 0x0, 0x7f000000, 0x7f000000, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x80000000, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x800000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x800000,
            0x800000, };
    final private int[] jj_la1_6 = { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc21a0093,
            0xc21a0093, 0x40080001, 0x0, 0x2, 0x100080, 0x10, 0x400,
            0x82000000, 0xc21a0093, 0x0, 0xc21a0093, 0x0, 0x0, 0x0, 0xc21a0093,
            0x0, 0x0, 0x0, 0xc21a0093, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x10000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0xc21a0093, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8000, 0x0, 0x0,
            0x8400000, 0x8400000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0xc21a0093, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xc, 0x0, 0x400,
            0x0, 0x0, 0x60, 0x60, 0x0, 0xc21a0093, 0x0, 0x0, 0x300, 0x300, 0x0,
            0x0, 0x7800, 0x7800, 0x1600000, 0x1600000, 0x40000, 0x40000, 0x0,
            0x1e00000, 0x1e00000, 0x3c000000, 0x3c000000, 0x0, 0x0, 0x0, 0x0,
            0xc21a0093, 0xc21a0093, };
    final private int[] jj_la1_7 = { 0x0, 0x0, 0x24, 0x24, 0x0, 0x24, 0x24,
            0x24, 0x0, 0x24, 0x44, 0x44, 0x0, 0x44, 0x24, 0x0, 0x24, 0x24, 0x0,
            0x24, 0x24, 0x0, 0x24, 0x24, 0x0, 0x24, 0x10, 0x0, 0x10, 0x44, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
            0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x3, 0x0, 0x0, };
    final private JJCalls[] jj_2_rtns = new JJCalls[45];
    private boolean jj_rescan = false;
    private int jj_gc = 0;

    public VRML97Parser(java.io.InputStream stream) {
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new VRML97ParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 198; i++)
            jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++)
            jj_2_rtns[i] = new JJCalls();
    }

    public void ReInit(java.io.InputStream stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 198; i++)
            jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++)
            jj_2_rtns[i] = new JJCalls();
    }

    public VRML97Parser(java.io.Reader stream) {
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source = new VRML97ParserTokenManager(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 198; i++)
            jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++)
            jj_2_rtns[i] = new JJCalls();
    }

    public void ReInit(java.io.Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 198; i++)
            jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++)
            jj_2_rtns[i] = new JJCalls();
    }

    public VRML97Parser(VRML97ParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 198; i++)
            jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++)
            jj_2_rtns[i] = new JJCalls();
    }

    public void ReInit(VRML97ParserTokenManager tm) {
        token_source = tm;
        token = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 198; i++)
            jj_la1[i] = -1;
        for (int i = 0; i < jj_2_rtns.length; i++)
            jj_2_rtns[i] = new JJCalls();
    }

    final private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken;
        if ((oldToken = token).next != null)
            token = token.next;
        else
            token = token.next = token_source.getNextToken();
        jj_ntk = -1;
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen)
                            c.first = null;
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    final private boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source
                        .getNextToken();
            } else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        } else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int i = 0;
            Token tok = token;
            while (tok != null && tok != jj_scanpos) {
                i++;
                tok = tok.next;
            }
            if (tok != null)
                jj_add_error_token(kind, i);
        }
        return (jj_scanpos.kind != kind);
    }

    final public Token getNextToken() {
        if (token.next != null)
            token = token.next;
        else
            token = token.next = token_source.getNextToken();
        jj_ntk = -1;
        jj_gen++;
        return token;
    }

    final public Token getToken(int index) {
        Token t = lookingAhead ? jj_scanpos : token;
        for (int i = 0; i < index; i++) {
            if (t.next != null)
                t = t.next;
            else
                t = t.next = token_source.getNextToken();
        }
        return t;
    }

    final private int jj_ntk() {
        if ((jj_nt = token.next) == null)
            return (jj_ntk = (token.next = token_source.getNextToken()).kind);
        else
            return (jj_ntk = jj_nt.kind);
    }

    private java.util.Vector jj_expentries = new java.util.Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100)
            return;
        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }
            boolean exists = false;
            for (java.util.Enumeration enume = jj_expentries.elements(); enume
                    .hasMoreElements();) {
                int[] oldentry = (int[]) (enume.nextElement());
                if (oldentry.length == jj_expentry.length) {
                    exists = true;
                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            exists = false;
                            break;
                        }
                    }
                    if (exists)
                        break;
                }
            }
            if (!exists)
                jj_expentries.addElement(jj_expentry);
            if (pos != 0)
                jj_lasttokens[(jj_endpos = pos) - 1] = kind;
        }
    }

    final public ParseException generateParseException() {
        jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[232];
        for (int i = 0; i < 232; i++) {
            la1tokens[i] = false;
        }
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind = -1;
        }
        for (int i = 0; i < 198; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & (1 << j)) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & (1 << j)) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jj_la1_2[i] & (1 << j)) != 0) {
                        la1tokens[64 + j] = true;
                    }
                    if ((jj_la1_3[i] & (1 << j)) != 0) {
                        la1tokens[96 + j] = true;
                    }
                    if ((jj_la1_4[i] & (1 << j)) != 0) {
                        la1tokens[128 + j] = true;
                    }
                    if ((jj_la1_5[i] & (1 << j)) != 0) {
                        la1tokens[160 + j] = true;
                    }
                    if ((jj_la1_6[i] & (1 << j)) != 0) {
                        la1tokens[192 + j] = true;
                    }
                    if ((jj_la1_7[i] & (1 << j)) != 0) {
                        la1tokens[224 + j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 232; i++) {
            if (la1tokens[i]) {
                jj_expentry = new int[1];
                jj_expentry[0] = i;
                jj_expentries.addElement(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = (int[]) jj_expentries.elementAt(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    final public void enable_tracing() {
    }

    final public void disable_tracing() {
    }

    final private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 45; i++) {
            JJCalls p = jj_2_rtns[i];
            do {
                if (p.gen > jj_gen) {
                    jj_la = p.arg;
                    jj_lastpos = jj_scanpos = p.first;
                    switch (i) {
                    case 0:
                        jj_3_1();
                        break;
                    case 1:
                        jj_3_2();
                        break;
                    case 2:
                        jj_3_3();
                        break;
                    case 3:
                        jj_3_4();
                        break;
                    case 4:
                        jj_3_5();
                        break;
                    case 5:
                        jj_3_6();
                        break;
                    case 6:
                        jj_3_7();
                        break;
                    case 7:
                        jj_3_8();
                        break;
                    case 8:
                        jj_3_9();
                        break;
                    case 9:
                        jj_3_10();
                        break;
                    case 10:
                        jj_3_11();
                        break;
                    case 11:
                        jj_3_12();
                        break;
                    case 12:
                        jj_3_13();
                        break;
                    case 13:
                        jj_3_14();
                        break;
                    case 14:
                        jj_3_15();
                        break;
                    case 15:
                        jj_3_16();
                        break;
                    case 16:
                        jj_3_17();
                        break;
                    case 17:
                        jj_3_18();
                        break;
                    case 18:
                        jj_3_19();
                        break;
                    case 19:
                        jj_3_20();
                        break;
                    case 20:
                        jj_3_21();
                        break;
                    case 21:
                        jj_3_22();
                        break;
                    case 22:
                        jj_3_23();
                        break;
                    case 23:
                        jj_3_24();
                        break;
                    case 24:
                        jj_3_25();
                        break;
                    case 25:
                        jj_3_26();
                        break;
                    case 26:
                        jj_3_27();
                        break;
                    case 27:
                        jj_3_28();
                        break;
                    case 28:
                        jj_3_29();
                        break;
                    case 29:
                        jj_3_30();
                        break;
                    case 30:
                        jj_3_31();
                        break;
                    case 31:
                        jj_3_32();
                        break;
                    case 32:
                        jj_3_33();
                        break;
                    case 33:
                        jj_3_34();
                        break;
                    case 34:
                        jj_3_35();
                        break;
                    case 35:
                        jj_3_36();
                        break;
                    case 36:
                        jj_3_37();
                        break;
                    case 37:
                        jj_3_38();
                        break;
                    case 38:
                        jj_3_39();
                        break;
                    case 39:
                        jj_3_40();
                        break;
                    case 40:
                        jj_3_41();
                        break;
                    case 41:
                        jj_3_42();
                        break;
                    case 42:
                        jj_3_43();
                        break;
                    case 43:
                        jj_3_44();
                        break;
                    case 44:
                        jj_3_45();
                        break;
                    }
                }
                p = p.next;
            } while (p != null);
        }
        jj_rescan = false;
    }

    final private void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = jj_gen + xla - jj_la;
        p.first = token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;
    }

}
