/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/08, 11:44
!  AUTHOR(S): KOGA, Junichiro
!  File : ComboButton.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.primitiveguis;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.filebrowser.FileBrowserUtils;
import ciss.phase_viewer.inputinterface.filestate.FileStateChangeEvent;
import ciss.phase_viewer.inputinterface.filestate.FileStateListener;
import ciss.phase_viewer.inputinterface.filestate.FileStateObserver;

/**
 * R{{bNXƃ{^̂GUI; Ⴆ΃C[Wt@CȂC[Wr[A[, uqzut@CvȂ猴qzur[A[N,
 * Ȏdg.
 * 
 * @author
 */
public class ComboButton extends JPanel implements FileStateListener {
    private Logger logger = Logger.getLogger(ComboButton.class.getName());
    private String dir;
    private String[] filters;
    private JComboBox comboBox;
    private JButton button;

    /**
     * x[XƂȂfBNg[, ̃fBNg[̂ǂ̃t@CR{{bNX \邩w肷邽߂̃tB^[n.
     * 
     * @param dir
     *            x[XƂȂfBNg[
     * @param filter
     *            R{{bNXɕ\t@C̃tB^[; String#matches\bhŔ肷.
     */
    public ComboButton(String dir, String filter) {
        this.dir = dir;
        this.filters = new String[] { filter };
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        FileStateObserver obs = new FileStateObserver(dir, filters);
        init();
        obs.addFileStateListener(this);
    }

    /**
     * x[XƂȂfBNg[, ̃fBNg[̂ǂ̃t@CR{{bNX \邩w肷邽߂̃tB^[n.
     * ̃tB^[n.
     * 
     * @param dir
     *            x[XƂȂfBNg[
     * @param filters
     *            R{{bNXɕ\t@C̃tB^[̔z; String#matches\bhŔ肷.
     */
    public ComboButton(String dir, String[] filters) {
        this.dir = dir;
        this.filters = filters;
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        FileStateObserver obs = new FileStateObserver(dir, filters);
        init();
        obs.addFileStateListener(this);
    }

    private void init() {
        String[] files = new File(dir).list();
        if (files != null && files.length > 0) {
            Vector vector = new Vector();
            for (int i = 0; i < files.length; i++) {
                for (int j = 0; j < filters.length; j++) {
                    if (files[i].matches(filters[j])) {
                        vector.addElement(files[i]);
                    }
                }
            }
            if (vector.size() != 0) {
                comboBox = new JComboBox(vector);
                button = new JButton("view");
                button.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent e) {
                        FileBrowserUtils.bootProgram(false,
                                dir
                                        + System.getProperty("file.separator")
                                        + comboBox.getSelectedItem().toString()
                                                .trim());
                    }
                });
                add(comboBox);
                add(button);
            }
        }
    }

    public void recreate() {
        removeAll();
        init();
    }

    public void fileStateChanged(FileStateChangeEvent fe) {
        logger.debug(fe);
        recreate();
        revalidate();
    }

}
