/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/16, 15:23
!  AUTHOR(S): KOGA, Junichiro
!  File : StaticTensor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.stdout;

import java.awt.BorderLayout;
import java.awt.GridLayout;

import javax.swing.JPanel;
import javax.swing.JTextArea;

import org.apache.log4j.Logger;

import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel.parsers.Output000Parser;
import ciss.phase_viewer.projectbrowser.tools.StdoutBasePanel;

/**
 * ÓIUde\Ȃǂ̏\.
 * 
 * @author
 */
public class StaticTensor extends StdoutBasePanel {
    private Logger logger = Logger.getLogger(StaticTensor.class.getName());

    /** Creates a new instance of StaticTensor */
    public StaticTensor() {
        setLayout(new BorderLayout());
    }

    public String getDescription() {
        return "static tensors";
    }

    public void create() {
        if (outputParser == null) {
            return;
        }
        removeAll();
        JPanel pstatic = new JPanel();
        pstatic.setLayout(new GridLayout());
        JTextArea jta = new JTextArea();
        jta.setEditable(false);
        jta.setText(outputParser.getGenericData(Output000Parser.STATIC_TENSOR)[0]);
        jta.setBackground(getBackground());
        pstatic.add(jta);
        add(pstatic, BorderLayout.CENTER);
    }

}
