/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/15, 15:21
!  AUTHOR(S): KOGA, Junichiro
!  File : StdoutGeneralPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.plugins.projectmanipulator.stdout.JobStatusPanel;
import ciss.phase_viewer.projectbrowser.tools.StdoutBasePanel;

/**
 * 
 * @author
 */
public class StdoutGeneralPanel extends StdoutBasePanel {
    private Logger logger = Logger
            .getLogger(StdoutGeneralPanel.class.getName());

    private JobStatusPanel jsp;

    /** Creates a new instance of StdoutGeneralPanel */
    public StdoutGeneralPanel() {
        // setLayout(new BoxLayout(this,BoxLayout.Y_AXIS));
        setLayout(new BorderLayout());
    }

    public void create() {
        if (outputParser == null) {
            return;
        }

        removeAll();

        JPanel pa = new JPanel();
        GridBagLayout grid = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();

        pa.setLayout(grid);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        constraints.weightx = 1;
        constraints.weighty = 0;

        JPanel ptime = new JPanel();
        ptime.setBorder(new TitledBorder("job status"));
        if (jsp == null) {
            jsp = new JobStatusPanel(outputParser.getParent().getProjectInfo());
            jsp.setFileName(outputParser.getFileName());
        } else {
            jsp.setFileName(outputParser.getFileName());
        }
        ptime.add(jsp);
        pa.add(ptime, constraints);

        constraints.gridx = 0;
        constraints.gridy = 1;
        JPanel pproc = new JPanel();
        // pproc.setLayout(new BoxLayout(pproc,BoxLayout.X_AXIS));
        pproc.setBorder(new TitledBorder("MPI info:"));
        String[] npnenk = outputParser.getGenericData("nproc");
        JLabel lnp = new JLabel("     number of processors: " + npnenk[0]);
        JLabel lep = new JLabel("                    band   parallelization : "
                + npnenk[1]);
        JLabel lnk = new JLabel("                    kpoint parallelization : "
                + npnenk[2] + "     ");
        pproc.add(lnp);
        pproc.add(lep);
        pproc.add(lnk);
        pa.add(pproc, constraints);

        constraints.gridx = 0;
        constraints.gridy = 2;
        JPanel nenk = new JPanel();
        // nenk.setLayout(new BoxLayout(nenk,BoxLayout.X_AXIS));
        nenk.setBorder(new TitledBorder(
                "number of bands and generated k-points"));
        String[] negkv3 = outputParser.getGenericData("negkv3");
        JLabel lneg = new JLabel("          number of eigen values:        "
                + negkv3[0]);
        JLabel lnkv3 = new JLabel("         number of generated kpoints:   "
                + negkv3[1] + "     ");
        nenk.add(lneg);
        nenk.add(lnkv3);
        pa.add(nenk, constraints);

        constraints.gridx = 0;
        constraints.gridy = 3;
        JPanel fermi_and_metallic = new JPanel();
        fermi_and_metallic.setBorder(new TitledBorder("Fermi energy"));
        String[] fermi = outputParser.getGenericData("fermi");
        JLabel lfermi = new JLabel("      fermi energy:      " + fermi[0]
                + "      is the system metallic? " + fermi[1] + "      ");
        fermi_and_metallic.add(lfermi);
        pa.add(fermi_and_metallic, constraints);

        add(pa, BorderLayout.NORTH);
    }

    public String getDescription() {
        return "general";
    }
}
