/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : MovieViewer.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.movie;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.swing.JFileChooser;
import javax.swing.JMenuBar;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.MyJMenu;
import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.mainpanel.FrameChase;

//public class MovieViewer extends InternalFrameChase implements ControllerListener {
public class MovieViewer extends FrameChase implements ControllerListener {
    private static Logger logger = Logger
            .getLogger(MovieViewer.class.getName());

    private Player player = null;
    private String fileName;

    private Container cont;

    public MovieViewer(String fileName) {
        super(fileName, new Dimension(500, 500));
        this.setVisible(true);
        this.fileName = fileName;
        init();
    }

    public void init() {
        cont = getContentPane();
        cont.setLayout(new BorderLayout());
        this.setJMenuBar(new MovieViewerMenuBar(this));
        setMovieFile(fileName);
        addWindowListener(new WindowAdapter() {
            public void windowClosed(WindowEvent e) {
                exi();
            }
        });
    }

    private void exi() {
        logger.info("movie viewer closed.");
        player.stop();
        player.removeControllerListener(this);
        player.close();
        player = null;
        oml = null;
    }

    // public boolean isHeavyWeight() {
    // return true;
    // }

    protected void stopAllAnimations() {
        player.stop();
    }

    private MediaLocator oml;

    public void setMovieFile(String movieFile) {
        try {
            player = null;
            if ((oml = MovieUtils.createMediaLocator(movieFile)) == null) {
                logger.error("failed to obtain media locator from: " + fileName);
                return;
            }
            player = Manager.createPlayer(oml);
            player.addControllerListener(this);
        } catch (Exception e) {
            logger.warn("failed to set player");
        }
        super.setTitle(movieFile);
        cont.validate();
        player.start();
    }

    public void controllerUpdate(ControllerEvent event) {
        logger.debug("updating controller ...");
        if (event instanceof RealizeCompleteEvent) {
            Component comp;
            if ((comp = player.getVisualComponent()) != null) {
                cont.add("Center", comp);
            }
            if ((comp = player.getControlPanelComponent()) != null) {
                cont.add("South", comp);
            }
            cont.validate();
        }
    }

}

class MovieViewerMenuBar extends JMenuBar {
    private static Logger logger = Logger.getLogger(MovieViewerMenuBar.class
            .getName());

    private MovieViewer parent;

    protected MovieViewerMenuBar(MovieViewer parent) {
        this.parent = parent;
        this.createMenu();
    }

    private void createMenu() {
        this.add(fileMenu());
    }

    private MyJMenu fileMenu() {
        MyJMenu file = new MyJMenu("File", KeyEvent.VK_F, false);

        MyJMenuItem open = new MyJMenuItem("open", KeyEvent.VK_O);
        file.add(open);

        MyJMenuItem exit = new MyJMenuItem("exit", KeyEvent.VK_X);
        file.add(exit);

        // externalt@CJ ... ܂Ȃ; yfBO.
        open.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String movieFile = getFileName();
                if (movieFile != null && (new File(movieFile)).exists()) {
                    logger.debug("setting movie file: " + movieFile);
                    parent.setMovieFile("file:" + movieFile);
                } else {
                    logger.warn("couldn't open movie file: " + movieFile);
                }
            }
        });

        exit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                parent.dispose();
            }
        });

        return file;
    }

    private String getFileName() {
        ChaseFileChooser fdlg = new ChaseFileChooser(ChaseFileChooser.media);
        fdlg.setDialogType(JFileChooser.CUSTOM_DIALOG);
        fdlg.setDialogTitle("movie file");
        fdlg.setFileSelectionMode(JFileChooser.FILES_ONLY);
        if (fdlg.showDialog(parent, "Select") != JFileChooser.APPROVE_OPTION) {
            return null;
        }
        return fdlg.getSelectedFile().getAbsolutePath();
    }

}
