/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/03/15, 13:09
!  AUTHOR(S): KOGA, Junichiro
!  File : DirBrowserMenu.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.mainpanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

import org.apache.log4j.Logger;

import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserMenu;

/**
 * 
 * @author
 */
public class DirBrowserMenu extends JMenu {
    private Logger logger = Logger.getLogger(DirBrowserMenu.class.getName());
    private ProjectDirBrowser browser;

    /** Creates a new instance of DirBrowserMenu */
    public DirBrowserMenu(String title, ProjectDirBrowser browser) {
        super(title);
        this.browser = browser;
        init();
    }

    public DirBrowserMenu(String title, int shortcut, ProjectDirBrowser browser) {
        super(title);
        this.browser = browser;
        setMnemonic(shortcut);
        init();
    }

    /**
     * "lightweight" Ŗ邱Ƃ.
     */
    public DirBrowserMenu(String title, int shortcut, boolean lightWeight,
            ProjectDirBrowser browser) {
        super(title);
        this.browser = browser;
        setMnemonic(shortcut);
        this.getPopupMenu().setLightWeightPopupEnabled(lightWeight);
        init();
    }

    private void init() {
        addMenuListener(new MenuListenerDirBrowser());
    }

    class MenuListenerDirBrowser implements MenuListener {
        public void menuSelected(MenuEvent e) {
            ProjectDirBrowserMenu menu = new ProjectDirBrowserMenu(browser);
            JMenuItem[] items = menu.getMenuItems();
            JMenuItem exit = new JMenuItem("exit");
            exit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q,
                    KeyEvent.CTRL_MASK));
            exit.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent ae) {
                    System.exit(0);
                }
            });
            if (items == null) {
                add(exit);
                return;
            }

            for (int i = 0; i < items.length; i++) {
                if (items[i] == null) {
                    if (i != items.length - 1) {
                        addSeparator();
                    }
                } else {
                    add(items[i]);
                }
            }
            addSeparator();
            add(exit);
        }

        public void menuDeselected(MenuEvent e) {
            removeAll();
        }

        public void menuCanceled(MenuEvent e) {
            removeAll();
        }
    }
}
