/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : Desktop4Frame.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.mainpanel;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

public class Desktop4Frame implements ChaseDesktop {
    private static Logger logger = Logger.getLogger(Desktop4Frame.class
            .getName());

    private static Desktop4Frame desktop;

    protected final static int screenWidth = ChaseGUI.getScreenWidth();
    protected final static int screenHeight = ChaseGUI.getScreenHeight();

    private static Vector children = new Vector();

    private GlobalProperties gp;

    private Desktop4Frame() {
        super();
    }

    public static Desktop4Frame getDesktop() {
        if (desktop == null) {
            desktop = new Desktop4Frame();
        }
        return desktop;
    }

    protected void remove(FrameChase child) {
        children.remove(child);
    }

    protected void add(FrameChase child) {
        children.addElement(child);
    }

    public void componentShown() {
        update();
    }

    public void componentResized() {
        update();
    }

    public void componentMoved() {
        update();
    }

    public void componentHidden() {
        update();
    }

    public void initialLocation(Component frameNow) {
        initialLocation(frameNow, ChaseFrame.AUTOMATIC);
    }

    public void initialLocation(Component frameNow, int location) {
        Component activeComponent = getActiveComponent();
        if (activeComponent == null || activeComponent == frameNow) {
            logger.debug("activeComponent == null");
            frameNow.setLocation(0, 0);
            return;
        }

        if (location == ChaseFrame.AUTOMATIC) {
            gp = PropertiesManager
                    .getGlobalProperties(PropertiesManager.PROPERTIES_PVIEWER);
            String initial_position = gp.getProperty("initial_position");
            boolean tile = false;
            if (initial_position != null
                    && initial_position.trim().equals("tile")) {
                tile = true;
            }
            locationAuto(activeComponent, frameNow, screenWidth, screenHeight,
                    tile);
        } else if (location == ChaseFrame.CENTER) {
            locationCenter(activeComponent, frameNow);
        }
    }

    protected void locationAuto(Component activeComponent,
            Component currComponent, int widthThis, int heightThis, boolean tile) {
        int hidari = activeComponent.getLocation().x;
        int migi = hidari + activeComponent.getSize().width;
        int ue = activeComponent.getLocation().y;
        int sita = ue + activeComponent.getSize().height;
        if (!tile) {
            int overlap_x = 20;
            int overlap_y = 20;

            String ox = gp.getProperty("overlap_x");
            String oy = gp.getProperty("overlap_y");
            if (ox != null) {
                try {
                    overlap_x = Integer.parseInt(ox);
                } catch (NumberFormatException nfe) {
                    overlap_x = 20;
                }
            }
            Point point = activeComponent.getLocation();
            Point newpoint = new Point(point.x + overlap_x, point.y + overlap_y);
            currComponent.setLocation(newpoint);
            return;
        }

        logger.debug("hidari, migi, ue, sita: " + hidari + " " + migi + " "
                + ue + " " + sita);

        float a = (float) hidari / (float) widthThis;
        float b = (float) ue / (float) heightThis;
        float c = (float) (widthThis - migi) / (float) widthThis;
        if (c < 0.f) {
            c = 0.f;
        }
        float d = (float) (heightThis - sita) / (float) heightThis;
        if (d < 0.f) {
            d = 0.f;
        }

        float comp = 0.f;
        int index = 1;

        if (a > comp) {
            comp = a;
            index = 1;
        }

        if (b > comp) {
            comp = b;
            index = 2;
        }

        if (c > comp) {
            comp = c;
            index = 3;
        }

        if (d > comp) {
            comp = d;
            index = 4;
        }

        logger.debug("a,b,c,d,index: " + index + " " + a + " " + b + " " + c
                + " " + d);
        int locx = 0;
        int locy = 0;

        if (index == 1) {
            locx = hidari - currComponent.getSize().width;
            locy = ue;
        } else if (index == 2) {
            locx = hidari;
            locy = ue - currComponent.getSize().height;
        } else if (index == 3) {
            locx = migi;
            locy = ue;
        } else if (index == 4) {
            locx = hidari;
            locy = sita;
        }

        // if ( locx + currComponent.getSize().width > widthThis ) {
        // locx = widthThis - currComponent.getSize().width;
        // }
        // if ( locy + currComponent.getSize().height > heightThis ) {
        // locy = heightThis - currComponent.getSize().height;
        // }

        currComponent.setLocation(locx, locy);
    }

    protected static void locationCenter(Component activeComponent,
            Component currComponent) {
        int centerx = activeComponent.getLocation().x
                + activeComponent.getWidth() / 2;
        int centery = activeComponent.getLocation().y
                + activeComponent.getHeight() / 2;
        int locx = centerx - currComponent.getWidth() / 2;
        int locy = centery - currComponent.getHeight() / 2;
        currComponent.setLocation(locx, locy);
    }

    public static void toggleFrame(boolean reverse) {
        if (children.size() == 0) {
            return;
        }
        Frame active = getActiveComponent();
        if (active == null) {
            return;
        }
        Frame nextFrame = null;
        for (int i = 0; i < children.size(); i++) {
            Frame fr = (Frame) children.get(i);
            if (active == fr) {
                if (!reverse) {
                    if (i == children.size() - 1) {
                        nextFrame = (Frame) children.get(0);
                    } else {
                        nextFrame = (Frame) children.get(i + 1);
                    }
                } else {
                    if (i == 0) {
                        nextFrame = (Frame) children.get(children.size() - 1);
                    } else {
                        nextFrame = (Frame) children.get(i - 1);
                    }
                }
            }
        }
        if (nextFrame instanceof ChaseGUI) {
            return;
        }
        nextFrame.requestFocus();
    }

    public static Frame getActiveComponent() {
        if (children.size() == 0) {
            return null;
        }
        for (int i = 0; i < children.size(); i++) {
            java.awt.Window window = (java.awt.Window) children.get(i);
            if (window != null && window.isActive()) {
                return (Frame) children.get(i);
            }
        }
        return null;
    }

    private void update() {
        logger.debug("invoking update method");
    }

}
