/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : ImageLoader.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.imageviewer;

import java.awt.Container;
import java.io.File;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.common.MyMessageBox;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

//public class ImageLoader extends JInternalFrame {
public class ImageLoader extends InternalFrameChase {

    public static final int MAX_IMAGE_FILES = 1000; /*
                                                     * !< Ɉ摜t@C̏.
                                                     * ȂƎv.
                                                     */

    private Container cont;
    private String dir;
    private Vector imagefiles_wk;
    private String[] imagefiles;
    private String[] imagefiles_selected;
    private JTextArea labeldir;
    private File file;
    private JButton btndir;
    private JButton btnshow;
    private JButton btnclose;
    private JPanel plist;
    private JPanel pbtn;
    private JList list;
    private JScrollPane scrpane;
    private JDesktopPane desktop = Desk.getDesktop();

    private final String DEFAULT_RESOLUTION = "60";

    // private JScrollPane scrpane2;
    // private MyFilter filter;
    private InputPanel ipres;

    private int width = 600;
    private int height = 400;
    private MyMessageBox mbox = new MyMessageBox();

    private int pageNum = 0;
    private int page = 0;

    /**
     * ̃NXpfBNg[, JDesktopPaneIuWFNgւ
     * QƂ擾邽߂chase000IuWFNgɂƂĂ. ̌, GUI̖{̂𐶐.
     * 
     * @param dir
     *            fBNg[
     * @param frame
     *            gbvxGUI
     */
    public ImageLoader(String dir) {
        super("image files", true, true, true);
        this.dir = dir;
        this.requestFocus();
        ipres = new InputPanel("resolution (for ps, eps, and pdf", 0, 17);
        ipres.setValue(DEFAULT_RESOLUTION);
        file = new File(dir);
        createLoader();
    }

    /**
     * GUI̍쐬̂ݍsRXgN^[.
     */
    public ImageLoader() {
        super("image files", true, true, true);
        this.dir = System.getProperty("user.home");
        file = new File(dir);
        createLoader();
    }

    private void createLoader() {
        cont = getContentPane();
        // setImageFiles();
        // cont.add(getPanel());
        cont.add(new ImageLoaderPanel(dir));
        setSize(width, height);
    }

    /**
     * gւ̎QƂԂ.
     * 
     * @return ``return this''ƂĂ̂.
     */
    public ImageLoader getImageLoader() {
        return this;
    }

    /**
     * GUI郁\bh.
     */
    public void display() {
        setVisible(true);
        return;
    }

    /**
     * GUIpׂfBNg[w肷郁\bh.
     */
    public void setDir(String dir) {
        this.dir = dir;
        file = new File(dir);
    }

    /**
     * eXgpC. ImageLoaderJInternalFrameɂĂ܂̂, ̂܂܂ł͂܂\Ȃ.
     */
    public static void main(String args[]) {
        java.util.Locale.setDefault(new java.util.Locale("en", "US"));
        ImageLoader imageloader = new ImageLoader();
        imageloader.setVisible(true);
    }
}
