/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/12/01, 18:48
!  AUTHOR(S): KOGA, Junichiro
!  File : EPSExportFileType.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.graph.export;

import java.awt.Graphics2D;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

import org.apache.log4j.Logger;
import org.freehep.util.export.ExportFileType;

import ciss.phase_viewer.common.Drawable;

/**
 * EPSGNX|[g... epsgraphicsCu[𗘗p; GPLȂ̂ōŏIIɂ͎gȂ...
 * 
 * @author
 */
public class EPSExportFileType extends ExportFileType {
    private Logger logger = Logger.getLogger(EPSExportFileType.class.getName());
    private Drawable drawable;

    /** Creates a new instance of EPSExportFileType */
    public EPSExportFileType(Drawable drawable) {
        this.drawable = drawable;
    }

    public String[] getMIMETypes() {
        return new String[] { "" };
    }

    public String[] getExtensions() {
        return new String[] { ".eps", ".EPS" };
    }

    public String getDescription() {
        return "encapsulated postscript format ";
    }

    public void exportToFile(java.io.OutputStream outputStream,
            java.awt.Component[] component, java.awt.Component component0,
            java.util.Properties properties, String string)
            throws java.io.IOException {
        if (component == null || component.length == 0) {
            return;
        }
        exportToFile(outputStream, component[0], component0, properties, string);
    }

    public void exportToFile(java.io.OutputStream outputStream,
            java.awt.Component component, java.awt.Component component0,
            java.util.Properties properties, String string)
            throws java.io.IOException {
        if (component == null) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        Graphics2D g2d = createG2D(width, height);
        Writer writer = new OutputStreamWriter(outputStream, "UTF-8");
        writer.write(g2d.toString());
    }

    public void exportToFile(java.io.File file, java.awt.Component[] component,
            java.awt.Component component0, java.util.Properties properties,
            String string) throws java.io.IOException {
        if (component == null || component.length == 0) {
            return;
        }
        exportToFile(file, component[0], component0, properties, string);
    }

    public void exportToFile(java.io.File file, java.awt.Component component,
            java.awt.Component component0, java.util.Properties properties,
            String string) throws java.io.IOException {
        if (component == null) {
            return;
        }
        int width = component.getWidth();
        int height = component.getHeight();
        Writer writer = new OutputStreamWriter(new FileOutputStream(file));
        Graphics2D g2d = createG2D(width, height);
        writer.write(g2d.toString());
    }

    private Graphics2D createG2D(int width, int height) {
        // Graphics2D g2d = new EpsGraphics2D();
        // Rectangle2D.Double rect = new Rectangle2D.Double(0,0,(double) width,
        // (double) height);

        // drawable.draw(g2d,rect);
        // return g2d;
        return null;
    }

}
