/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : MainPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.graph;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.mainpanel.Desk;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * Ot`̂߂̃f[^̎荞݁E\sGUI쐬NX. f[^\latexonly $n\times
 * m$\endlatexonlyƂ`肵Ă, ̌`̃f[^Ȃ炢ł荞ނƂ\(Vf[^荞
 * xɐVȃ^u𐶐dg). ܂, ``#''͂܂镶RgƂ , ``#!''n܂镶͑Ή̎ʎqƂȂ.
 * f[^, [ォ_CNgɃ[h邱Ƃł邵, HDD̃t@CǂݍނƂ\. f[^[hɓK؂Ƀf[^I,
 * vbgI``plot''{^ƂɂGraphPanelNXN邱Ƃ ł.
 * 
 * f[^̊i[@ȉŐ. ܂VectorIuWFNgɃJf[^𑫂ł. ̃J̃f[^SĊi[,
 * x͂̃JVectorւ̎QƂ, sVector֑. ̍sVectorɃJVectorւ̎QƂ ׂđ񂾂,
 * ̍sVectorIuWFNgef[^̏i[f[^VectorɍsVectorւ QƂ𑫂. ̂悤Ƀf[^i[邱Ƃɂ,
 * Cӂ̗񐔁EsEf[^̃f[^\ Ƃ\.
 * 
 * f[^\̎oIC[W, \latexonly }~\ref{datakozo:fig}ɐ}. \begin{figure}[hbtp]
 * \begin{center} \includegraphics*[width=16cm]{../fig/datakozo}
 * \caption{f[^[_[̃f[^\.} \label{datakozo:fig} \end{center} \end{figure}
 * \endlatexonly
 * 
 * @author KOGA Junichiro,
 */

// public class MainPanel extends JInternalFrame {
public class MainPanel extends InternalFrameChase {

    public static final int FILE_MANUAL = 0; /*
                                              * !< t@C𖾎IɎw肷ꍇ͂intlw肷
                                              */

    public static final int FILE_AUTOMATIC = 1; /*
                                                 * !<
                                                 * t@C𖾎IɎw肵Ȃɂintlw肷
                                                 */

    public static final String SHARP = "#"; /* !< nbVL`. */

    public static final String SHARP_BIKKURI = "#!"; /* ! nbVL+!` */

    private final int MANUAL = 0;

    private final int AUTO = 1;

    private Container cont;

    private JDesktopPane desktop = Desk.getDesktop();

    private JTable table_for_data;

    private JPanel pprojdir;

    private JPanel pheader;

    private JPanel pdata;

    private JPanel pbutton;

    private JButton btndel;

    private JButton btnload;

    private JButton btntoggle;

    private JButton btnplot;

    private JButton btnsavedata;

    private JButton btnclose;

    private JComboBox comboplottypes;

    private JTextArea taprojdir;

    private JTextArea taheader;

    private JScrollPane spheader;

    private JScrollPane spdata;

    private int width = 500;

    private int height = 670;

    private int mode = FILE_MANUAL;

    private int dataLabel = 0;

    private DefaultTableModel dtm;

    private JTabbedPane tpdata = new JTabbedPane();

    private String[] plottypes = { "xy", "pie" };

    private Vector vdirectory = new Vector();

    private Vector vfilename = new Vector();

    private Vector vnumRows = new Vector();

    private Vector vnumCols = new Vector();

    private Vector vnumIdent = new Vector();

    private Vector vtabs = new Vector();

    private Vector vtable = new Vector();

    private Vector vtableMod = new Vector();

    private Vector vcolName = new Vector();

    private Vector vheader = new Vector();

    private Vector vdata = new Vector();

    private Vector vtable_for_data = new Vector();

    private String[] strusing = { "ignore", "x", "y" };

    private String[] filename;

    private GraphPanel graphpanel;

    private String projdir;

    private boolean selectionMode = false;

    // private Vector vcolNameColumn = new Vector();

    // private Vector vdataRow = new Vector();

    /**
     * ̃NX̑匳GUI쐬. ȃIvV, ݗpӂĂȂ.
     */
    public MainPanel() {
        super("graph tool", true, true, true, true);
        createMainPanel();
    }

    /**
     * GUI. JInternalFrame͋Nvisibleł͂ȂƂɒ.
     */
    public void display() {
        setVisible(true);
    }

    private void createMainPanel() {
        setSize(width, height);
        setVisible(false);
        cont = getContentPane();
        cont.setLayout(new BoxLayout(cont, BoxLayout.Y_AXIS));
        cont.add(createProjDirTextArea());
        cont.add(createHeaderPanel());
        cont.add(createDataPanel());
        cont.add(createButtonPanel());
    }

    private JPanel createProjDirTextArea() {
        JPanel p = new JPanel();
        taprojdir = new JTextArea();
        taprojdir.setPreferredSize(new Dimension((int) (width * 0.9), 20));
        p.add(taprojdir);
        p.setBorder(new TitledBorder("directory"));
        return p;
    }

    private JScrollPane createHeaderPanel() {
        JPanel p = new JPanel();
        taheader = new JTextArea();
        taheader.setEditable(false);
        spheader = new JScrollPane(taheader);
        spheader.setPreferredSize(new Dimension((int) (width * 0.9), 80));
        spheader.setBorder(new TitledBorder("header"));
        return spheader;
    }

    private JScrollPane createDataPanel() {
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension((int) (width * 0.9), 350));
        p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));

        if (dataLabel == 0) {
            tpdata.setVisible(false);
        } else {
            tpdata.setVisible(true);
        }

        tpdata.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                setHeaderInfo();
            }
        });

        p.add(tpdata);
        spdata = new JScrollPane(p);
        spdata.setBorder(new TitledBorder("data"));
        return spdata;
    }

    private JPanel createButtonPanel() {
        JPanel p = new JPanel();
        // p.setLayout( new BoxLayout(p,BoxLayout.X_AXIS) );
        p.setLayout(new FlowLayout());
        p.setPreferredSize(new Dimension((int) (width * 0.9), 50));

        btnplot = new JButton("plot");
        comboplottypes = new JComboBox(plottypes);
        btnload = new JButton("load data");
        btntoggle = new JButton("toggle selection mode");
        btndel = new JButton("delete data");
        btnsavedata = new JButton("save data");
        btnclose = new JButton("close");

        JPanel pbtn = new JPanel();
        pbtn.setLayout(new BoxLayout(pbtn, BoxLayout.Y_AXIS));

        JPanel pplot = new JPanel();
        pplot.setLayout(new BoxLayout(pplot, BoxLayout.X_AXIS));
        pplot.add(btntoggle);
        pplot.add(btnplot);
        pplot.add(comboplottypes);
        pbtn.add(pplot);

        JPanel pfile = new JPanel();
        pfile.setLayout(new BoxLayout(pfile, BoxLayout.X_AXIS));
        pfile.add(btnload);
        pfile.add(btndel);
        pfile.add(btnsavedata);
        pfile.add(btnclose);
        pbtn.add(pfile);

        p.add(pbtn);

        btnplot.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (plotData() == -1) {
                    System.out.println("plot failed.");
                }
            }
        });

        btntoggle.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                JTable jtable = (JTable) vtable.get(tpdata.getSelectedIndex());
                selectionMode = !(jtable.getRowSelectionAllowed());
                jtable.setRowSelectionAllowed(selectionMode);
            }
        });

        btnload.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                loadData(MANUAL);
            }
        });

        btndel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                deleteData();
            }
        });

        btnsavedata.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                saveData();
            }
        });

        btnclose.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        return p;
    }

    /**
     * f[^[ǂނt@Cǂނw肷intl, modeݒ肷.
     * 
     * @param mode
     *            this.FILE_AUTOMATIC: [ǂ. this.FILE_MANUAL:
     *            fBXÑt@Cǂ.
     * 
     *            f[^[ǂޏꍇ, f[^̃Zbg񐔁Es̎wȂǂ IȃR[fBOKvƂȂ.
     *            ႦsetvData(Vector vdata)\bhȂǂ
     *            ĂŖIɃf[^i[java.util.VectorIuWFNgւ̎QƂZbg Kv.
     *            t@Cǂݍޏꍇ͂̃NXIɍs.
     */
    public void setMode(int mode) {
        this.mode = mode;
    }

    /**
     * SẴf[^̃t@Ci[Vectorݒ肷.
     * 
     * @param vfilename
     *            t@Ci[Vector.
     */
    public void setvFileName(Vector vfilename) {
        this.vfilename = vfilename;
    }

    /**
     * SẴf[^̃fBNg[i[Vectorݒ肷.
     * 
     * @param vdirectory
     *            fBNg[i[Vector.
     */
    public void setvDirectory(Vector vdirectory) {
        this.vdirectory = vdirectory;
    }

    /**
     * SẴf[^̍si[VectorZbg.
     * 
     * @param vnumRows
     *            f[^̍si[Vector.
     */
    public void setvNumRows(Vector vnumRows) {
        this.vnumRows = vnumRows;
    }

    /**
     * SẴf[^̗񐔂i[VectorZbg.
     * 
     * @param vnumCols
     *            f[^̗񐔂i[Vector.
     */
    public void setvNumCols(Vector vnumCols) {
        this.vnumCols = vnumCols;
    }

    /**
     * SẴf[^̎ʎqi[VectorZbg.
     * 
     * @param vnumIdent
     *            f[^̎ʎqi[Vector.
     */
    public void setvNumIdent(Vector vnumIdent) {
        this.vnumIdent = vnumIdent;
    }

    /**
     * SẴf[^̗񖼂i[VectorZbg.
     * 
     * @param vcolName
     *            f[^̗񖼂i[Vector.
     */
    public void setvColName(Vector vcolName) {
        this.vcolName = vcolName;
    }

    /**
     * SẴf[^̖{̂i[VectorZbg.
     * 
     * @param vdata
     *            f[^̖{̂i[Vector.
     */
    public void setvData(Vector vdata) {
        this.vdata = vdata;
    }

    /**
     * SẴf[^̃wb_[i[VectorZbg.
     * 
     * @param vheader
     *            f[^̃wb_[i[Vector.
     */
    public void setvHeader(Vector vheader) {
        this.vheader = vheader;
    }

    /**
     * f[^[ォǂݍނ߂̃\bh. ̍, eVector͓K؂ɃZbgĂKv.
     */
    public void loadData_AUTO() {
        if (mode == FILE_MANUAL) {
            System.out.println("error: mode must be FILE_AUTOMATIC");
        }
        try {
            int numFiles = vfilename.size();
            for (int i = 0; i < numFiles; i++) {
                loadData(AUTO);
            }
        } catch (Exception e) {
            System.out.println("invalid filename(s)");
            System.out.println(e);
        }
    }

    private void setHeaderInfo() {
        if (tpdata.getSelectedIndex() >= 0) {
            taheader.setText((String) vheader.get(tpdata.getSelectedIndex()));
            taprojdir
                    .setText((String) vdirectory.get(tpdata.getSelectedIndex()));
        } else {
            taheader.setText(null);
            taprojdir.setText(null);
        }
    }

    private void loadData(int readmode) {
        if (readmode == MANUAL) {
            ChaseFileChooser fdlg = new ChaseFileChooser(ChaseFileChooser.graph);
            fdlg.setDialogType(JFileChooser.CUSTOM_DIALOG);
            fdlg.setDialogTitle("Open");
            fdlg.setFileSelectionMode(JFileChooser.FILES_ONLY);

            if (fdlg.showDialog(cont, "open") != JFileChooser.APPROVE_OPTION) {
                return;
            }

            String datafile = fdlg.getSelectedFile().getAbsolutePath();
            File file = new File(datafile);
            vdirectory.addElement(file.getParent());
            vfilename.addElement(file.getName());
            readData(file);
            loadDataBase();
        } else if (readmode == AUTO) {
            loadDataBase();
        }
    }

    private void loadDataBase() {

        String[] colName;
        String[][] data;

        int numRows;
        int numCols;
        int numIdent;
        int i, j;

        dataLabel++;

        /* add new tab */

        numCols = ((Integer) vnumCols.get(dataLabel - 1)).intValue();
        numRows = ((Integer) vnumRows.get(dataLabel - 1)).intValue();
        numIdent = ((Integer) vnumIdent.get(dataLabel - 1)).intValue();

        Vector veccol = (Vector) vcolName.get(dataLabel - 1);
        colName = new String[numCols];

        for (i = 0; i < numCols; i++) {
            if (i < numIdent) {
                colName[i] = (String) veccol.get(i);
            } else {
                colName[i] = "";
            }
        }

        Vector vectab = (Vector) vdata.get(dataLabel - 1);
        data = new String[numRows][numCols];

        for (i = 0; i < numRows; i++) {
            Vector vcol = (Vector) vectab.get(i);
            for (j = 0; j < numCols; j++) {
                data[i][j] = (String) ((vcol.get(j)));
            }
        }

        vtable.addElement(createDataTable(data, colName));
        JScrollPane jscrp = new JScrollPane((JTable) vtable.get(dataLabel - 1));
        tpdata.add((String) vfilename.get(dataLabel - 1), jscrp);
        tpdata.setSelectedIndex(dataLabel - 1);

        if (dataLabel == 0) {
            tpdata.setVisible(false);
        } else {
            tpdata.setVisible(true);
        }

    }

    private void readData(File file) {

        int i = 0;
        int numident = 0;
        int numrow = 0;
        int numcol = 0;
        int numhead = 0;

        String data;
        String str;
        String strheader = new String();

        Vector vcolNameColumn = new Vector();
        Vector vdataTable = new Vector();
        Vector vdataColumn = new Vector();

        try {

            FileReader freader = new FileReader(file);
            BufferedReader breader = new BufferedReader(freader);
            vdataTable.clear();

            while ((str = breader.readLine()) != null) {
                if (str.trim().startsWith(SHARP_BIKKURI)) {
                    StringTokenizer st = new StringTokenizer(str);
                    st.nextToken();
                    vcolNameColumn.clear();
                    numident = 0;
                    while (true) {
                        try {
                            data = st.nextToken();
                            numident++;
                            vcolNameColumn.addElement(data);
                        } catch (Exception e) {
                            break;
                        }
                    }
                } else if (!(str.trim().startsWith(SHARP))
                        && !(str.trim().length() == 0)) {
                    StringTokenizer st = new StringTokenizer(str);
                    numrow++;
                    numcol = 0;
                    while (true) {
                        try {
                            data = st.nextToken();
                            /* System.out.println(data); */
                            numcol++;
                            vdataColumn.addElement(data);
                        } catch (Exception e) {
                            break;
                        }
                    }
                    vdataTable.addElement(vdataColumn.clone());
                    vdataColumn.clear();
                } else {
                    char[] dst = new char[str.length()];
                    str.getChars(1, str.length(), dst, 0);

                    strheader = strheader + String.copyValueOf(dst).trim()
                            + System.getProperty("line.separator");
                    numhead++;
                }
            }
            freader.close();
            breader.close();
        } catch (Exception e) {
            System.out.println("failed read from " + file);
            System.out.println("error " + e);
        }

        vcolName.addElement(vcolNameColumn.clone());
        vdata.addElement(vdataTable.clone());
        vnumCols.addElement(new Integer(numcol));
        vnumRows.addElement(new Integer(numrow));
        vnumIdent.addElement(new Integer(numident));
        vheader.addElement(strheader);

    }

    private JTable createDataTable(int numRows, int numCols) {
        DefaultTableModel tableModel = new DefaultTableModel(numRows, numCols);
        JTable table = createTable(tableModel);
        return table;
    }

    private JTable createDataTable(String[] colName, int numRows) {
        DefaultTableModel tableModel = new DefaultTableModel(colName, numRows);
        JTable table = createTable(tableModel);
        return table;
    }

    private JTable createDataTable(String[][] data, String[] colName) {
        DefaultTableModel tableModel = new DefaultTableModel(data, colName);
        JTable table = createTable(tableModel);
        return table;
    }

    private JTable createTable(DefaultTableModel tableModel) {
        table_for_data = new JTable(tableModel);
        table_for_data.setColumnSelectionAllowed(true);
        table_for_data.setRowSelectionAllowed(selectionMode);
        table_for_data.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        return table_for_data;
    }

    private void deleteData() {
        if (dataLabel > 0) {
            int deleteLabel = tpdata.getSelectedIndex();

            /* remove reference to data */
            vdirectory.remove(deleteLabel);
            vfilename.remove(deleteLabel);
            vcolName.remove(deleteLabel);
            vdata.remove(deleteLabel);
            vnumCols.remove(deleteLabel);
            vnumRows.remove(deleteLabel);
            vnumIdent.remove(deleteLabel);
            vheader.remove(deleteLabel);
            vtable.remove(deleteLabel);

            /* decrement number of data */
            dataLabel--;

            /* remove the "tab" */
            tpdata.remove(deleteLabel);
            setHeaderInfo();
        } else {
            System.out.println("no data to remove");
        }
    }

    private void saveData() {
        int i;
        int j;

        JFileChooser fdlg = new ChaseFileChooser(ChaseFileChooser.graph);
        fdlg.setDialogType(JFileChooser.CUSTOM_DIALOG);
        fdlg.setDialogTitle("save");
        fdlg.setFileSelectionMode(JFileChooser.FILES_ONLY);

        if (fdlg.showDialog(cont, "open") != JFileChooser.APPROVE_OPTION) {
            return;
        }

        String datafile = fdlg.getSelectedFile().getAbsolutePath();
        File file = new File(datafile);

        try {
            PrintWriter fout = new PrintWriter(new BufferedWriter(
                    new FileWriter(file)));
            /* selected tab */
            int tabnum = tpdata.getSelectedIndex();
            char cr = System.getProperty("line.separator").charAt(0);

            /* write header */
            String str = (String) vheader.get(tabnum);
            if (str.trim().length() != 0) {
                char[] chara = str.trim().toCharArray();
                fout.print(SHARP);
                for (i = 0; i < chara.length; i++) {
                    if (chara[i] == cr) {
                        fout.print(chara[i]);
                        fout.print(SHARP);
                    } else {
                        fout.print(chara[i]);
                    }
                }
            }

            /* write identifier */
            Vector vcolNameColumn = (Vector) vcolName.get(tabnum);

            fout.print(cr);
            fout.print(SHARP_BIKKURI + "  ");
            for (j = 0; j < vcolNameColumn.size(); j++) {
                fout.print(vcolNameColumn.get(j) + "  ");
            }
            fout.print(cr);

            /* write data */
            int numCols = ((Integer) vnumCols.get(tabnum)).intValue();
            int numRows = ((Integer) vnumRows.get(tabnum)).intValue();
            Vector vdataTable = (Vector) vdata.get(tabnum);
            for (i = 0; i < numRows; i++) {
                Vector vcol = (Vector) vdataTable.get(i);
                for (j = 0; j < numCols; j++) {
                    fout.print(vcol.get(j) + "  ");
                }
                fout.print(cr);
            }

            fout.close();
        } catch (Exception exception) {
            System.out.println("failed write to " + file);
        }
    }

    private int plotData() {

        int i;
        int j;
        int k;

        int tabnum = tpdata.getSelectedIndex();
        int type = comboplottypes.getSelectedIndex();

        if (!(tabnum >= 0)) {
            return -1;
        }
        JTable table = (JTable) vtable.get(tabnum);

        int numCols = ((Integer) vnumCols.get(tabnum)).intValue();
        int numRows = ((Integer) vnumRows.get(tabnum)).intValue();
        int numIdent = ((Integer) vnumIdent.get(tabnum)).intValue();

        int[] index_selected = table.getSelectedColumns();
        int numSelected = index_selected.length;

        int[] index_selected_rows;
        int numSelected_rows;

        if (table.getRowSelectionAllowed()) {
            index_selected_rows = table.getSelectedRows();
            numSelected_rows = index_selected_rows.length;
        } else {
            index_selected_rows = new int[numRows];
            for (i = 0; i < numRows; i++) {
                index_selected_rows[i] = i;
            }
            numSelected_rows = numRows;
        }

        if (numSelected <= 1) {
            System.out.println("select at least two columns!");
            return -1;
        }

        if (numSelected_rows <= 0) {
            System.out.println("select at least one row!");
            return -1;
        }

        String[][] data_out = new String[numSelected][numSelected_rows];
        for (i = 0; i < numSelected; i++) {
            for (j = 0; j < numSelected_rows; j++) {
                data_out[i][j] = (String) table.getModel().getValueAt(
                        index_selected_rows[j], index_selected[i]);
            }
        }

        String xlabel = new String();
        String ylabel = new String();
        Vector veccol = (Vector) vcolName.get(tabnum);

        String[] legendtext = new String[0];

        if (type == 0) {
            legendtext = new String[numSelected];
            for (i = 0; i < numSelected; i++) {
                try {
                    legendtext[i] = (String) veccol.get(index_selected[i]);
                } catch (Exception e) {
                    if (i == 0) {
                        legendtext[i] = "x";
                    } else {
                        legendtext[i] = "y" + Integer.toString(i);
                    }
                }
            }

            for (i = 0; i < numSelected; i++) {
                try {
                    if (i == 0) {
                        xlabel = (String) veccol.get(index_selected[i]);
                    } else {
                        ylabel = ylabel + " "
                                + (String) veccol.get(index_selected[i]);
                    }
                } catch (Exception e) {
                    xlabel = "x";
                    ylabel = "y";
                }
            }
        } else if (type == 1) {
            legendtext = new String[numSelected_rows];
            for (i = 0; i < numSelected_rows; i++) {
                legendtext[i] = (String) data_out[0][i];
            }
        }

        String strfilename = (String) vfilename.get(tabnum);
        // graphpanel = new GraphPanel(strfilename);
        // graphpanel.setProjDir(projdir);
        //
        // /* set data & legend; legend must be set first */
        // graphpanel.setType(type);
        // graphpanel.setLegendText(legendtext);
        // graphpanel.setData(data_out);
        //
        // /* set methods for preferances */
        // graphpanel.setPlotTitle(strfilename);
        // graphpanel.setXlabel(xlabel);
        // graphpanel.setYlabel(ylabel);
        //
        // /* display graphpanel */
        // graphpanel.createGraphPanel();
        // graphpanel.display();
        //
        return 0;
    }

    /**
     * vWFNgfBNg[Zbg.
     * 
     * @param projdir
     *            vWFNgfBNg[ւ̃pX.
     */
    public void setProjDir(String projdir) {
        this.projdir = projdir;
    }

    /**
     * ̃NXێGraphPanelIuWFNgԂ. ̃\bhĂԑO, 炩߃vbg݂邱Ƃ肵Ă.
     * 
     * @return GraphPanelIuWFNg.
     */
    public GraphPanel getGraphPanel() {
        return this.graphpanel;
    }

}
