/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : ChooserButton.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.text.JTextComponent;

public class ChooserButton extends JButton {

    public static final int DIRECTORY = 0;
    public static final int FILES = 1;

    private int mode = FILES;
    private String dir;
    private JTextComponent tc;

    public ChooserButton() {
        super("choose");
        this.init();
    }

    public ChooserButton(int mode, JTextComponent tc) {
        super("choose");
        this.mode = mode;
        this.tc = tc;
        this.init();
    }

    public ChooserButton(String text, int mode, JTextComponent tc) {
        super(text);
        this.mode = mode;
        this.tc = tc;
        this.init();
    }

    private void init() {
        this.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                bootFileChooser();
            }
        });
    }

    private void bootFileChooser() {
        ChaseFileChooser fdlg = new ChaseFileChooser();
        fdlg.setDialogType(JFileChooser.CUSTOM_DIALOG);
        fdlg.setDialogTitle("choose");
        fdlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
        if (mode == FILES) {
            fdlg.setFileSelectionMode(JFileChooser.FILES_ONLY);
        } else if (mode == DIRECTORY) {
            fdlg.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        } else {
            System.out.println("wrong specification of mode");
            return;
        }
        if (fdlg.showDialog(tc, "Select") != JFileChooser.APPROVE_OPTION) {
            return;
        }
        dir = fdlg.getSelectedFile().getAbsolutePath();
        tc.setText(dir);
    }

}
