/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/30, 11:28
!  AUTHOR(S): KOGA, Junichiro
!  File : ACIOUtils.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.atomcoord.io;

import java.util.Vector;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

import ciss.phase_viewer.atomcoord.AtomCoords;

/**
 * ֗static\bh`
 * 
 * @author
 */
public class ACIOUtils {
    private Logger logger = Logger.getLogger(ACIOUtils.class.getName());

    /* X^eBbN\bĥ */
    private ACIOUtils() {
    }

    /**
     * t@CAtomCoordsIuWFNgCX^Xł邩ǂ߂, \Ȃ Ԃ. ߂Ȃ΂nullԂ.
     * t@Ĉ݂画肷̂Ŏs[l.
     * 
     * @param fileName
     *            gCt@C̃t@C
     * @return \ȏꍇAtomCoords̃CX^X
     */
    public static AtomCoords[] tryToGetInstance(String fileName) {
        Document doc = ciss.phase_viewer.jdom.XMLUtils
                .getDocumentFromURL(AtomCoordsIO.SUPPORTED_FILETYPE);
        Element root = doc.getRootElement();
        java.util.List list = root.getChildren("importer");
        Vector vec = new Vector();
        for (int i = 0; i < list.size(); i++) {
            String loadClass = ((Element) list.get(i))
                    .getChildTextTrim("loadclass");
            Importer importer = (Importer) ciss.phase_viewer.main.PluginLoader
                    .instantiate(loadClass, null);
            if (importer.isImportable(fileName)) {
                AtomCoords[] co = importer.getAtomCoordsFrom(fileName);
                if (co != null)
                    return co;
            }
        }
        return null;
    }
}
