/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/07/14, 16:44
!  AUTHOR(S): KOGA, Junichiro
!  File : WignerSeitzAttributes.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.fbz;

import javax.vecmath.Color3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * WSCell̊eێNX.
 * 
 * @author
 */
public class WignerSeitzAttributes {
    private Logger logger = Logger.getLogger(WignerSeitzAttributes.class
            .getName());

    /**
     * ӂ`悷邩ۂ; ftHgtrue
     */
    public boolean drawEdge = true;

    /**
     * ӂ̕`F; ftHg͍
     */
    public Color3f edgeColor = new Color3f(0f, 0f, 0f);

    /**
     * ӂ̑; ftHg0.005
     */
    public double edgeWidth = 0.005d;

    /**
     * ʂ`悷邩ۂ; ftHgtrue
     */
    public boolean drawPlane = true;

    /**
     * ʂ̕`F; ftHg̓sNۂF
     */
    public Color3f planeColor = new Color3f(0.9f, 0.6f, 0.6f);

    /**
     * ʂ̓x; ftHg0.5
     */
    public float planeTransparency = 0.5f;

    /**
     * `悷邩ۂ; ftHgfalse
     */
    public boolean drawAxis = false;

    /**
     * ̑; ftHg0.002
     */
    public double axisWidth = 0.002;

    /**
     * ̐F; ftHg͍
     */
    public Color3f axisColor = new Color3f(0, 0, 0);

    /**
     * Ώ̓_""ŕ`悷邩ۂ
     */
    public boolean drawSymmetryPoints = true;

    /**
     * ʂ̒SΏ̓_ƌ􂷂ۂ
     */
    public boolean centerOfPlaneIsSymmetric = true;

    /**
     * ӂ̒SΏ̓_ƌ􂷂ۂ
     */
    public boolean centerOfEdgeIsSymmetric = true;

    /**
     * _Ώ̓_ƌ􂷂ۂ
     */
    public boolean vertexIsSymmetric = true;

    /**
     * _Ώ̓_ƌ􂷂ۂ
     */
    public boolean gammaIsSymmetric = true;

    /**
     * Ώ̓_̐F
     */
    public Color3f symmetricPointColor = new Color3f(1f, 0.8f, 0.4f);

    /**
     * "Iꂽ"Ώ̓_̐F
     */
    public Color3f selectedSymmetricPointColor = new Color3f(0f, 0.2f, 0.6f);

    /**
     * Ώ̓_̔a
     */
    public float symmetricPointRadius = 0.02f;

    /**
     * Ώ̐̑
     */
    public float symmetricLineWidth = 4f;

    /**
     * Ώ̐̐F
     */
    public Color3f symmetricLineColor = new Color3f(0f, 0f, 0f);

    /**
     * `悵WSCellԂ̂ꂩtԂ̂ꂩw. ͊Ot@CɋL^킯ł͂Ȃ.
     */
    public boolean isReciprocalSpace = true;

    private GlobalProperties gp;

    /** Creates a new instance of WignerSeitzAttributes */
    public WignerSeitzAttributes() {
        gp = PropertiesManager
                .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);
        loadFromProps();
    }

    public static String DRAW_EDGE = "wscell_draw_edge";
    public static String DRAW_AXIS = "wscell_draw_axis";
    public static String DRAW_PLANE = "wscell_draw_plane";
    public static String EDGE_WIDTH = "wscell_edge_width";
    public static String PLANE_TRANSPARENCY = "wscell_plane_transparency";
    public static String AXIS_WIDTH = "wscell_axis_width";
    public static String PLANE_COLOR = "wscell_plane_color";
    public static String EDGE_COLOR = "wscell_edge_color";
    public static String AXIS_COLOR = "wscell_axis_color";

    public static String DRAW_SYMMETRIC_POINTS = "wscell_draw_symmetric_points";
    public static String PLANE_CENTER_IS_SYMMETRIC = "wscell_plane_center_is_symmetric";
    public static String EDGE_CENTER_IS_SYMMETRIC = "wscell_edge_center_is_symmetric";
    public static String VERTEX_IS_SYMMETRIC = "wscell_vertex_is_symmetric";
    public static String GAMMA_IS_SYMMETRIC = "wscell_gamma_is_symmetric";

    public static String SYMMETRIC_POINT_COLOR = "wscell_symmetric_point_color";
    public static String SELECTED_SYMMETRIC_POINT_COLOR = "wscell_selected_symmetric_point_color";
    public static String SYMMETRIC_POINT_RADIUS = "wscell_symmetric_point_radius";
    public static String SYMMETRIC_LINE_WIDTH = "wscell_symmetric_line_width";
    public static String SYMMETRIC_LINE_COLOR = "wscell_symmetric_line_color";

    public void loadFromProps() {
        try {
            drawEdge = new Boolean(gp.getProperty(DRAW_EDGE)).booleanValue();
            drawAxis = new Boolean(gp.getProperty(DRAW_AXIS)).booleanValue();
            drawPlane = new Boolean(gp.getProperty(DRAW_PLANE)).booleanValue();

            edgeWidth = Double.parseDouble(gp.getProperty(EDGE_WIDTH));
            planeTransparency = Float.parseFloat(gp
                    .getProperty(PLANE_TRANSPARENCY));
            axisWidth = Double.parseDouble(gp.getProperty(AXIS_WIDTH));

            String[] pcolor = gp.getProperty(PLANE_COLOR).split(",");
            planeColor = new Color3f(Float.parseFloat(pcolor[0]),
                    Float.parseFloat(pcolor[1]), Float.parseFloat(pcolor[2]));

            String[] ecolor = gp.getProperty(EDGE_COLOR).split(",");
            edgeColor = new Color3f(Float.parseFloat(ecolor[0]),
                    Float.parseFloat(ecolor[1]), Float.parseFloat(ecolor[2]));

            String[] acolor = gp.getProperty(AXIS_COLOR).split(",");
            axisColor = new Color3f(Float.parseFloat(acolor[0]),
                    Float.parseFloat(acolor[1]), Float.parseFloat(acolor[2]));

            drawSymmetryPoints = new Boolean(
                    gp.getProperty(DRAW_SYMMETRIC_POINTS)).booleanValue();
            centerOfPlaneIsSymmetric = new Boolean(
                    gp.getProperty(PLANE_CENTER_IS_SYMMETRIC)).booleanValue();
            centerOfEdgeIsSymmetric = new Boolean(
                    gp.getProperty(EDGE_CENTER_IS_SYMMETRIC)).booleanValue();
            vertexIsSymmetric = new Boolean(gp.getProperty(VERTEX_IS_SYMMETRIC))
                    .booleanValue();
            gammaIsSymmetric = new Boolean(gp.getProperty(GAMMA_IS_SYMMETRIC))
                    .booleanValue();

            String[] pointColor = gp.getProperty(SYMMETRIC_POINT_COLOR).split(
                    ",");
            symmetricPointColor = new Color3f(Float.parseFloat(pointColor[0]),
                    Float.parseFloat(pointColor[1]),
                    Float.parseFloat(pointColor[2]));
            String[] selePointColor = gp.getProperty(
                    SELECTED_SYMMETRIC_POINT_COLOR).split(",");
            selectedSymmetricPointColor = new Color3f(
                    Float.parseFloat(selePointColor[0]),
                    Float.parseFloat(selePointColor[1]),
                    Float.parseFloat(selePointColor[2]));
            String[] lineColor = gp.getProperty(SYMMETRIC_LINE_COLOR)
                    .split(",");
            symmetricLineColor = new Color3f(Float.parseFloat(lineColor[0]),
                    Float.parseFloat(lineColor[1]),
                    Float.parseFloat(lineColor[2]));

            symmetricPointRadius = Float.parseFloat(gp
                    .getProperty(SYMMETRIC_POINT_RADIUS));
            symmetricLineWidth = Float.parseFloat(gp
                    .getProperty(SYMMETRIC_LINE_WIDTH));

        } catch (Exception exc) {
        }
    }
}
