/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/10/31, 19:18
!  AUTHOR(S): KOGA, Junichiro
!  File : ACVButtons.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

/**
 * qzur[A[, {^zNX.
 * 
 * @author
 */
public class ACVButtons extends JPanel {
    private Logger logger = Logger.getLogger(ACVButtons.class.getName());
    private J3DPanel parent;
    private J3DDataManager mACVD;
    private ConfigDataManager mCD;

    /** Creates a new instance of Buttons */
    public ACVButtons(J3DPanel parent) {
        this.parent = parent;
        mACVD = parent.getJ3DDataManager();
        if (parent instanceof MainPanel) {
            mCD = ((CoordsViewerInterface) parent).getCD();
        }

        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        createButtons();
        revalidate();
    }

    private void createButtons() {
        JButton[] btns = parent.getPluginParser().getButtons();
        for (int i = 0; i < btns.length; i++) {
            add(btns[i]);
        }
        add(Box.createHorizontalGlue());
    }

}
