/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : HostInfo.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.ssh.hosts;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.TaggedString;

public class HostInfo extends java.util.Properties implements Serializable {

    private static Logger logger = Logger.getLogger(HostInfo.class.getName());
    private String name = "";
    private String address = "";
    private String bindir = "";
    private String mpidir = "";
    private String basedir = "";
    private String username = "";
    private String initpass = "";
    private byte[] password = initpass.getBytes();
    private boolean savepass = false;
    private String passString = "";

    private boolean xforwarding = false;
    private boolean antialias = false;

    public HostInfo() {
        super();
    }

    private String hostsFile = System.getProperty("user.home")
            + System.getProperty("file.separator") + ".phase-viewer"
            + System.getProperty("file.separator") + "hosts";

    public String getPropertiesInISO_8859_1(String key) {
        String result = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(hostsFile);
            result = bundle.getString(key);
            result = new String(result.getBytes("ISO-8859-1"), "JISAutoDetect");
        } catch (Exception exc) {
            // exc.printStackTrace();
            result = "";
        }
        return result;
    }

    public HostInfo(String name) {
        super();
        this.name = name;
    }

    public Object setProperty(String key, boolean value) {
        return super.setProperty(key, Boolean.toString(value));
    }

    public TaggedString[] getHostProperties() {
        Vector tmp = new Vector();
        Enumeration enumeration = propertyNames();
        while (enumeration.hasMoreElements()) {
            String tag = (String) enumeration.nextElement();
            tmp.addElement(new TaggedString(tag, getProperty(tag)));
        }
        TaggedString[] ret = new TaggedString[tmp.size()];
        for (int i = 0; i < tmp.size(); i++) {
            ret[i] = (TaggedString) tmp.elementAt(i);
        }
        return ret;
    }

    public void setProperties(TaggedString[] elms) {
        if (elms != null) {
            for (int i = 0; i < elms.length; i++) {
                String key = elms[i].getTag();
                String val = elms[i].getValue();
                setProperty(key, val);
            }
        }
    }

    public boolean getBooleanProperty(String key) {
        String ret = super.getProperty(key);
        boolean bret;
        if (ret != null) {
            bret = ret.equalsIgnoreCase("true") || ret.equals("1")
                    || ret.equalsIgnoreCase("on");
        } else {
            bret = false;
        }
        return bret;
    }

    public Object clone() {
        TaggedString[] elms = getHostProperties();
        String pass = getPasswordString();
        HostInfo inf = new HostInfo(name);
        inf.setProperties(elms);
        inf.setPasswordString(pass);
        return inf;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getPassword() {
        return password;
    }

    public String getPasswordString() {
        return passString;
    }

    public void setPassword(byte[] password) {
        this.password = password;
    }

    public void setPasswordString(String passString) {
        this.passString = passString;
    }

    public void setSavePassword(boolean savepass) {
        this.savepass = savepass;
    }

    public boolean savePassword() {
        return savepass;
    }

    /**
     * ́uzXgv̓[JzXĝ̂ۂ𔻒.
     * 
     * @return ̃zXg񂪃[JzXĝ̂Ȃtrue.
     */
    public boolean isLocalHost() {
        return getName().equals("localhost");
    }

    public void debug() {
        TaggedString[] tmp = getHostProperties();
        logger.debug("name: " + getName());
        for (int i = 0; i < tmp.length; i++) {
            logger.debug("tag: " + tmp[i].getTag() + " value: "
                    + tmp[i].getValue());
        }
    }

}
