/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/01/11, 16:10
!  AUTHOR(S): KOGA, Junichiro
!  File : ShExecScript.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.scripting.scriptexecscripts;

import org.apache.log4j.Logger;

import ciss.phase_viewer.scripting.scriptreplace.ScriptKeywordsReplacer;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.hosts.HostInfo;

/**
 * sht@CsshXNvg쐬.
 * 
 * @author
 */
public class ShExecScript implements ScriptExecScript {
    private Logger logger = Logger.getLogger(ShExecScript.class.getName());
    private GlobalProperties props = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_PVIEWER);

    /** Creates a new instance of ShExecScript */
    public ShExecScript() {
    }

    public String createScriptExecScript(String[] execScripts, HostInfo hostInfo) {
        if (execScripts == null || execScripts.length == 0) {
            return "";
        }

        String[] tmpscripts = new String[execScripts.length];
        for (int i = 0; i < tmpscripts.length; i++) {
            tmpscripts[i] = ScriptKeywordsReplacer.REPLACED_FILE_PREFIX
                    + execScripts[i];
        }

        String ret = "#!/bin/sh\n";
        ret += "# script execution script for the bourne shell script, created by PHASE-Viewer\n";
        ret += "cd __TARGETDIR__\n";
        for (int i = 0; i < tmpscripts.length; i++) {
            ret += "chmod 755 ./" + tmpscripts[i] + "\n";
            ret += ". ./" + tmpscripts[i] + "\n";
        }

        String remove = props.getProperty("scripting_remove_tmpfiles");
        boolean rem = new Boolean(remove).booleanValue();
        if (rem) {
            java.util.Vector unique = ciss.phase_viewer.common.Utils
                    .removeDupli(tmpscripts);
            if (unique != null) {
                for (int i = 0; i < unique.size(); i++) {
                    ret += "rm -f ./" + (String) unique.get(i) + "\n";
                }
            }
        }

        ret += "rm -f ./script_exec.sh\n";
        return ret;
    }

    public String getScriptExecScriptName(HostInfo hostInfo) {
        return "script_exec.sh";
    }

    public String getScriptExecScriptExecString(String scriptExecScript,
            HostInfo hostInfo) {
        return scriptExecScript + " >& errLog > Log &";
    }

}
