/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/12/08, 15:20
!  AUTHOR(S): KOGA, Junichiro
!  File : InterpreterChase.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.scripting;

import java.io.File;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

import bsh.Interpreter;

/**
 * BeanShell InterpreterN.
 * 
 * @author
 */
public class InterpreterChase {
    private static Logger logger = Logger.getLogger(InterpreterChase.class
            .getName());

    /** Creates a new instance of InterpreterChase */
    public InterpreterChase() {
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("Usage: java -jar interpreter.jar bshfile");
            System.exit(0);
        }
        String fileName = args[0];
        if (!new File(fileName).exists()) {
            System.out.println("file " + fileName
                    + " does not exist... exiting.");
            System.exit(0);
        }

        java.net.URL log4j = InterpreterChase.class.getClass().getResource(
                "/ciss/phase_viewer/beanshell/log4j.properties");
        PropertyConfigurator.configure(log4j);

        Interpreter interpreter = new Interpreter();
        try {
            interpreter.source(fileName);
        } catch (Exception exc) {
            exc.printStackTrace();
        }

        System.exit(0);
    }

}
