/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : PropsTokenMarker.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.pub.jeditsyntax;

import javax.swing.text.Segment;

/**
 * Java properties/DOS INI token marker.
 * 
 * @author Slava Pestov
 * @version $Id: PropsTokenMarker.java,v 1.9 1999/12/13 03:40:30 sp Exp $
 */
public class PropsTokenMarker extends TokenMarker {
    public static final byte VALUE = Token.INTERNAL_FIRST;

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        char[] array = line.array;
        int offset = line.offset;
        int lastOffset = offset;
        int length = line.count + offset;
        loop: for (int i = offset; i < length; i++) {
            int i1 = (i + 1);

            switch (token) {
            case Token.NULL:
                switch (array[i]) {
                case '#':
                case ';':
                    if (i == offset) {
                        addToken(line.count, Token.COMMENT1);
                        lastOffset = length;
                        break loop;
                    }
                    break;
                case '[':
                    if (i == offset) {
                        addToken(i - lastOffset, token);
                        token = Token.KEYWORD2;
                        lastOffset = i;
                    }
                    break;
                case '=':
                    addToken(i - lastOffset, Token.KEYWORD1);
                    token = VALUE;
                    lastOffset = i;
                    break;
                }
                break;
            case Token.KEYWORD2:
                if (array[i] == ']') {
                    addToken(i1 - lastOffset, token);
                    token = Token.NULL;
                    lastOffset = i1;
                }
                break;
            case VALUE:
                break;
            default:
                throw new InternalError("Invalid state: " + token);
            }
        }
        if (lastOffset != length)
            addToken(length - lastOffset, Token.NULL);
        return Token.NULL;
    }

    public boolean supportsMultilineTokens() {
        return false;
    }
}
