/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/14, 21:35
!  AUTHOR(S): KOGA, Junichiro
!  File : NewSubProjectCreator.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser.projectstatemanipulator;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.projectbrowser.ProjectBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;

/**
 * 
 * @author KOGA, Junichiro
 */
public class NewSubProjectCreator extends InternalFrameChase implements
        ProjectStateChanger, ProjectStateGUI {
    private Logger logger = Logger.getLogger(NewSubProjectCreator.class
            .getName());
    private Vector listeners = new Vector();
    private ProjectDirBrowserNode parentNode;
    private SubProjectCreatorPanel subprojpanel;
    private ProjectBrowser parent;
    private ProjectDirBrowser dirBrowser;

    /** Creates a new instance of NewSubProjectCreator */
    public NewSubProjectCreator(ProjectDirBrowserNode parentNode,
            ProjectDirBrowser dirBrowser) {
        super("new sub project", true, true, true, true,
                new Dimension(400, 150));
        this.parentNode = parentNode;
        this.parent = parent;
        this.dirBrowser = dirBrowser;
        init();
    }

    public void addProjectStateChangeListener(ProjectStateChangeListener l) {
        subprojpanel.addProjectStateChangeListener(l);
    }

    private void init() {
        Container cont = getContentPane();
        cont.setLayout(new BoxLayout(cont, BoxLayout.Y_AXIS));
        subprojpanel = new SubProjectCreatorPanel(parentNode, dirBrowser, this);
        cont.add(subprojpanel);
        cont.add(buttonsPanel());
    }

    private JButton ok;

    private JPanel buttonsPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, BoxLayout.X_AXIS));
        ok = new JButton("ok");
        JButton cancel = new JButton("cancel");

        ret.add(ok);
        ret.add(cancel);

        ok.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
                manipulateProjectState();
            }
        });

        cancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        return ret;
    }

    public void manipulateProjectState() {
        subprojpanel.manipulateProjectState();
        subprojpanel.notifyListeners();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateGUI
     * #getOKButton()
     */
    public JButton getOKButton() {
        return ok;
    }

}
