/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/03/15, 12:54
!  AUTHOR(S): KOGA, Junichiro
!  File : ProjectDirBrowserMenu.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser.projectdirbrowser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;

import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import org.apache.log4j.Logger;

import ciss.phase_viewer.projectbrowser.ProjectInfo;

/**
 * ProjectDirBrowserp̃j[쐬NX.
 * 
 * @author
 */
public class ProjectDirBrowserMenu {
    private Logger logger = Logger.getLogger(ProjectDirBrowserMenu.class
            .getName());
    private ProjectDirBrowser browser;
    private ProjectDirBrowserNode node;
    private ProjectInfo info;
    private Vector projbuf;

    /** Creates a new instance of ProjectDirBrowserMenu */
    public ProjectDirBrowserMenu(ProjectDirBrowser browser) {
        this.browser = browser;
        this.node = browser.getSelectedNode();
        if (node == null) {
            return;
        }
        this.info = node.getProjectInfo();
        this.projbuf = browser.getProjBuf();
    }

    public JMenuItem[] getMenuItems() {
        if (node == null) {
            return null;
        }
        Vector items = new Vector();
        JMenuItem open = new JMenuItem("open");
        open.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                if (node != null) {
                    node.selectMe();
                    browser.saveMyProjects();
                }
            }
        });
        open.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0));

        JMenuItem rename = new JMenuItem("rename");
        rename.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                browser.bootRenamer(node);
            }
        });
        rename.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));

        JMenuItem cut = new JMenuItem("cut");
        cut.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                browser.doProjectCut(node);
            }
        });
        cut.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X,
                KeyEvent.CTRL_MASK));

        JMenuItem copy = new JMenuItem("copy");
        copy.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                browser.doProjectCopy(node);
            }
        });
        copy.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C,
                KeyEvent.CTRL_MASK));

        JMenuItem paste = new JMenuItem("paste");
        paste.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                browser.doProjectPaste();
            }
        });
        paste.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V,
                KeyEvent.CTRL_MASK));
        paste.setEnabled(projbuf.size() != 0);

        JMenuItem remove = new JMenuItem("remove");
        remove.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                browser.bootProjectRemover();
            }
        });
        remove.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0));

        JMenuItem create = new JMenuItem("create project");
        create.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                browser.bootProjectCreator();
            }
        });
        create.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N,
                KeyEvent.CTRL_MASK));

        JMenuItem sub = new JMenuItem("create sub project");
        sub.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                browser.bootSubProjectCreator();
            }
        });
        sub.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N,
                KeyEvent.CTRL_MASK + KeyEvent.SHIFT_MASK));

        JMenuItem export = new JMenuItem("export project");
        export.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                browser.doProjectExport();
            }
        });

        JMenuItem impor = new JMenuItem("import project");
        impor.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                browser.doProjectImport();
            }
        });

        JMenuItem openexp = null;
        JMenuItem cmd = null;
        if (info.getInfoType() == ProjectInfo.SUB) {
            items.addElement(open);
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            openexp = new JMenuItem("open folder by explorer");
            items.addElement(openexp);
            // items.addElement(null);
        } else if (System.getProperty("os.name").toLowerCase()
                .startsWith("linux")) {
            openexp = new JMenuItem("open directory by konqueror");
            items.addElement(openexp);
            // items.addElement(null);
        }
        if (openexp != null) {
            openexp.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    browser.openDir(info.getProjectDirectory());
                }
            });
            openexp.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O,
                    KeyEvent.CTRL_MASK));
        }

        JMenuItem openprompt = new JMenuItem("open terminal");
        openprompt.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                browser.openDirByPrompt(info.getProjectDirectory());
            }
        });
        openprompt.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T,
                KeyEvent.CTRL_MASK));

        items.addElement(openprompt);
        items.addElement(null);
        if (info.getInfoType() == ProjectInfo.SUB && openexp == null) {
            items.addElement(null);
        }

        if (!info.isEditable()) {
            JMenuItem[] ite = new JMenuItem[items.size()];
            items.copyInto(ite);
            return ite;
        }

        if (info.getProjectType().equals("root")) {
            items.addElement(create);
            items.addElement(null);
            items.addElement(export);
            items.addElement(impor);
        } else if (info.getInfoType() == ProjectInfo.BASE
                && !info.getProjectType().equals("root")) {
            items.addElement(create);
            items.addElement(sub);
            items.addElement(null);
            items.addElement(rename);
            items.addElement(cut);
            items.addElement(copy);
            items.addElement(paste);
            items.addElement(remove);
            items.addElement(null);
            items.addElement(export);
            items.addElement(impor);
        } else if (info.getInfoType() == ProjectInfo.SUB) {
            items.addElement(sub);
            items.addElement(null);
            items.addElement(rename);
            items.addElement(cut);
            items.addElement(copy);
            items.addElement(paste);
            items.addElement(remove);
        }

        if (items.size() != 0) {
            JMenuItem[] jitems = new JMenuItem[items.size()];
            for (int i = 0; i < items.size(); i++) {
                jitems[i] = (JMenuItem) items.elementAt(i);
            }
            return jitems;
        }
        return null;
    }
}
