/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/05/10, 20:05
!  AUTHOR(S): KOGA, Junichiro
!  File : ToolTippedCombo.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.primitiveguis;

import java.awt.Component;
import java.util.Vector;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

import org.apache.log4j.Logger;

/**
 * IƂɃc[`bv̂ĂR{{bNX쐬ł.
 * 
 * @author
 */
public class ToolTippedCombo extends JComboBox {
    private Logger logger = Logger.getLogger(ToolTippedCombo.class.getName());
    private String[] tooltips;

    /** Creates a new instance of ToolTippedCombo */
    public ToolTippedCombo() {
        super();
    }

    public ToolTippedCombo(ComboBoxModel aModel) {
        super(aModel);
    }

    public ToolTippedCombo(Object[] items) {
        super(items);
    }

    public ToolTippedCombo(Vector items) {
        super(items);
    }

    public void setToolTips(String[] tooltips) {
        this.tooltips = tooltips;
        setRenderer(new ToolTipRenderer());
    }

    class ToolTipRenderer extends BasicComboBoxRenderer {
        public Component getListCellRendererComponent(JList list, Object value,
                int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                setBackground(list.getSelectionBackground());
                setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    if (tooltips != null && tooltips.length > index) {
                        list.setToolTipText(tooltips[index]);
                    }
                }
            } else {
                setBackground(list.getBackground());
                setForeground(list.getForeground());
            }
            setFont(list.getFont());
            setText((value == null) ? "" : value.toString());
            return this;
        }
    }
}
