/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : PhaseInputChildrenPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.primitiveguis;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.mainpanel.ChaseFrame;
import ciss.phase_viewer.mainpanel.InternalFrameChase;

public abstract class PhaseInputChildrenPanel extends InternalFrameChase
        implements ActionListener, CaretListener, TableModelListener,
        ButtonFrameInterface {

    protected InputInterface inputInterface;

    protected String NO_SELECTION = ConstParameters.NO_SELECTION;
    protected String ON_OFF[] = { NO_SELECTION, "on", "off" };
    protected Vector ON_OFF_DUPLI = new Vector();

    protected PhaseInputChildrenPanel(InputInterface inputInterface) {
        super("");
        this.inputInterface = inputInterface;
        init();
    }

    protected PhaseInputChildrenPanel(String title,
            InputInterface inputInterface) {
        super(title);
        this.inputInterface = inputInterface;
        init();
    }

    protected PhaseInputChildrenPanel(String title, boolean resizable,
            InputInterface inputInterface) {
        super(title, resizable);
        this.inputInterface = inputInterface;
        init();
    }

    protected PhaseInputChildrenPanel(String title, boolean resizable,
            boolean closable, InputInterface inputInterface) {
        super(title, resizable, closable);
        this.inputInterface = inputInterface;
        init();
    }

    protected PhaseInputChildrenPanel(String title, boolean resizable,
            boolean closable, boolean maximizable, InputInterface inputInterface) {
        super(title, resizable, closable, maximizable);
        this.inputInterface = inputInterface;
        init();
    }

    protected PhaseInputChildrenPanel(String title, boolean resizable,
            boolean closable, boolean maximizable, boolean iconifiable,
            InputInterface inputInterface) {
        super(title, resizable, closable, maximizable, iconifiable,
                ChaseFrame.CENTER);
        this.inputInterface = inputInterface;
        init();
    }

    protected PhaseInputChildrenPanel(String title, boolean resizable,
            boolean closable, boolean maximizable, boolean iconifiable,
            InputInterface inputInterface, Dimension size) {
        super(title, resizable, closable, maximizable, iconifiable, size,
                ChaseFrame.CENTER);
        this.inputInterface = inputInterface;
        init();
    }

    private void init() {
        ON_OFF_DUPLI.addElement(new String[] { "1", "yes" });
        ON_OFF_DUPLI.addElement(new String[] { "1", "1" });
        ON_OFF_DUPLI.addElement(new String[] { "2", "no" });
        ON_OFF_DUPLI.addElement(new String[] { "2", "0" });
        this.createGUI();
    }

    public abstract void createGUI();

    public void caretUpdate(CaretEvent e) {
        Command command = (Command) e.getSource();
        command.execute(e);
    }

    public void actionPerformed(ActionEvent e) {
        Command command = (Command) e.getSource();
        command.execute(e);
    }

    public void tableChanged(TableModelEvent e) {
        Command command = (Command) e.getSource();
        command.execute(e);
    }

    public void close() {
        this.dispose();
    }

    public void saveClose() {
        save();
        close();
    }

}
