/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/09/27, 18:15
!  AUTHOR(S): KOGA, Junichiro
!  File : AxisConfigPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.viewer.prefs;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.ColorConfigGUI;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PosConfigGUI;
import ciss.phase_viewer.settings.PropConfigTextField;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * ̌hҏW
 * 
 * @author
 */
public class AxisConfigPanel extends InternalFrameChase {
    private Logger logger = Logger.getLogger(AxisConfigPanel.class.getName());
    private J3DPanel parent;
    private GlobalProperties props = PropertiesManager
            .getGlobalProperties(PropertiesManager.PROPERTIES_ACV);

    /** Creates a new instance of AxisConfigPanel */
    public AxisConfigPanel(J3DPanel parent) {
        super("axis", new Dimension(300, 240));
        this.parent = parent;
        this.parent.addDisposeOnExit(this);
        init();
        setVisible(true);
    }

    private void init() {
        Container container = getContentPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));

        PropConfigTextField fontSize = new PropConfigTextField(5,
                PropConfigTextField.INT, "axis_label_font_size", props);
        ColorConfigGUI fontColor = new ColorConfigGUI("font color",
                "axis_label_font_color", props);
        PropConfigTextField axisLength = new PropConfigTextField(5,
                PropConfigTextField.FLOAT, "axis_length", props);
        PosConfigGUI axisPos = new PosConfigGUI("axis pos", "axis_pos", props);

        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, BoxLayout.X_AXIS));
        JPanel pfontSize = new JPanel();
        pfontSize.setBorder(new TitledBorder("font size"));
        pfontSize.add(fontSize);
        p1.add(pfontSize);
        JPanel pfontColor = new JPanel();
        pfontColor.setBorder(new TitledBorder("font color"));
        pfontColor.add(fontColor);
        p1.add(pfontColor);
        JPanel paxisLength = new JPanel();
        paxisLength.setBorder(new TitledBorder("axis length"));
        paxisLength.add(axisLength);
        p1.add(paxisLength);

        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, BoxLayout.X_AXIS));
        p2.add(axisPos);

        panel.add(p1);
        panel.add(p2);

        JButton appl = new JButton("apply");
        JButton dism = new JButton("dismiss");

        appl.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                apply();
            }
        });

        dism.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        JPanel btn = new JPanel();
        btn.setLayout(new BoxLayout(btn, BoxLayout.X_AXIS));
        btn.add(appl);
        btn.add(dism);

        panel.add(btn);

        container.add(panel);
    }

    private void apply() {
        props.storeProperty();
    }

}
