/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/16, 12:46
!  AUTHOR(S): KOGA, Junichiro
!  File : StdoutGeneral.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.stdout;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.plugins.projectmanipulator.stdout.JobStatusPanel;
import ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel.parsers.Output000Parser;
import ciss.phase_viewer.projectbrowser.tools.StdoutBasePanel;

/**
 * UVSOR̕Wo͕\pGUI
 * 
 * @author
 */
public class StdoutGeneral extends StdoutBasePanel {
    private Logger logger = Logger.getLogger(StdoutGeneral.class.getName());

    private JobStatusPanel jsp;

    /** Creates a new instance of StdoutGeneral */
    public StdoutGeneral() {
        setLayout(new BorderLayout());
    }

    public void create() {
        if (outputParser == null) {
            return;
        }
        removeAll();
        JPanel p = new JPanel();
        GridBagLayout grid = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();

        p.setLayout(grid);
        constraints.fill = GridBagConstraints.HORIZONTAL;
        constraints.weightx = 1;
        constraints.weighty = 0;

        JPanel ptime = new JPanel();
        ptime.setBorder(new TitledBorder("job status"));
        if (jsp == null) {
            jsp = new JobStatusPanel(outputParser.getParent().getProjectInfo());
            jsp.setFileName(outputParser.getFileName());
        } else {
            jsp.setFileName(outputParser.getFileName());
        }
        ptime.add(jsp);
        p.add(ptime, constraints);

        constraints.gridx = 0;
        constraints.gridy = 1;

        JPanel pinfo = new JPanel();
        pinfo.setLayout(new BoxLayout(pinfo, BoxLayout.X_AXIS));
        pinfo.setBorder(new TitledBorder("info"));

        JPanel pinfo1 = new JPanel();
        pinfo1.setLayout(new BoxLayout(pinfo1, BoxLayout.Y_AXIS));
        JLabel osci = new JLabel();
        osci.setText("oscillator strength per electron : "
                + outputParser.getGenericData(Output000Parser.OSCILLATOR)[0]);
        pinfo1.add(osci);
        pinfo1.add(new JLabel(" "));

        JLabel allk = new JLabel();
        allk.setText("have all kpoints been calculated? "
                + outputParser.getGenericData(Output000Parser.ALL_KPOINTS)[0]);
        pinfo1.add(allk);
        pinfo1.add(new JLabel(" "));

        JPanel panelList = new JPanel();
        panelList.setLayout(new BoxLayout(panelList, BoxLayout.Y_AXIS));
        JLabel list = new JLabel("list of band numbers for each spin");
        panelList.add(list);
        String[] foo = outputParser
                .getGenericData(Output000Parser.LIST_OF_BAND);
        for (int i = 0; i < foo.length; i++) {
            logger.debug("list_of_band " + foo[i]);
            JLabel tmp = new JLabel(foo[i]);
            panelList.add(tmp);
        }
        pinfo1.add(panelList);
        pinfo1.add(new JLabel(" "));

        JPanel pinfo2 = new JPanel();
        pinfo2.setBorder(new TitledBorder("band gap"));
        pinfo2.setLayout(new GridLayout());
        JTextArea jta = new JTextArea();
        jta.setEditable(false);
        jta.setText(outputParser.getGenericData(Output000Parser.BANDGAP)[0]);
        jta.setBackground(getBackground());
        pinfo2.add(jta);

        pinfo.add(pinfo1);
        pinfo.add(pinfo2);

        p.add(pinfo, constraints);

        this.add(p, BorderLayout.NORTH);
    }

    public String getDescription() {
        return "general";
    }

}
