/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/13, 20:16
!  AUTHOR(S): KOGA, Junichiro
!  File : NLOParser.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel.parsers;

import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.ProgressInfo;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;

/**
 * UVSOR-Epsilon, F_NLOt@C̃p[T[
 * 
 * @author
 */
public class NLOParser extends OutputParser implements ProgressInfo {
    private Logger logger = Logger.getLogger(NLOParser.class.getName());
    private OutputData outputData = new OutputData();

    /** Creates a new instance of NLOParser */
    public NLOParser(String fileName) {
        super(fileName);
        outputData.setFileName(fileName);
    }

    public String getCurrentMessage() {
        return null;
    }

    protected boolean parse() {
        try {
            String line = "";
            reader.readLine();
            doHeader();
            while ((line = reader.readLine()) != null) {
                parseLine(line.trim());
            }
        } catch (Exception exc) {
            exc.printStackTrace();
            return false;
        } finally {
            try {
                reader.close();
            } catch (Exception exc) {
            }
        }
        return true;
    }

    private String[] idents = { "Photon Energy(eV)", "real part",
            "imaginary part", " abs" };

    private boolean doHeader() {
        try {
            if (reader == null)
                return false;
            String tabIdent = reader.readLine().trim();
            reader.readLine();
            outputData.setName(tabIdent);
            outputData.setIdentifier(idents);
            outputData.setDescription("x2 for : " + tabIdent);
        } catch (Exception exc) {
            // exc.printStackTrace();
            return false;
        }
        return true;
    }

    private Vector dats = new Vector();

    private void parseLine(String line) {
        if (line.startsWith("*")) {
            String[][] data2d = new String[dats.size()][];
            dats.copyInto(data2d);
            outputData.setData2D(data2d);
            addOutputData(outputData);
            outputData = new OutputData();
            outputData.setFileName(fileName);
            doHeader();
            dats = new Vector();
        } else {
            String[] foo = line.split("\\s+");
            dats.add(foo);
        }
    }

}
