/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/23, 17:27
!  AUTHOR(S): KOGA, Junichiro
!  File : GeneralPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.preparationpanel;

import java.awt.BorderLayout;
import java.awt.GridLayout;

import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author
 */
public class GeneralPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(GeneralPanel.class.getName());

    /** Creates a new instance of GeneralPanel */
    public GeneralPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void initializeProject() {
    }

    public void init() {
        setLayout(new BorderLayout());
        add(new General(projectInfo.getInputInterface()), BorderLayout.NORTH);
    }

    class General extends PhaseInputItems {
        General(InputInterface inputInterface) {
            super(inputInterface);
        }

        public void createGUI() {
            String[] specsw = new String[] { "epsilon.sw_epsilon" };
            ChoicePanelPhase method = new ChoicePanelPhase(specsw,
                    inputInterface, "sw_epsilon", ON_OFF, ON_OFF_DUPLI, this);
            String[] spec_cryst = new String[] { "epsilon.crystal_type" };
            String[] choiceCryst = new String[] { "single", "poly" };
            ChoicePanelPhase cryst = new ChoicePanelPhase(spec_cryst,
                    inputInterface, "crystal type", choiceCryst, this);
            String[] spec_ipri = new String[] { "epsilon.ipriepsilon" };
            String[] choiceIpri = new String[] { "0", "1", "2" };
            ChoicePanelPhase ipri = new ChoicePanelPhase(spec_ipri,
                    inputInterface, "print level", choiceIpri, this);
            JPanel p = new JPanel();
            p.setLayout(new GridLayout(1, 3));
            p.add(method);
            p.add(cryst);
            p.add(ipri);
            add(p);
        }

    }
}
