/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/16, 11:57
!  AUTHOR(S): KOGA, Junichiro
!  File : StdoutPostPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.graph.DataPanel;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.projectbrowser.tools.StdoutBasePanel;

/**
 * Wo͂, |XgɊւ\.
 * 
 * @author
 */
public class StdoutPostPanel extends StdoutBasePanel {
    private Logger logger = Logger.getLogger(StdoutPostPanel.class.getName());
    private JComboBox kpointSelector;
    private JLabel kpoints;
    private TitledBorder kpointTitle;
    private JPanel peigen;
    private JPanel pkpoint;
    private JPanel pfermi;

    private JPanel pstress;

    private JTabbedPane tabbedPane;
    private String[] kinds;

    /** Creates a new instance of StdoutPostPanel */
    public StdoutPostPanel() {
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    }

    public void create() {
        if (outputParser == null) {
            return;
        }
        if (tabbedPane == null) {
            tabbedPane = new JTabbedPane();
            add(tabbedPane);
        }
        tabbedPane.removeAll();

        int num_kpoints = 0;
        try {
            num_kpoints = Integer.parseInt(outputParser
                    .getGenericData("num_kpoints")[0]);
        } catch (Exception exc) {
            exc.printStackTrace();
            return;
        }
        if (num_kpoints == 0) {
            logger.debug("num_kpoints is 0");
            return;
        }

        kinds = new String[num_kpoints];
        for (int i = 0; i < num_kpoints; i++) {
            String kk = "kpoint_" + String.valueOf(i);
            String[] kps = outputParser.getGenericData(kk);
            if (kps == null || kps.length == 0) {
                continue;
            }
            String updown = "";
            if (kps[0] == null) {
                continue;
            }
            if (kps[0].trim().length() != 0) {
                updown = " spin: " + kps[0];
            }
            String klabel = updown + "  kx:  " + kps[1] + "  ky:  " + kps[2]
                    + "  kx:  " + kps[3];

            kinds[i] = " index: " + String.valueOf(i + 1) + " " + klabel;
            logger.debug(kinds[i]);
        }

        String title = "select kpoint (number of kpoints: "
                + String.valueOf(num_kpoints) + ")";
        kpointTitle = new TitledBorder(title);

        peigen = new JPanel();
        peigen.setLayout(new BoxLayout(peigen, BoxLayout.Y_AXIS));

        pkpoint = new JPanel();
        pkpoint.setLayout(new BoxLayout(pkpoint, BoxLayout.X_AXIS));
        pkpoint.setBorder(kpointTitle);

        pfermi = new JPanel();
        // pfermi.setLayout(new BoxLayout(pfermi,BoxLayout.X_AXIS));
        pfermi.setBorder(new TitledBorder("fermi energy"));
        String ef = "(not available)";
        String[] fermi = outputParser.getGenericData("fermi");
        if (fermi != null && fermi.length >= 1) {
            ef = fermi[0];
        }
        JLabel lef = new JLabel(ef + " Hartree");
        pfermi.add(lef);

        JPanel selectPanel = new JPanel();
        selectPanel.setBorder(new TitledBorder("kpoint index"));
        kpointSelector = new JComboBox(kinds);
        selectPanel.add(kpointSelector);
        kpoints = new JLabel();

        pkpoint.add(selectPanel);
        pkpoint.add(kpoints);

        kpointSelector.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                kpointSelection();
            }
        });
        kpointSelector.setSelectedIndex(0);

        if (pstress == null) {
            pstress = new JPanel();
            pstress.setLayout(new BoxLayout(pstress, BoxLayout.X_AXIS));
        }

        String[][] stress_tensor = outputParser.getGenericData2D("stress");
        String[] stress_ident = { "xx,xy,xz", "yx,yy,yz", "zx,zy,zz" };
        OutputData outStress = new OutputData("stress tensor",
                "elements of stress tensor", stress_ident, stress_tensor, "");
        outStress.setFileName(outputParser.getFileName());
        if (dpanelStress == null) {
            dpanelStress = new DataPanel(outStress);
        } else {
            dpanelStress.setOutputData(outStress);
        }
        dpanelStress.setPreferredSize(new Dimension(50, 200));
        pstress.removeAll();
        pstress.add(dpanelStress);

        JPanel ppeigen = new JPanel();
        ppeigen.setLayout(new BorderLayout());
        ppeigen.add(peigen, BorderLayout.NORTH);
        tabbedPane.addTab("eigenvalue", ppeigen);
        tabbedPane.addTab("stress tensor", pstress);
        revalidate();
    }

    private DataPanel dpanel;
    private DataPanel dpanelStress;

    private void kpointSelection() {
        if (kpointSelector.getSelectedIndex() < 0) {
            return;
        }

        String ee = "eigen_"
                + String.valueOf(kpointSelector.getSelectedIndex());
        String oo = "occup_"
                + String.valueOf(kpointSelector.getSelectedIndex());
        String[] eigen = outputParser.getGenericData(ee);
        String[] occup = outputParser.getGenericData(oo);
        String[][] data2d = new String[eigen.length][3];
        if (eigen.length != occup.length)
            return;

        for (int i = 0; i < eigen.length; i++) {
            data2d[i][0] = String.valueOf(i + 1);
            data2d[i][1] = eigen[i];
            data2d[i][2] = occup[i];
        }

        String[] idents = { " band index ", "eigenvalue (a.u.) ",
                " occupation " };
        OutputData outData = new OutputData("eigenvalue",
                "eigenvalue at a particular k-point", idents, data2d, "");
        outData.setFileName(outputParser.getFileName());
        if (dpanel == null) {
            dpanel = new DataPanel(outData);
        } else {
            dpanel.setOutputData(outData);
        }
        dpanel.setPreferredSize(new Dimension(50, 200));
        peigen.removeAll();

        peigen.setLayout(new BoxLayout(peigen, BoxLayout.Y_AXIS));
        peigen.add(pfermi);
        peigen.add(pkpoint);
        peigen.add(dpanel);
    }

    public String getDescription() {
        return "post";
    }

}
