/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 14:18
!  AUTHOR(S): KOGA, Junichiro
!  File : DosPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.InputPanel;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.primitiveguis.ComboButton;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.ChoosableOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.ONOFFOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlExecPanel;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScript;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScriptOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.RangeOption;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.TextOption;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;

/**
 * Ԗx͗ppl.
 * 
 * @author KOGA, Junichiro
 */
public class DosPanel extends ProjectManipulator implements
        OutputParserListener {
    private Logger logger = Logger.getLogger(DosPanel.class.getName());

    /** Creates a new instance of DosPanel */
    public DosPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    }

    public void recreate() {
        projectInfo.getOutputInterface().initCache();
        init();
        revalidate();
    }

    private OutputParser parser;
    private String dosfile;

    public void init() {
        removeAll();
        String fname = projectInfo.getProjectDirectory()
                + System.getProperty("file.separator")
                + projectInfo.getChaseFileManager().getFile("F_DOS")
                        .getFileName();
        dosfile = fname;
        if (!new File(fname).exists()) {
            add(new NoFilePanel("F_DOS"));
            return;
        }
        add(new LoadingFilePanel("F_DOS"));
        if (parser == null) {
            parser = projectInfo.getOutputInterface().getParser("F_DOS", this);
        }
        parser.setParsed(false);
        parser.doParse();
    }

    public void initializeProject() {
    }

    private void bootDosPlPanel() {
        PerlScript script = new PerlScript("dos.pl", new File(
                projectInfo.getProjectDirectory()));
        script.setCommand(new String[] {
                projectInfo.getChaseFileManager().getFile("F_DOS")
                        .getFileName(), PerlScriptOption.OPTION });

        // PerlScriptOption mode = new ChoosableOption("mode",new
        // String[]{"total","atom","layer","projected"});
        PerlScriptOption mode = new ChoosableOption("mode", new String[] {
                "total", "atom", "layer", "projected" });
        PerlScriptOption erange = new RangeOption("erange");
        PerlScriptOption einc = new TextOption("einc");
        PerlScriptOption dosrange = new RangeOption("dosrange");
        PerlScriptOption dosinc = new TextOption("dosinc");
        PerlScriptOption with_fermi = new ONOFFOption("with_fermi");
        PerlScriptOption color = new ONOFFOption("color");
        PerlScriptOption title = new TextOption("title");
        PerlScriptOption width = new TextOption("width");
        PerlScriptOption font = new TextOption("font");

        script.addOptions(mode);
        script.addOptions(erange);
        script.addOptions(einc);
        script.addOptions(dosrange);
        script.addOptions(dosinc);
        script.addOptions(with_fermi);
        script.addOptions(color);
        script.addOptions(title);
        script.addOptions(width);
        script.addOptions(font);

        PerlExecPanel panel = new PerlExecPanel("run dos.pl", new Dimension(
                400, 250), script);
        panel.closeAfterOK(false);

        //
        // DosPlPanel dpp = new DosPlPanel("run dos.pl");
        // String dirString =
        // projectInfo.getProjectDirectory()+System.getProperty("file.separator");
        // dpp.setProjDir(dirString);
        // String dosdata =
        // projectInfo.getChaseFileManager().getFile("F_DOS").getFileName();
        // dpp.setDosData(dosdata);
        // dpp.setVisible(true);
    }

    private JPanel createDosPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        JPanel panelmode = new JPanel();
        panelmode.setLayout(new BoxLayout(panelmode, BoxLayout.X_AXIS));
        String[] modes = { "total", "atom", "layer" };
        JComboBox checkMode = new JComboBox(modes);
        InputPanel width = new InputPanel("width", 0, 5);
        JCheckBox checkFermi = new JCheckBox("with_fermi");
        JCheckBox checkColor = new JCheckBox("");
        return panel;
    }

    public void parseFinished() {
        removeAll();
        JPanel button = new JPanel();
        button.setBorder(new TitledBorder("dos.pl"));
        button.setLayout(new FlowLayout());
        JButton btndospl = new JButton("run dos.pl");
        button.add(btndospl);
        ComboButton cbdos = new ComboButton(projectInfo.getProjectDirectory(),
                new String[] { "density_of_states.eps", "dos_a\\d+.eps",
                        "dos_l\\d+.eps", "dos_a\\d+l\\d+m\\d+t\\d+.eps" });
        button.add(cbdos);
        add(button);

        JPanel dataPanel = projectInfo.getOutputInterface().getDataPanel(
                "F_DOS");
        add(dataPanel);

        revalidate();

        btndospl.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                bootDosPlPanel();
            }
        });
    }

}
