/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 14:38
!  AUTHOR(S): KOGA, Junichiro
!  File : BlueMoonPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.common.MyThreadListener;
import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.outputinterface.OutputData;
import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.CheckPanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.tools.LoadingFilePanel;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;

/**
 * F_ENFt@C̕\.
 * 
 * @author KOGA, Junichiro
 */
public class BlueMoonPanel extends ProjectManipulator implements
        OutputParserListener, MyThreadListener {
    private Logger logger = Logger.getLogger(BlueMoonPanel.class.getName());
    private OutputData[] outputs;

    /** Creates a new instance of EnergyPanel */
    public BlueMoonPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void parseFinished() {
        removeAll();
        outputs = projectInfo.getOutputInterface().getParser("F_BLUEM", this)
                .getOutputData();

        if (outputs == null) {
            return;
        }
        add(firstRow());
        add(projectInfo.getOutputInterface().getDataPanel("F_BLUEM"));
        revalidate();
    }

    private OutputParser parser;
    private ChaseFile cf;
    private String[] reacfiles = null;
    private int nreac = 0;

    public void init() {
        setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
        parse();
    }

    private void parse() {
        cf = projectInfo.getChaseFileManager().getFile("F_BLUEM");
        String potfile = projectInfo.getProjectDirectory()
                + System.getProperty("file.separator")
                + "potential_of_mean_force.data";
        Vector potfiles = new Vector();
        if (new File(potfile).exists()) {
            potfiles.add(new File(potfile).getName());
        }
        String ffile = projectInfo.getProjectDirectory()
                + System.getProperty("file.separator") + "mean_force_raw.data";
        if (new File(ffile).exists()) {
            potfiles.add(new File(ffile).getName());
        }
        String fsfile = projectInfo.getProjectDirectory()
                + System.getProperty("file.separator")
                + "mean_force_smoothed.data";
        if (new File(fsfile).exists()) {
            potfiles.add(new File(fsfile).getName());
        }

        String[] tmpreacfiles = new File(projectInfo.getProjectDirectory())
                .list(new FilenameFilter() {
                    public boolean accept(File arg0, String arg1) {
                        if (arg1.matches(cf.getFileName() + ".reac\\d+"))
                            return true;
                        return false;
                    }
                });
        if (potfiles.size() != 0 || tmpreacfiles != null
                && tmpreacfiles.length != 0) {
            int nsize = potfiles.size();
            if (tmpreacfiles != null)
                nsize += tmpreacfiles.length;
            reacfiles = new String[nsize];
            for (int i = 0; i < potfiles.size(); i++)
                reacfiles[i] = potfiles.get(i).toString();
            for (int i = potfiles.size(); i < nsize; i++)
                reacfiles[i] = tmpreacfiles[i - potfiles.size()];
        }
        if (reacfiles == null || reacfiles.length == 0) {
            add(new NoFilePanel("F_BLUEM"));
            return;
        }
        nreac = tmpreacfiles.length;
        add(new LoadingFilePanel("F_BLUEM"));
        if (parser == null) {
            parser = projectInfo.getOutputInterface()
                    .getParser("F_BLUEM", this);
        }
        parser.resetFiles();
        for (int i = 0; i < reacfiles.length; i++) {
            logger.debug("F_BLUEM file: " + reacfiles[i]);
            parser.addFile(projectInfo.getProjectDirectory()
                    + System.getProperty("file.separator") + reacfiles[i]);
        }
        parser.setParsed(false);
        parser.doParse();
    }

    public void initializeProject() {
    }

    private JPanel firstRow() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
        JPanel pnumreac = new JPanel();
        pnumreac.setBorder(new TitledBorder("number of reac coords"));
        JLabel lnumreac = new JLabel(String.valueOf(nreac));
        pnumreac.add(lnumreac);
        panel.add(pnumreac);
        JButton btnrunbm = new JButton("run 'bluemoon'");
        JPanel pbtn = new JPanel();
        pbtn.add(btnrunbm);
        panel.add(pbtn);
        btnrunbm.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent arg0) {
                new RunBM(projectInfo);
            }
        });
        return panel;
    }

    private JButton run;

    class RunBM extends InternalFrameChase {
        RunBM(ProjectInfo pinfo) {
            super("run the 'bluemoon' utility", true, true, true, true,
                    new Dimension(350, 350));
            getContentPane().setLayout(
                    new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
            RunBMsub rbs = new RunBMsub(pinfo);
            rbs.init();
            getContentPane().add(rbs);
            getContentPane().add(getBtnPanel());
        }

        JPanel getBtnPanel() {
            JPanel panel = new JPanel();
            run = new JButton("run");
            JButton dismiss = new JButton("dismiss");
            panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
            panel.add(run);
            panel.add(dismiss);

            dismiss.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent arg0) {
                    dispose();
                }
            });

            run.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent arg0) {
                    runBM();
                    dispose();
                }
            });
            return panel;
        }
    }

    private void runBM() {
        logger.info("running the 'bluemoon' utility program.");
        String bmPath = System.getProperty("pviewer.home") + FS + "bin" + FS
                + "bluemoon";
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            bmPath += ".exe";
        }
        if (!new File(bmPath).exists()) {
            logger.error("'bluemoon' program not found.");
            logger.error("put it under PHASE_VIEWER_HOME/bin");
            return;
        }
        projectInfo.getInputInterface().save();
        String nfinp = "\"" + projectInfo.getInputInterface().getFileName()
                + "\"";
        bmPath += " " + nfinp;
        new MyThread(bmPath, this, new File(projectInfo.getProjectDirectory()),
                null);
    }

    class RunBMsub extends ProjectManipulator {
        RunBMsub(ProjectInfo projectInfo) {
            super(projectInfo);
        }

        public void init() {
            add(new RunBMsubsub(projectInfo.getInputInterface()));
        }

        public void initializeProject() {
        }
    }

    class RunBMsubsub extends PhaseInputItems {
        public RunBMsubsub(InputInterface inputInterface) {
            super(inputInterface);
        }

        public void createGUI() {
            ActionListener al = new ActionL();
            setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
            String therm = "thermodynamic_integration.";

            JPanel preac = new JPanel();
            preac.setLayout(new BoxLayout(preac, BoxLayout.X_AXIS));
            preac.setBorder(new TitledBorder(
                    "reaction coordinates taken into account"));
            InputPanelPhase ippnreac = new InputPanelPhase(new String[] { therm
                    + "nreac_coords" }, inputInterface, "to",
                    InputPanelPhase.NONE, 6, this);
            ippnreac.getTextField().addActionListener(al);
            InputPanelPhase ippsreac = new InputPanelPhase(new String[] { therm
                    + "istart_reac_coords" }, inputInterface, "from",
                    InputPanelPhase.NONE, 6, this);
            ippsreac.getTextField().addActionListener(al);
            JPanel pn0 = new JPanel();
            pn0.add(ippnreac);
            JPanel pn1 = new JPanel();
            pn1.add(ippsreac);
            preac.add(pn1);
            preac.add(pn0);

            InputPanelPhase ippnequib = new InputPanelPhase(
                    new String[] { therm + "nequib" }, inputInterface, "from",
                    InputPanelPhase.NONE, 6, this);
            ippnequib.getTextField().addActionListener(al);
            InputPanelPhase ippnsteps = new InputPanelPhase(
                    new String[] { therm + "nsteps" }, inputInterface, "to",
                    InputPanelPhase.NONE, 6, this);
            ippnsteps.getTextField().addActionListener(al);
            InputPanelPhase ippnsamp = new InputPanelPhase(new String[] { therm
                    + "nsample" }, inputInterface, "sample",
                    InputPanelPhase.NONE, 6, this);
            ippnsamp.getTextField().addActionListener(al);
            JPanel psteps = new JPanel();
            psteps.setLayout(new BoxLayout(psteps, BoxLayout.X_AXIS));
            psteps.setBorder(new TitledBorder("MD steps taken into account"));
            psteps.add(ippnequib);
            psteps.add(ippnsteps);
            psteps.add(ippnsamp);

            JPanel pauxil = new JPanel();
            pauxil.setBorder(new TitledBorder("smoothing"));
            pauxil.setLayout(new BoxLayout(pauxil, BoxLayout.X_AXIS));
            CheckPanelPhase cbsmooth = new CheckPanelPhase(new String[] { therm
                    + "smooth" }, inputInterface, "smooth", this);
            InputPanelPhase ippnxsi = new InputPanelPhase(new String[] { therm
                    + "n_xsi" }, inputInterface, "num. points",
                    InputPanelPhase.NONE, 6, this);
            ippnxsi.getTextField().addActionListener(al);
            pauxil.add(cbsmooth);
            JPanel pnn = new JPanel();
            pnn.add(ippnxsi);
            pauxil.add(pnn);
            cbsmooth.registerDisabableGUI(ippnxsi);

            add(preac);
            add(psteps);
            add(pauxil);
        }

        class ActionL implements ActionListener {
            public void actionPerformed(ActionEvent arg0) {
                run.doClick();
            }
        }
    }

    public void done() {
        logger.info("... done.");
        parse();
    }

}
