/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/17, 14:08
!  AUTHOR(S): KOGA, Junichiro
!  File : SolverDetails.java
!
!  Contact address :  Phase System Consortium
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.Container;
import java.awt.Dimension;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.primitiveguis.CheckPanelPhase;
import ciss.phase_viewer.primitiveguis.CloseButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputChildrenPanel;

/**
 * PHASE̓t@C, \o[ݒ̏ڍׂɊւp^[ݒ肷邽߂ GUI񋟂NX.
 * 
 * @author KOGA Junichiro,
 */
public class SolverDetails extends PhaseInputChildrenPanel {
    private static Logger logger = Logger.getLogger(SolverDetails.class
            .getName());

    public SolverDetails(InputInterface inputInterface) {
        super("Solver Details", true, true, true, true, inputInterface,
                new Dimension(500, 420));
    }

    public void createGUI() {

        JPanel psdtl = this.createSolverDetailPanel();
        CloseButton btnclose = new CloseButton(this);

        Container cont = getContentPane();
        cont.setLayout(new BoxLayout(cont, BoxLayout.Y_AXIS));

        cont.add(psdtl);
        cont.add(btnclose);

        setResizable(true);
    }

    public void delete() {
    }

    public void add() {
    }

    public void save() {
    }

    private JPanel createSolverDetailPanel() {

        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        // p.setPreferredSize(new Dimension(500, 280));

        JPanel p_ln_minimization = new JPanel();
        // p_ln_minimization.setLayout(new GridLayout(1, 2, 1, 1));

        String[] specLower = { "wavefunction_solver.line_minimization.dt_lower_critical" };
        String[] specUpper = { "wavefunction_solver.line_minimization.dt_upper_critical" };
        InputPanelPhase lower = new InputPanelPhase(specLower, inputInterface,
                "dt_lower_critical", InputPanelPhase.NONE, 14, this);
        InputPanelPhase upper = new InputPanelPhase(specUpper, inputInterface,
                "dt_upper_critical", InputPanelPhase.NONE, 14, this);
        p_ln_minimization.add(lower);
        p_ln_minimization.add(upper);
        p_ln_minimization.setBorder(new TitledBorder("line_minimization"));
        p.add(p_ln_minimization);

        JPanel p_rmm = new JPanel();
        // p_rmm.setLayout(new GridLayout(1, 1, 1, 1));
        String[] specGSrmm = { "wavefunction_solver.rmm.imGSrmm" };
        String[] specCV = { "wavefunction_solver.rmm.rr_Critical_Value" };
        String[] specDelt = { "wavefunction_solver.rmm.edelta_change_to_rmm" };
        InputPanelPhase gsrmm = new InputPanelPhase(specGSrmm, inputInterface,
                "imGSrmm", InputPanelPhase.NONE, 5, this);
        InputPanelPhase cv = new InputPanelPhase(specCV, inputInterface,
                "rr_Critical_Value", InputPanelPhase.NONE, 5, this);
        InputPanelPhase delt = new InputPanelPhase(specDelt, inputInterface,
                "edelta_change_to_rmm", InputPanelPhase.ENERGY, 10, this);
        // p_rmm.add(gsrmm);
        // p_rmm.add(cv);
        p_rmm.add(delt);
        p_rmm.setBorder(new TitledBorder("RMM-DIIS"));
        JPanel pprmm = new JPanel();
        pprmm.add(p_rmm);
        p.add(p_rmm);

        // subspace_rotation
        JPanel psub = new JPanel();
        psub.setBorder(new TitledBorder("subspace_rotation"));
        psub.setLayout(new BoxLayout(psub, BoxLayout.Y_AXIS));
        JPanel p_subspace_rot = new JPanel();
        // p_subspace_rot.setLayout(new GridLayout(2, 2, 1, 1));

        String[] specMatsize = { "wavefunction_solver.subspace_rotation.subspace_matrix_size" };
        String[] specDamp = { "wavefunction_solver.subspace_rotation.damping_factor" };
        String[] specPeriod = { "wavefunction_solver.subspace_rotation.period" };
        String[] specCritical = { "wavefunction_solver.subspace_rotation.critical_ratio" };
        String[] specRenewal = { "wavefunction_solver.subspace_rotation.before_renewal" };

        InputPanelPhase matsize = new InputPanelPhase(specMatsize,
                inputInterface, "subspace_matrix_size", InputPanelPhase.NONE,
                15, this);
        InputPanelPhase damp = new InputPanelPhase(specDamp, inputInterface,
                "damping_factor", InputPanelPhase.NONE, 15, this);
        InputPanelPhase period = new InputPanelPhase(specPeriod,
                inputInterface, "period", InputPanelPhase.NONE, 15, this);
        InputPanelPhase critical = new InputPanelPhase(specCritical,
                inputInterface, "critical_ratio", InputPanelPhase.NONE, 15,
                this);
        CheckPanelPhase renewal = new CheckPanelPhase(specRenewal,
                inputInterface, "apply subspace rotation before renewal of WF",
                this, true);
        CheckPanelPhase scalapack = new CheckPanelPhase(
                new String[] { "wavefunction_solver.subspace_rotation.scalapack.sw_scalapack" },
                inputInterface, "use ScaLAPACK", this, false);
        // p_subspace_rot.add(matsize);
        // p_subspace_rot.add(damp);
        // p_subspace_rot.add(period);
        // p_subspace_rot.add(critical);

        JPanel ppsub = new JPanel();
        // ppsub.add(p_subspace_rot);
        ppsub.add(renewal);
        ppsub.add(scalapack);
        psub.add(ppsub);
        // psub.add(renewal);
        p.add(psub);

        JPanel pdavidson = new JPanel();
        // pdavidson.setLayout(new BoxLayout(pdavidson,BoxLayout.X_AXIS));
        pdavidson.setBorder(new TitledBorder("Davidson"));
        // String[] specdavidmax = {
        // "wavefunction_solver.davidson.max_subspace_size" };
        // InputPanelPhase ippdavidson = new InputPanelPhase(specdavidmax,
        // inputInterface, "max. subspace size", InputPanelPhase.NONE, 15,
        // this);
        // pdavidson.add(ippdavidson);
        String[] specDiv = { "wavefunction_solver.davidson.sw_divide_subspace" };
        CheckPanelPhase cppDiv = new CheckPanelPhase(specDiv, inputInterface,
                "divide subspace", this, true);
        String[] specPart = { "wavefunction_solver.davidson.npartition" };
        InputPanelPhase ippPart = new InputPanelPhase(specPart, inputInterface,
                "partition", InputPanelPhase.NONE, 7, this);
        String[] maxIter = { "wavefunction_solver.davidson.max_iteration" };
        InputPanelPhase ippMaxIter = new InputPanelPhase(maxIter,
                inputInterface, "max. iteration", InputPanelPhase.NONE, 7, this);
        String[] specMRCV = { "wavefunction_solver.davidson.sw_MRCV_only" };
        CheckPanelPhase cppMRCV = new CheckPanelPhase(specMRCV, inputInterface,
                "use only the most-rescent correction vector", this, true);
        pdavidson.add(cppDiv);
        pdavidson.add(ippPart);
        pdavidson.add(ippMaxIter);
        pdavidson.add(cppMRCV);
        p.add(pdavidson);

        return p;
    }
}
