/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/08/16, 13:21
!  AUTHOR(S): KOGA, Junichiro
!  File : AccuracyPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.CheckPanelPhase;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * creates panel for editing the 'accuracy' block as specified in the phase
 * inputfile specifications.
 * 
 * @author KOGA, Junichiro
 */
public class AccuracyPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(AccuracyPanel.class.getName());

    /** Creates a new instance of AccuracyPanel */
    public AccuracyPanel(ProjectInfo projectInfo) {
        super(projectInfo);
        setLayout(new GridLayout());
    }

    public void init() {
        JScrollPane scr = new JScrollPane();
        scr.getViewport().setView(
                new AccuracyPanelPanel(projectInfo.getInputInterface()));
        add(scr);
    }

    public void initializeProject() {
    }

}

class AccuracyPanelPanel extends PhaseInputItems {
    AccuracyPanelPanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    public void createGUI() {
        this.add(createAccuracyPanel());
    }

    private InputPanelPhase numbands;

    private JPanel createAccuracyPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        p.setSize(500, 250);

        JPanel p_cutoff = new JPanel();
        p_cutoff.setLayout(new GridLayout(1, 2, 1, 1));

        String accuracy = "accuracy.";
        String[] specWF = { accuracy + "cutoff_wf", accuracy + "cke_wf",
                accuracy + "cke_wavefunctions",
                accuracy + "cutoff_energy_for_wavefunctions" };
        String[] specCD = { accuracy + "cutoff_cd", accuracy + "cke_cd",
                accuracy + "cutoff_energy_for_chargedensity",
                accuracy + "cke_chargedensity" };
        InputPanelPhase wf = new InputPanelPhase(specWF, inputInterface,
                "wave function", InputPanelPhase.ENERGY, 7, this);
        InputPanelPhase cd = new InputPanelPhase(specCD, inputInterface,
                "charge density", InputPanelPhase.ENERGY, 7, this);

        p_cutoff.setBorder(new TitledBorder("Cut-off"));

        p_cutoff.add(wf);
        p_cutoff.add(cd);
        p.add(p_cutoff);

        JPanel p_numband = new JPanel();
        p_numband.setLayout(new GridLayout(1, 2, 1, 1));

        String[] specNumBnd = { accuracy + "num_bands" };
        numbands = new InputPanelPhase(specNumBnd, inputInterface,
                "num. bands", InputPanelPhase.NONE, 7, this);

        String[] specXC = { accuracy + "xctype" };
        String[] xcChoice = { NO_SELECTION, "ldapw91", "ggapbe" };
        ChoicePanelPhase xc = new ChoicePanelPhase(specXC, inputInterface,
                "XC type", xcChoice, this);

        JButton checknumbands = new JButton("check");
        JPanel pband = new JPanel();
        pband.setLayout(new BoxLayout(pband, BoxLayout.X_AXIS));
        pband.add(numbands);
        pband.add(checknumbands);
        p_numband.add(pband);
        // p_numband.add(xc);
        // p.add(p_numband);
        p_cutoff.add(p_numband);
        JPanel ppaw = new JPanel();
        ppaw.setLayout(new BoxLayout(ppaw, BoxLayout.X_AXIS));
        ppaw.setBorder(new TitledBorder("PAW"));
        CheckPanelPhase cppPAW = new CheckPanelPhase(new String[] { accuracy
                + "paw" }, inputInterface, "use the PAW method when possible",
                this, false);
        JPanel pppaw = new JPanel();
        pppaw.add(cppPAW);
        ppaw.add(pppaw);
        p.add(ppaw);

        JPanel p_ksample = new JPanel();
        // p_ksample.setLayout(new FlowLayout(FlowLayout.LEFT));
        p_ksample.setLayout(new BoxLayout(p_ksample, BoxLayout.Y_AXIS));
        p_ksample.setBorder(new TitledBorder("method"));
        String ksamp = accuracy + "ksampling.";
        String[] specMethod = { ksamp + "method" };
        String[] methodChoice = { NO_SELECTION, "monk", "mesh", "file", "gamma" };
        JPanel pmethod = new JPanel();
        ChoicePanelPhase method = new ChoicePanelPhase(specMethod,
                inputInterface, null, methodChoice, this);
        JPanel pmet = new JPanel();
        pmet.setLayout(new GridLayout(3, 1));
        ;
        pmet.add(new JPanel());
        pmet.add(method);
        pmet.add(new JPanel());
        p_ksample.add(pmet);

        // JPanel kpeditorpanel = new JPanel();
        // kpeditorpanel.setLayout(new BorderLayout());
        //
        // GUIBootButton btnfbz = new
        // GUIBootButton("FBZ",inputInterface,Kpoints.class,this);
        // method.registerDisabableGUI(new int[]{0,1,2,4,5},btnfbz);
        // kpeditorpanel.add(btnfbz,BorderLayout.NORTH);

        // GUIBootButton btnkdirect = new GUIBootButton("edit kpoints",
        // inputInterface, Kpoints.class, this);
        // method.registerDisabableGUI(new int[] { 0, 1, 2, 3, 4 }, btnkdirect);
        // kpeditorpanel.add(btnkdirect, BorderLayout.SOUTH);

        // p_ksample.add(kpeditorpanel);

        JPanel ptable = new JPanel();
        ptable.setLayout(new BoxLayout(ptable, BoxLayout.Y_AXIS));

        String[] kmeshSpec = { ksamp + "mesh" };
        TableForInputInterface kmeshTable = new TableForInputInterface(
                kmeshSpec, inputInterface, null, this);
        kmeshTable.getModel().addTableModelListener(this);
        JScrollPane scrPaneKmesh = new JScrollPane();
        scrPaneKmesh.getViewport().setView(kmeshTable.getPanel());
        // scrPaneKmesh.setPreferredSize(new Dimension(180, 35));
        // ptable.add(scrPaneKmesh);
        ptable.add(kmeshTable.getPanel());

        int icol = kmeshTable.getModel().getColumnCount();
        int[] intarray = new int[] { 3, 4, 5 };
        for (int j = 0; j < icol; j++) {
            DefaultCellEditor editor = (DefaultCellEditor) kmeshTable
                    .getColumnModel().getColumn(j).getCellEditor();
            method.registerDisabableGUI(intarray,
                    (JComponent) editor.getComponent());
        }

        String[] ksampIdent = { ksamp + "kshift" };
        TableForInputInterface kshiftTable = new TableForInputInterface(
                ksampIdent, inputInterface, null, this);
        JScrollPane scrPaneKshift = new JScrollPane();

        scrPaneKshift.getViewport().setView(kshiftTable.getPanel());
        ptable.add(kshiftTable.getPanel());
        icol = kshiftTable.getModel().getColumnCount();
        int[] intshift = new int[] { 2, 3, 4, 5 };
        for (int j = 0; j < icol; j++) {
            DefaultCellEditor editor = (DefaultCellEditor) kshiftTable
                    .getColumnModel().getColumn(j).getCellEditor();
            method.registerDisabableGUI(intshift,
                    (JComponent) editor.getComponent());
        }

        JPanel p_ksample_all = new JPanel();
        p_ksample_all.setBorder(new TitledBorder("K point sampling"));
        p_ksample_all.setLayout(new BoxLayout(p_ksample_all, BoxLayout.X_AXIS));
        p_ksample_all.add(p_ksample);
        p_ksample_all.add(ptable);
        p.add(p_ksample_all);

        JPanel p_smear = new JPanel();
        p_smear.setLayout(new GridLayout(1, 2, 1, 1));

        String[] specSmear = { accuracy + "smearing.method" };
        // String[] smearChoice = {NO_SELECTION, "parabolic", "cold",
        // "tetrahedron", "improved_tetrahedron"};
        String[] smearChoice = { NO_SELECTION, "parabolic", "cold",
                "tetrahedron" };
        Vector smearDupli = new Vector();
        smearDupli.add(new String[] { "3", "tetrahedral" });
        ChoicePanelPhase smear = new ChoicePanelPhase(specSmear,
                inputInterface, "Method", smearChoice, smearDupli, this);
        p_smear.add(smear);

        String[] specWidth = { accuracy + "smearing.width" };
        InputPanelPhase width = new InputPanelPhase(specWidth, inputInterface,
                "width", InputPanelPhase.ENERGY, 5, this);
        p_smear.add(width);

        smear.registerDisabableGUI(new int[] { 3 }, width);

        p_smear.setBorder(new TitledBorder("Smearing"));
        p.add(p_smear);

        JPanel p_conv = new JPanel();
        p_conv.setLayout(new GridLayout(1, 3));

        String scfconv = accuracy + "scf_convergence.";
        String[] specConvDe = { scfconv + "delta_total_energy" };
        InputPanelPhase scfde = new InputPanelPhase(specConvDe, inputInterface,
                "dE", InputPanelPhase.ENERGY, 5, this);
        p_conv.add(scfde);

        String[] specSuc = { scfconv + "succession" };
        InputPanelPhase scfsuc = new InputPanelPhase(specSuc, inputInterface,
                "succession", InputPanelPhase.NONE, 5, this);
        p_conv.add(scfsuc);

        String[] specForceConv = { accuracy + "force_convergence.max_force" };
        InputPanelPhase forcConv = new InputPanelPhase(specForceConv,
                inputInterface, "force", InputPanelPhase.FORCE, 5, this);
        p_conv.add(forcConv);

        p_conv.setBorder(new TitledBorder("Convergence"));
        p.add(p_conv);

        JPanel p_init = new JPanel();
        p_init.setLayout(new GridLayout(1, 2, 1, 1));

        String[] initWFSpec = { accuracy + "initial_wavefunctions" };
        String[] initWFChoice = { NO_SELECTION, "Matrix_diagon",
                "Random_numbers", "atomic_orbitals", "file" };
        ChoicePanelPhase initWF = new ChoicePanelPhase(initWFSpec,
                inputInterface, "wave function", initWFChoice, this);

        String[] matdiagonCutoffSpec = { accuracy + "matrix_diagon.cutoff_wf" };
        InputPanelPhase matdiagon = new InputPanelPhase(matdiagonCutoffSpec,
                inputInterface, "cutoff (matrix diagon)",
                InputPanelPhase.ENERGY, 5, this);

        p_init.add(initWF);
        p_init.add(matdiagon);

        initWF.registerDisabableGUI(new int[] { 0, 2 }, matdiagon);

        String[] initCDSpec = { accuracy + "initial_charge_density" };
        String[] initCDChoice = { "Gauss", "atomic_charge_density", "file" };
        ChoicePanelPhase initCD = new ChoicePanelPhase(initCDSpec,
                inputInterface, "charge density", initCDChoice, this);
        p_init.add(initCD);

        p_init.setBorder(new TitledBorder("Initial"));
        p.add(p_init);

        checknumbands.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent arg0) {
                checkNumBands();
            }

        });
        return p;
    }

    private void checkNumBands() {
        int currnumbands = -1;
        try {
            currnumbands = Integer.parseInt(numbands.getValue().trim());
        } catch (NumberFormatException nfe) {
        }
        int defnumb = PhaseUtils.checkNumBands(this, currnumbands,
                inputInterface);
        if (defnumb > 0)
            numbands.getTextField().setText(String.valueOf(defnumb));
    }

}
