/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/30 20:44:23
!  AUTHOR(S): KOGA, Junichiro
!  File : SCFbandWiz.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator.phase.inputwizard;

import java.util.HashMap;

import org.apache.log4j.Logger;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.input.InputWizardScript;
import ciss.phase_viewer.inputinterface.InputInterface;

public class SCFbandWiz extends InputWizardScript {
    private Logger logger = Logger.getLogger(SCFbandWiz.class.getName());

    protected String getScriptDir() {
        return phaseJobControl;
    }

    protected String[] getScripts() {
        return new String[] { "commands.bsh", "scf-band.bsh" };
    }

    public String getScriptPath() {
        return projDir + FS + "scf-band.bsh";
    }

    /*
     * (non-Javadoc)
     * 
     * @see ciss.phase_viewer.input.InputWizardScript#getObjects()
     */
    public HashMap getObjects() {
        HashMap map = new HashMap();
        double[][] cell = PhaseUtils
                .getReciprocalLatticeFrom((InputInterface) input);
        map.put("projectInfo", projectInfo);
        map.put("inputInterface", (InputInterface) input);
        map.put("reciprocalLattice", cell);
        return map;
    }

    private AtomCoords coords;

    /*
     * (non-Javadoc)
     * 
     * @see
     * ciss.phase_viewer.input.InputWizardScript#setProperties(java.util.HashMap
     * )
     */
    public void setProperties(HashMap properties) {
        try {
            this.coords = (AtomCoords) properties.get("atomcoords");
        } catch (Exception exc) {
            logger.error("failed to obtain atomic coordinates...");
        }
    }

}
