/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/10/16, 17:21
!  AUTHOR(S): KOGA, Junichiro
!  File : NumBandsChecker.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.inputcheck;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.input.PhaseInputChecker;

/**
 * oh`FbN.
 * 
 * @author
 */
public class NumBandsChecker extends PhaseInputChecker {

    private Logger logger = Logger.getLogger(NumBandsChecker.class.getName());

    /** Creates a new instance of NumBandsChecker */
    public NumBandsChecker() {
        super();
    }

    public boolean isFixable() {
        return true;
    }

    public String getName() {
        return "number of bands";
    }

    public String getDescription() {
        return "check the number of bands";
    }

    public String getCandidate() {
        String ret = "";
        if (state != OK)
            ret = "will fix num_bands to\nthe recommended value : "
                    + String.valueOf(def);
        return ret;
    }

    public boolean fixInput() {
        int def = PhaseUtils.getDefaultNumBands(inputInterface, metallic, spin);
        fixPrimitiveEntry("accuracy", "num_bands", String.valueOf(def), "");
        return true;
    }

    private boolean metallic = false;

    private boolean spin = false;

    private int def;

    public int doCheck() {
        logger.debug(inputInterface);
        String mag = inputInterface.getInputInterfacePrimitiveEntry(
                "structure.magnetic_state").getValue();
        if (!(mag.length() == 0 || mag.equalsIgnoreCase("para")))
            spin = true;

        state = OK;
        def = PhaseUtils.getDefaultNumBands(inputInterface, metallic, spin);
        int min = PhaseUtils.getNumBands(inputInterface, metallic, spin, 1);
        int numbands = -1;
        try {
            numbands = Integer.parseInt(inputInterface
                    .getInputInterfacePrimitiveEntry("accuracy.num_bands")
                    .getValue());
        } catch (NumberFormatException e) {
            state = ERROR;
        }
        message = "current num. bands: " + String.valueOf(numbands) + LS;
        message += "minimum num. bands: " + String.valueOf(min) + LS;
        message += "recommended num. bands: " + String.valueOf(def);

        if (numbands < min) {
            state = ERROR;
        }

        if (numbands < def) {
            state = WARNING;
        }

        return state;
    }

}
