/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/02/21, 18:53
!  AUTHOR(S): KOGA, Junichiro
!  File : KpointSamplingPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.ekcal.preparationpanel;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.acviewer.fbz.FBZData;
import ciss.phase_viewer.common.PhaseUtils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel.Kpoints;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.GUIBootButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * uk_TvOvp̕ҏWpGUI
 * 
 * @author
 */
public class KpointSamplingPanel extends ProjectManipulator {
    private Logger logger = Logger.getLogger(KpointSamplingPanel.class
            .getName());

    /** Creates a new instance of KpointSamplingPanel */
    public KpointSamplingPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void initializeProject() {
    }

    public void init() {
        add(new KsampPanel(projectInfo.getInputInterface()));
    }

    class KsampPanel extends PhaseInputItems {
        KsampPanel(InputInterface inputInterface) {
            super(inputInterface);
        }

        public void createGUI() {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
            p.setSize(500, 250);

            String accuracy = "accuracy.";

            JPanel p_ksample = new JPanel();
            p_ksample.setLayout(new FlowLayout(FlowLayout.LEFT));
            // p_ksample.setLayout(new BoxLayout(p_ksample,BoxLayout.X_AXIS));
            String ksamp = accuracy + "ksampling.";
            String[] specMethod = { "accuracy.ksampling.method" };
            String[] methodChoice = { NO_SELECTION, "monk", "mesh", "file",
                    "gamma", "directin" };
            ChoicePanelPhase method = new ChoicePanelPhase(specMethod,
                    inputInterface, "Method", methodChoice, this);
            p_ksample.add(method);

            JPanel panelbtn = new JPanel();
            // panelbtn.setLayout(new BoxLayout(panelbtn,BoxLayout.Y_AXIS));
            panelbtn.setLayout(new GridLayout(2, 1));
            JButton panelbandkpt = new JButton("band_kpoints.pl");
            JButton fbzButton = new JButton("FBZ");
            fbzButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    bootFBZViewer();
                }
            });
            // panelbandkpt.addActionListener(new ActionListener() {
            // public void actionPerformed(ActionEvent ae) {
            // String FS = System.getProperty("file.separator");
            // String script =
            // System.getProperty("user.home")+FS+".phase-viewer"+FS+"scripts"+FS+"gui"+FS+"phase"+FS+"bandkpt.bsh";
            // String dir = new File(inputInterface.getFile()).getParent();
            // try{
            // Interpreter interpreter = new Interpreter();
            // interpreter.set("curdir",dir);
            // interpreter.source(script);
            // } catch(Exception exc) {
            // exc.printStackTrace();
            // }
            // }
            // });
            // panelbtn.add(panelbandkpt);
            panelbtn.add(fbzButton);

            Object[] argk = new Object[1];
            GUIBootButton btnkdirect = new GUIBootButton("edit kpoints",
                    inputInterface, Kpoints.class, this);
            method.registerDisabableGUI(new int[] { 0, 1, 2, 3, 4 }, btnkdirect);
            method.registerDisabableGUI(new int[] { 0, 1, 2, 4, 5 }, fbzButton);
            // method.registerDisabableGUI(new int [] {0,1,2,4,5},panelbandkpt);
            // method.getComboBox().setSelectedIndex(method.getComboBox().getSelectedIndex());
            panelbtn.add(btnkdirect);
            // p_ksample.add(btnkdirect);
            p_ksample.add(panelbtn);

            JPanel ptable = new JPanel();
            ptable.setLayout(new BoxLayout(ptable, BoxLayout.Y_AXIS));

            String[] kmeshSpec = { ksamp + "mesh" };
            TableForInputInterface kmeshTable = new TableForInputInterface(
                    kmeshSpec, inputInterface, null, this);
            kmeshTable.getModel().addTableModelListener(this);
            JScrollPane scrPaneKmesh = new JScrollPane();
            scrPaneKmesh.getViewport().setView(kmeshTable.getPanel());
            // scrPaneKmesh.setPreferredSize(new Dimension(180, 35));
            ptable.add(scrPaneKmesh);

            int icol = kmeshTable.getModel().getColumnCount();
            int[] intarray = new int[] { 3, 4, 5 };
            for (int j = 0; j < icol; j++) {
                DefaultCellEditor editor = (DefaultCellEditor) kmeshTable
                        .getColumnModel().getColumn(j).getCellEditor();
                method.registerDisabableGUI(intarray,
                        (JComponent) editor.getComponent());
            }

            String[] ksampIdent = { ksamp + "kshift" };
            TableForInputInterface kshiftTable = new TableForInputInterface(
                    ksampIdent, inputInterface, null, this);
            JScrollPane scrPaneKshift = new JScrollPane();

            scrPaneKshift.getViewport().setView(kshiftTable.getPanel());
            ptable.add(scrPaneKshift);

            icol = kshiftTable.getModel().getColumnCount();
            int[] intshift = new int[] { 2, 3, 4, 5 };
            for (int j = 0; j < icol; j++) {
                DefaultCellEditor editor = (DefaultCellEditor) kshiftTable
                        .getColumnModel().getColumn(j).getCellEditor();
                method.registerDisabableGUI(intshift,
                        (JComponent) editor.getComponent());
            }

            JPanel p_ksample_all = new JPanel();
            p_ksample_all.setBorder(new TitledBorder("K point sampling"));
            p_ksample_all.setLayout(new BoxLayout(p_ksample_all,
                    BoxLayout.X_AXIS));
            p_ksample_all.add(p_ksample);
            p_ksample_all.add(ptable);
            p.add(p_ksample_all);

            String[] specNumBnd = { accuracy + "num_bands" };
            InputPanelPhase numbands = new InputPanelPhase(specNumBnd,
                    inputInterface, "num. bands", InputPanelPhase.NONE, 7, this);
            p.add(numbands);

            JPanel p_smear = new JPanel();
            p_smear.setLayout(new GridLayout(1, 2, 1, 1));

            String[] specSmear = { accuracy + "smearing.method" };
            String[] smearChoice = { NO_SELECTION, "parabolic", "tetrahedron" };
            ChoicePanelPhase smear = new ChoicePanelPhase(specSmear,
                    inputInterface, "Method", smearChoice, this);
            p_smear.add(smear);

            String[] specWidth = { accuracy + "smearing.width" };
            InputPanelPhase width = new InputPanelPhase(specWidth,
                    inputInterface, "width", InputPanelPhase.ENERGY, 7, this);
            p_smear.add(width);

            smear.registerDisabableGUI(new int[] { 0, 2 }, width);

            p_smear.setBorder(new TitledBorder("Smearing"));
            p.add(p_smear);

            JPanel p_init = new JPanel();
            p_init.setLayout(new GridLayout(1, 2, 1, 1));

            String[] initWFSpec = { accuracy + "initial_wavefunctions" };
            String[] initWFChoice = { NO_SELECTION, "Matrix_diagon",
                    "Random_numbers" };
            ChoicePanelPhase initWF = new ChoicePanelPhase(initWFSpec,
                    inputInterface, "wave function", initWFChoice, this);

            String[] matdiagonCutoffSpec = { accuracy
                    + "matrix_diagon.cutoff_wf" };
            InputPanelPhase matdiagon = new InputPanelPhase(
                    matdiagonCutoffSpec, inputInterface,
                    "cutoff (matrix diagon)", InputPanelPhase.ENERGY, 7, this);

            p_init.add(initWF);
            p_init.add(matdiagon);

            initWF.registerDisabableGUI(new int[] { 0, 2 }, matdiagon);

            String[] initCDSpec = { accuracy + "initial_charge_density" };
            String[] initCDChoice = { "Gauss" };
            ChoicePanelPhase initCD = new ChoicePanelPhase(initCDSpec,
                    inputInterface, "charge density", initCDChoice, this);
            p_init.add(initCD);

            p_init.setBorder(new TitledBorder("Initial"));
            p.add(p_init);

            add(p);
        }

    }

    private void bootFBZViewer() {
        String dir = projectInfo.getProjectDirectory();
        double[][] reclat = PhaseUtils.getReciprocalLatticeFrom(projectInfo
                .getInputInterface());
        try {
            FBZData data = new FBZData();
            data.reciprocalLattice = reclat;
            data.baseDir = dir;
            new FBZ(data);
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }

}
