/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/13, 20:20
!  AUTHOR(S): KOGA, Junichiro
!  File : PhaseManipulator.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator;

import java.io.File;
import java.net.URL;

import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseFileManager;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInitializer;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout.StdoutGeneralPanel;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout.StdoutPostPanel;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout.StdoutSCFPanel;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.scripting.ScriptWrapper;

/**
 * PHASȄ𐧌.
 * 
 * @author KOGA, Junichiro
 */
public class PhaseManipulator extends ProjectManipulatorBase {
    public PhaseManipulator(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    private String FS = System.getProperty("file.separator");
    private String scriptDir = System.getProperty("user.home") + FS
            + ".phase-viewer" + FS + "scripts" + FS + "jobcontrol" + FS
            + "phase";

    public boolean createDefaultScript() {
        ScriptWrapper[] defaults = getDefaultScripts();
        for (int i = 0; i < defaults.length; i++) {
            // if ( new File(defaults[i].getPath()).exists() ) {
            // continue;
            // }
            String name = new File(defaults[i].getPath()).getName();
            try {
                ciss.phase_viewer.common.ExternalProgramExecuter.copy(scriptDir
                        + System.getProperty("file.separator") + name,
                        defaults[i].getPath());
            } catch (Exception exc) {
                return false;
            }
        }
        return true;
    }

    public ScriptWrapper[] getDefaultScripts() {
        ScriptWrapper[] defaults = new ScriptWrapper[REGISTERED_SCRIPT_TYPE.length];
        String prefix = "submit.";
        String FS = System.getProperty("file.separator");
        for (int i = 0; i < REGISTERED_SCRIPT_TYPE.length; i++) {
            defaults[i] = new ScriptWrapper(baseDir + FS + prefix
                    + REGISTERED_SCRIPT_TYPE[i], REGISTERED_SCRIPT_TYPE[i]);
        }
        return defaults;
    }

    public void initializeProject() {
    }

    public void initializeProject(ProjectDirBrowserNode node) {
        PhaseInitializer init = new PhaseInitializer(projectInfo, this, node);
        init.runWizard();
    }

    protected URL getSubSelectorURL() {
        return getClass()
                .getResource(
                        "/ciss/phase_viewer/plugins/projectmanipulator/phase/manipulator_sub_selector_properties.xml");
    }

    protected Class[] getStdoutGUIs() {
        return new Class[] { StdoutGeneralPanel.class, StdoutSCFPanel.class,
                StdoutPostPanel.class };
    }

    protected URL getProgramDescriptionURL() {
        return getClass()
                .getResource(
                        "/ciss/phase_viewer/plugins/projectmanipulator/phase/intropanel/phase_intro.htm");
    }

    private ciss.phase_viewer.file.ChaseFileManager cfManager;
    private URL phaseSpec = PhaseConstants.FILEINFO_PHASE;

    protected ciss.phase_viewer.file.ChaseFileManager getChaseFileManager() {
        File fnamesData = new File(projectInfo.getProjectDirectory()
                + System.getProperty("file.separator") + "file_names.data");
        if (cfManager == null) {
            cfManager = new PhaseFileManager(phaseSpec, fnamesData);
        }
        cfManager.setFileSpecFile(fnamesData);
        return cfManager;
    }

    protected String getType() {
        getChaseFileManager();
        return cfManager.getName();
    }

}
