/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/13, 20:03
!  AUTHOR(S): KOGA, Junichiro
!  File : ChaseProjectPanel.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator;

import java.util.Vector;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * 
 * @author KOGA, Junichiro
 */
public class ChaseProjectPanel extends ProjectManipulator {

    /** Creates a new instance of ChaseProjectPanel */
    public ChaseProjectPanel(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void init() {
        super.setBorder(new TitledBorder(projectInfo.getProjectName()));
        JPanel subproj = new JPanel();
        subproj.setLayout(new BoxLayout(subproj, BoxLayout.Y_AXIS));
        Vector subprojects = projectInfo.getSubProjects();
        for (int i = 0; i < subprojects.size(); i++) {
            ProjectInfo info = (ProjectInfo) subprojects.elementAt(i);
            JLabel label = new JLabel(info.toString());
            subproj.add(label);
        }
        subproj.setBorder(new TitledBorder("sub project info"));
        super.add(subproj);
    }

    public void initializeProject() {

    }

}
