/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/12/01 18:06:23
!  AUTHOR(S): KOGA, Junichiro
!  File : BasicReportGenerator.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.plugins.projectmanipulator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jobcontrol.ReportGenerator;
import ciss.phase_viewer.projectbrowser.ProjectInfo;

/**
 * PHASE, ekcal, uvsor-epsiloñ|[gWFl[^["ev[g"
 * 
 * @author KOGA, Junichiro
 * 
 */
public abstract class BasicReportGenerator implements ReportGenerator {
    private Logger logger = Logger.getLogger(BasicReportGenerator.class
            .getName());

    protected String jobstatusIdent = "jobstatus\\d+";

    protected String stdoutIdent = "output\\d+";

    protected File mostRecentJobStatFile;

    protected File mostRecentStdOutFile;

    protected String parentDir;

    public String generateReport(String parentDir) {
        this.parentDir = parentDir;
        File parentDirFile = new File(parentDir);
        if (!parentDirFile.isDirectory()) {
            return parentDir + " is not a directory.";
        }
        File[] files = parentDirFile.listFiles();
        if (files == null || files.length == 0) {
            return "no files found under " + parentDir;
        }
        mostRecentJobStatFile = null;
        mostRecentStdOutFile = null;

        for (int i = 0; i < files.length; i++) {
            if (files[i].getName().matches(jobstatusIdent)) {
                if (mostRecentJobStatFile == null
                        || mostRecentJobStatFile.lastModified() < files[i]
                                .lastModified())
                    mostRecentJobStatFile = files[i];
            }
            if (files[i].getName().matches(stdoutIdent)) {
                if (mostRecentStdOutFile == null
                        || mostRecentStdOutFile.lastModified() < files[i]
                                .lastModified())
                    mostRecentStdOutFile = files[i];
            }
        }

        String ret = "date : " + Calendar.getInstance().getTime().toString()
                + "\n";

        try {
            ret += "\n";
            InetAddress host = java.net.InetAddress.getLocalHost();
            ret += "ran on host : " + host.getHostName() + "\n";
        } catch (UnknownHostException e) {
            e.printStackTrace();
        }

        ret += "\n";
        ret += "working directory : " + parentDir + "\n";

        if (mostRecentJobStatFile == null) {
            ret += "\n";
            ret += "could not find jobstatus file.\n";
        } else {
            ret += "\n";
            ret += "jobstatus file : " + mostRecentJobStatFile.getName() + "\n";
            BufferedReader reader = Utils.getReader(mostRecentJobStatFile
                    .getAbsolutePath());
            try {
                String line = "";
                while ((line = reader.readLine()) != null)
                    ret += line + "\n";
            } catch (IOException ioe) {
                ioe.printStackTrace();
            } finally {
                try {
                    reader.close();
                } catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        ret += "\n";
        String aa = getOthers();
        if (aa != null)
            ret += aa;

        return ret;
    }

    /**
     * jobstatuscatĂ܂; ̂قǉ񂪂΂̃\bh.
     * 
     * @return ǉ.
     */
    protected abstract String getOthers();

    /**
     * TuNX̃pXQbg
     * 
     * @param projectInfo
     *            ProjectInfoɋLq̂vWFNgɂăpXς.
     * @return
     */
    public static String getReportGeneratorPath(ProjectInfo projectInfo) {
        String reportGeneratorPath = "ciss.phase_viewer.plugins.projectmanipulator.phase.jobcontrolpanel.PhaseReportGenerator";
        if (projectInfo.getProjectType().equals("ekcal"))
            reportGeneratorPath = "ciss.phase_viewer.plugins.projectmanipulator.ekcal.jobcontrolpanel.EkcalReportGenerator";
        else if (projectInfo.getProjectType().equals("uvsor-epsilon"))
            reportGeneratorPath = "ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.jobcontrolpanel.UvsorEpsilonReportGenerator";
        return reportGeneratorPath;
    }

}
