/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/11/24, 17:11
!  AUTHOR(S): KOGA, Junichiro
!  File : PlotPropertiesEditor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.graph.dataset;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.InternalFrameChase;

/**
 * 
 * @author
 */
public class PlotPropertiesEditor extends InternalFrameChase {
    private Logger logger = Logger.getLogger(PlotPropertiesEditor.class
            .getName());
    private PlotProperties props;

    private JTextField gap;
    private JTextField weight;
    private JComboBox orientation;
    private String[] orientationChoice = { "share domain axis",
            "share range axis" };

    private int index;

    /** Creates a new instance of PlotPropertiesEditor */
    public PlotPropertiesEditor(String title, PlotProperties props, int index) {
        super("combined plot properties for " + title, true, true, true, true,
                new Dimension(300, 130));
        this.props = props;
        this.index = index;
        init();
    }

    private void init() {
        getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));

        gap = new JTextField(6);
        gap.setText(String.valueOf(props.getGap()));
        JPanel pgap = new JPanel();
        pgap.setBorder(new TitledBorder("gap"));
        pgap.add(gap);
        panel.add(pgap);

        weight = new JTextField(6);
        SubPlotProperties spp = props.getSubPlotPropertiesAt(index);
        if (spp != null) {
            weight.setText(String.valueOf(spp.getWeight()));
        }
        JPanel pweight = new JPanel();
        pweight.setBorder(new TitledBorder("weight"));
        pweight.add(weight);
        panel.add(pweight);

        orientation = new JComboBox(orientationChoice);
        if (props.getPlotOrientation() == PlotProperties.DOMAIN) {
            orientation.setSelectedIndex(0);
        } else {
            orientation.setSelectedIndex(1);
        }
        JPanel porien = new JPanel();
        porien.setBorder(new TitledBorder("axis"));
        porien.add(orientation);
        panel.add(porien);

        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, BoxLayout.X_AXIS));
        JButton btnok = new JButton("ok");
        JButton btncan = new JButton("cancel");
        buttons.add(btnok);
        buttons.add(btncan);

        getContentPane().add(panel, BorderLayout.NORTH);
        getContentPane().add(buttons, BorderLayout.SOUTH);

        btncan.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        btnok.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                save();
                dispose();
            }
        });

    }

    private void save() {
        try {
            int wi;
            double ga;
            int scheme;
            wi = Integer.parseInt(weight.getText());
            ga = Double.parseDouble(gap.getText());
            if (orientation.getSelectedIndex() == 0) {
                scheme = PlotProperties.DOMAIN;
            } else {
                scheme = PlotProperties.RANGE;
            }
            props.setGap(ga);
            props.setPlotOrientation(scheme);
            props.getSubPlotPropertiesAt(index).setWeight(wi);
        } catch (Exception exc) {
            logger.error("invalid value found.");
        }
    }

}
