/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/11/21 16:40:18
!  AUTHOR(S): KOGA, Junichiro
!  File : XYData.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.graph;

import java.awt.Color;

import org.apache.log4j.Logger;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.data.xy.XYSeries;

/**
 * ꎟ̃f[^, ߂, ȃNX.
 * 
 * @author KOGA, Junichiro
 * 
 */
public class XYData {
    private Logger logger = Logger.getLogger(XYData.class.getName());
    private double[] xdata;
    private double[] ydata;

    public static int DOUBLE = 0;
    public static int INTEGER = 1;

    public int collectionIndex = 0;
    public int seriesIndex = -1;

    public String xAxisName = "";
    public String yAxisName = "";

    public boolean xisLog = false;
    public boolean yisLog = false;
    public int xValType = DOUBLE;
    public int yValType = DOUBLE;

    public AxisLocation yAxisLocation = AxisLocation.BOTTOM_OR_LEFT;

    public Color seriesColor = null; /* V[Y̕`F; null̏ꍇftHg̗p */

    private String name = "";

    public XYData(double[] xdata, double[] ydata, String name) {
        this.xdata = xdata;
        this.ydata = ydata;
        this.name = name;
    }

    public XYData(String[] strxData, String[] stryData, String name)
            throws NumberFormatException {
        xdata = new double[strxData.length];
        ydata = new double[stryData.length];
        this.name = name;
        for (int i = 0; i < xdata.length; i++)
            xdata[i] = Double.parseDouble(strxData[i].replaceAll("D", "E"));
        for (int i = 0; i < ydata.length; i++)
            ydata[i] = Double.parseDouble(stryData[i].replaceAll("D", "E"));
    }

    public XYData(String name) {
        this.name = name;
    }

    public double[] getXData() {
        return this.xdata;
    }

    public double[] getYData() {
        return this.ydata;
    }

    private XYSeries series;

    public XYSeries createXYSeries() {
        series = new XYSeries(name);
        if (xdata == null || ydata == null)
            return series;
        int numData = xdata.length;
        if (numData > ydata.length)
            numData = ydata.length;
        for (int i = 0; i < numData; i++)
            series.add(xdata[i], ydata[i]);
        return series;
    }

    public XYSeries getXYSeries() {
        if (series == null)
            return createXYSeries();
        return series;
    }

    public void add(double x, double y) {
        if (series == null)
            createXYSeries();
        try {
            series.add(x, y);
        } catch (Exception e) {
        }
    }

}
