/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : FilePropertyViewer.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.filebrowser;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;

public class FilePropertyViewer extends InternalFrameChase {
    private static Logger logger = Logger.getLogger(FilePropertyViewer.class
            .getName());

    private RemoteFile[] files;

    public FilePropertyViewer(RemoteFile[] files) {
        super("file property viewer", true, true, true, true, new Dimension(
                350, 240));
        this.files = files;
        init();
    }

    private void init() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

        JTabbedPane tp = new JTabbedPane();
        tp.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);

        for (int i = 0; i < files.length; i++) {
            RemoteFile file = files[i];
            logger.debug("file properties for file no. " + i);
            logger.debug("isDirectory: " + file.isDirectory());
            logger.debug("file path: " + file.getAbsolutePath());
            logger.debug("canRead: " + file.canRead());
            logger.debug("canWrite: " + file.canWrite());
            logger.debug("lastModified: "
                    + FileProperty.getTime(file.lastModified()));
            logger.debug("size: " + file.length());

            tp.addTab(file.getName(), new FileProperty(file));
        }

        JPanel pbtn = new JPanel();
        pbtn.setLayout(new BoxLayout(pbtn, BoxLayout.X_AXIS));
        JButton close = new JButton("close");
        pbtn.add(close);

        p.add(tp);
        p.add(pbtn);

        close.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        this.getContentPane().add(p);
    }

}

class FileProperty extends JScrollPane {

    private RemoteFile file;

    protected FileProperty(RemoteFile file) {
        super();
        this.file = file;
        createFileProperty();
    }

    private void createFileProperty() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

        String location = "";
        RemoteFile parent = (RemoteFile) file.getParentFile();
        if (parent == null) {
            location = "root";
        } else {
            location = parent.getAbsolutePath();
        }
        String slocation = "location:      " + location;
        MyJLabel llocation = new MyJLabel(slocation);

        boolean isDirectory = file.isDirectory();
        String type = "file type:     ";
        if (isDirectory) {
            type += "directory";
        } else {
            type += "file";
        }
        MyJLabel ltype = new MyJLabel(type);

        boolean canread = file.canRead();
        String scanread = "read:          ";
        if (canread) {
            scanread += "yes";
        } else {
            scanread += "no";
        }
        MyJLabel lcanread = new MyJLabel(scanread);

        boolean canwrite = file.canWrite();
        String scanwrite = "write:         ";
        if (canwrite) {
            scanwrite += "yes";
        } else {
            scanwrite += "no";
        }
        MyJLabel lcanwrite = new MyJLabel(scanwrite);

        String lastmodified = "last modified: "
                + FileProperty.getTime(file.lastModified());
        MyJLabel llastmodified = new MyJLabel(lastmodified);

        long size = file.length();
        String ssize = "size:          " + String.valueOf(size) + " bytes";
        MyJLabel lsize = new MyJLabel(ssize);

        p.add(llocation);
        p.add(ltype);
        p.add(lcanread);
        p.add(lcanwrite);
        p.add(llastmodified);
        p.add(lsize);

        this.getViewport().setView(p);

    }

    protected static String getTime(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        return calendar.getTime().toString();
    }

}

class MyJLabel extends JLabel {
    protected MyJLabel(String string) {
        super(string);
        this.setFont(new Font("Monospaced", Font.PLAIN, 12));
    }
}
