/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/07, 15:34
!  AUTHOR(S): KOGA, Junichiro
!  File : ManipTest.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.file;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;

/**
 * ProjectManipulatoreXg.
 * 
 * @author
 */
public class ManipTest extends ProjectManipulator {
    private Logger logger = Logger.getLogger(ManipTest.class.getName());
    private ChaseFileManager fileManager;

    /** Creates a new instance of ManipTest */
    public ManipTest(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public void initializeProject() {
    }

    public void init() {
        fileManager = projectInfo.getChaseFileManager();

        setLayout(new BorderLayout());
        JPanel pppanel = getPPPanel();
        FileTransferPanel ftpanel = new FileTransferPanel(projectInfo);

        JButton btnedit = new JButton("edit");

        add(ftpanel, BorderLayout.NORTH);
        add(pppanel, BorderLayout.CENTER);
        add(btnedit, BorderLayout.SOUTH);

        btnedit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                FileNameEditPanel editPanel = new FileNameEditPanel(fileManager);
            }
        });

        updateProject();
    }

    private DefaultListModel listModel;
    private JList pplist;

    private JPanel getPPPanel() {
        JPanel pan = new JPanel();
        pan.setLayout(new BoxLayout(pan, BoxLayout.Y_AXIS));
        listModel = new DefaultListModel();
        pplist = new JList(listModel);
        JScrollPane pane = new JScrollPane(pplist);
        pane.setSize(new Dimension(500, 300));
        JPanel btnpane = new JPanel();
        btnpane.setLayout(new BoxLayout(btnpane, BoxLayout.X_AXIS));
        JButton ppadd = new JButton("add");
        JButton ppdel = new JButton("del");
        btnpane.add(ppadd);
        btnpane.add(ppdel);

        pan.add(pane);
        pan.add(btnpane);

        ppadd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                addPP();
            }
        });

        ppdel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                delPP();
            }
        });

        return pan;
    }

    private void updateProject() {
        logger.debug("updating project...");
        DefaultListModel listModel = (DefaultListModel) pplist.getModel();
        listModel.removeAllElements();

        ChaseFile[] pot = fileManager.getFiles("F_POT(.+)");
        if (pot != null && pot.length != 0) {
            logger.debug("num. pp files: " + pot.length);
            for (int i = 0; i < pot.length; i++) {
                logger.debug(pot[i]);
                listModel.addElement(pot[i]);
            }
        } else {
            logger.debug("no ppfiles");
        }
    }

    private String ppDir = ciss.phase_viewer.common.Utils.getDefaultPPDir();

    private void addPP() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(ppDir));
        if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            File file = chooser.getSelectedFile();
            String projdir = projectInfo.getProjectDirectory();
            String dir = Utils.getRelativePath(projdir, ppDir);
            ChaseFile cf = fileManager
                    .addFile(dir, "F_POT(.+)", file.getName());
            fileManager.save();
            listModel.addElement(cf);
        }
    }

    private void delPP() {
        int sele = pplist.getSelectedIndex();
        if (sele >= 0) {
            fileManager.removeFile(listModel.remove(sele));
            fileManager.save();
        }
    }
}
