/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : TemplateCopier.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.common;

import java.awt.Component;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class TemplateCopier {

    /** 'parent' object */
    private Object parent;

    /** the file to be copied */
    private String toCopy;

    /** name of toCopy */
    private String toCopyName;

    /** path of toCopy */
    private String curDir;

    /** template dir */
    private String templateDir;

    /** the 'selected' file */
    private String selectedFile;

    /** 'selected' file's name */
    private String selectedFileName;

    /** file separator */
    private final String FS = System.getProperty("file.separator");

    /**
     * @param parent
     *            Ăяo. Ȃł悢.
     */
    public TemplateCopier(Object parent) {
        this.parent = parent;
    }

    /**
     * @param parent
     *            Ăяo. Ȃł悢.
     * @param toCopy
     *            Rs[.
     */
    public TemplateCopier(Object parent, String toCopy) {
        this.parent = parent;
        this.toCopy = toCopy;
        File file = new File(toCopy);
        curDir = file.getParent();
        toCopyName = file.getName();
    }

    /**
     * Rs[ݒ肷.
     * 
     * @param toCopy
     *            Rs[ւ̃pX.
     */
    public void setToCopy(String toCopy) {
        this.toCopy = toCopy;
        File file = new File(toCopy);
        curDir = file.getParent();
        toCopyName = file.getName();
    }

    /**
     * ev[gfBNg[ݒ肷. ̃fBNg[ t@C`[U[̋NfBNg[ƂȂ.
     */
    public void setTemplatePath(String templateDir) {
        this.templateDir = templateDir;
    }

    /**
     * ev[g̃Rs[s. ܂ev[gfBNg[N_Ƃt@C`[U[ Ă΂. őIꂽt@C,
     * Rs[̃t@CɃRs[ dg݂ɂȂĂ.
     * 
     * @return ㏑ɏIꍇɋUԂ.
     */
    public boolean copyTemplate() {
        // JFileChooser filechooser = new JFileChooser();
        ChaseFileChooser filechooser = new ChaseFileChooser(true);
        filechooser.setDialogType(JFileChooser.CUSTOM_DIALOG);
        filechooser.setDialogTitle("copy template file");
        filechooser.setCurrentDirectory(new File(templateDir));
        filechooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        if (filechooser.showDialog((Component) parent, "open") != JFileChooser.APPROVE_OPTION) {
            return false;
        }

        selectedFile = filechooser.getSelectedFile().getAbsolutePath();
        selectedFileName = (new File(selectedFile)).getName();

        int selected = JOptionPane.YES_OPTION;
        if ((new File(toCopy)).exists()) {
            selected = JOptionPane.showInternalConfirmDialog(
                    ciss.phase_viewer.mainpanel.Desk.getDesktop(),
                    "overwrite?", "confirmation", JOptionPane.YES_NO_OPTION,
                    JOptionPane.QUESTION_MESSAGE);
        }

        if (selected == JOptionPane.YES_OPTION) {
            try {
                ExternalProgramExecuter.copy(selectedFile, toCopy);
            } catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        } else {
            return false;
        }

        return true;
    }

}
