/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/27, 14:10
!  AUTHOR(S): KOGA, Junichiro
!  File : CapableText2D.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.scenegraphelements;

import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent;
import javax.vecmath.Color3f;

import org.apache.log4j.Logger;

import ciss.phase_viewer.acviewer.J3DDataManager;

import com.sun.j3d.utils.geometry.Text2D;

/**
 * Capability炩߃ZbgText2D
 * 
 * @author
 */
public class CapableText2D extends Text2D {
    private Logger logger = Logger.getLogger(CapableText2D.class.getName());

    /** Creates a new instance of CapableText2D */
    public CapableText2D(String str, Color3f color, String fontName,
            int fontSize, int fontStyle) {
        super(str, color, fontName, fontSize, fontStyle);
        try {
            getAppearance().getTexture().getImage(0)
                    .setCapability(ImageComponent.ALLOW_IMAGE_READ);
            getAppearance().getTexture().getImage(0)
                    .setCapability(ImageComponent.ALLOW_FORMAT_READ);
            getAppearance().getTexture().getImage(0)
                    .setCapability(ImageComponent.ALLOW_SIZE_READ);
            getGeometry().setCapability(Geometry.ALLOW_INTERSECT);
        } catch (Exception exc) {
        }
    }

    public CapableText2D(String str, J3DDataManager j3ddata) {
        this(str, j3ddata.getFontColor(), j3ddata.getFont().getFontName(),
                j3ddata.getFont().getSize(), j3ddata.getFont().getStyle());
    }
}
