/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/08/31, 15:59
!  AUTHOR(S): KOGA, Junichiro
!  File : TranslateKeyListener.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.keylistener;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

import org.apache.log4j.Logger;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesListener;
import ciss.phase_viewer.settings.PropertiesManager;

/**
 * ipL[Xi[
 * 
 * @author
 */
public class TranslateKeyListener implements KeyListener, PropertiesListener {
    private Logger logger = Logger.getLogger(TranslateKeyListener.class
            .getName());
    private TransformGroup[] tgroups;
    private double factor = 0.05;

    /** Creates a new instance of TranslateKeyListener */
    public TranslateKeyListener(TransformGroup[] tgroups) {
        PropertiesManager.getGlobalProperties(PropertiesManager.PROPERTIES_ACV)
                .addPropertiesListener(this);
        this.tgroups = tgroups;
        try {
            factor = Double.parseDouble(PropertiesManager.getGlobalProperties(
                    PropertiesManager.PROPERTIES_ACV).getProperty(
                    "keylistener_trans"));
        } catch (Exception exc) {
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    private Transform3D transx = new Transform3D();
    private Transform3D transy = new Transform3D();
    private Transform3D currTrans = new Transform3D();

    private void doTranslation(int x, int y) {
        double dx = x * factor;
        double dy = y * factor;
        for (int i = 0; i < tgroups.length; i++) {
            tgroups[i].getTransform(currTrans);
            Vector3d t3d = new Vector3d();
            currTrans.get(t3d);
            t3d.add(new Vector3d(dx, dy, 0));
            currTrans.setTranslation(t3d);
            tgroups[i].setTransform(currTrans);
        }
    }

    public void keyPressed(KeyEvent e) {
        if (!e.isShiftDown())
            return;
        if (e.isAltDown())
            return;
        if (e.getKeyCode() == KeyEvent.VK_UP || e.getKeyCode() == KeyEvent.VK_K) {
            doTranslation(0, 1);
        } else if (e.getKeyCode() == KeyEvent.VK_DOWN
                || e.getKeyCode() == KeyEvent.VK_J) {
            doTranslation(0, -1);
        } else if (e.getKeyCode() == KeyEvent.VK_LEFT
                || e.getKeyCode() == KeyEvent.VK_H) {
            doTranslation(-1, 0);
        } else if (e.getKeyCode() == KeyEvent.VK_RIGHT
                || e.getKeyCode() == KeyEvent.VK_L) {
            doTranslation(1, 0);
        }
    }

    public void propertiesStored(GlobalProperties properties) {
        try {
            factor = Double.parseDouble(properties
                    .getProperty("keylistener_trans"));
        } catch (Exception exc) {
        }
    }

}
