/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/29, 15:20
!  AUTHOR(S): KOGA, Junichiro
!  File : SimpleColorMap.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.acviewer.colormap;

import java.awt.Color;

import org.apache.log4j.Logger;

/**
 * "P"J[}bv
 * 
 * @author
 */
public class SimpleColorMap extends BaseColorMap {
    private Logger logger = Logger.getLogger(SimpleColorMap.class.getName());

    public SimpleColorMap() {
    }

    /**
     * 01̊Ԃ̐FԂ; 0ȉꍇ͐^, 1ȏ̏ꍇ͐^.
     * 
     * @param value
     *            l
     * @return Ήl
     */
    public java.awt.Color getColor(float value) {
        if (value < 0) {
            return Color.BLUE;
        }
        if (value > 1) {
            return Color.RED;
        }

        if (value >= 0.75 && value <= 1.0) {
            float val = 1.f - value;
            float green = (val / 0.25f);
            return new Color(1.f, green, 0.f);
        }

        if (value >= 0.5 && value < 0.75) {
            float val = 0.75f - value;
            float red = 1 - (val / 0.25f);
            return new Color(red, 1.f, 0.f);
        }

        if (value >= 0.25 && value < 0.5) {
            float val = 0.5f - value;
            float blue = val / 0.25f;
            return new Color(0.f, 1.f, blue);
        }

        if (value >= 0 && value < 0.25) {
            float val = 0.25f - value;
            float green = 1 - val / 0.25f;
            return new Color(0.f, green, 1.f);
        }

        /* ɂ͗Ȃ. Ǝv. */
        return Color.BLACK;
    }

    public int getResolution() {
        return 256 * 4;
    }

}
