/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on ----
!  AUTHOR(S): KOGA, Junichiro
!  File : NewElementCreater.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */
package ciss.phase_viewer.acviewer;

import java.util.Vector;

import org.apache.log4j.Logger;

import ciss.phase_viewer.common.Utils;

class NewElementCreater {

    private Logger logger = Logger.getLogger(NewElementCreater.class.getName());
    private J3DDataManager mACVD;
    private ConfigDataManager mCD;

    private Vector newElementVector = new Vector();
    private Vector newElementVectorExt = new Vector();
    private String[] element;
    private int numNewEl = 0;

    /**
     * qzu\̐ݒƌqzũf[^͂炩 ݒ肷.
     * 
     * @param mACVD
     *            qzu\ݒێIuWFNg
     * @param mCD
     *            qzuуZ̃f[^ێIuWFNg
     */
    public NewElementCreater(J3DDataManager mACVD, ConfigDataManager mCD) {
        this.mACVD = mACVD;
        this.mCD = mCD;
    }

    /**
     * eq̌f`FbN, uVfvƈׂ̂ Vfɓo^.
     * 
     * @return Vf̐
     */
    int createNewElement() {
        int numNewElements = 0;
        int NumAt = mCD.getNumAt();
        element = mACVD.getElement();

        String[] elements = mCD.getElements();
        for (int i = 0; i < elements.length; i++) {
            String elementi = elements[i].toLowerCase();
            for (int j = 0; j < element.length; j++) {
                if (elementi.startsWith(element[j].toLowerCase())) {
                    int identLength = element[j].length();
                    if (!(elementi.length() == identLength)) {
                        char[] ch = elementi.toCharArray();
                        String extention = String.copyValueOf(ch, identLength,
                                (ch.length - identLength));
                        if (Utils.isNumber(extention) && isUnique(elementi)) {
                            newElementVector.addElement(element[j]);
                            newElementVectorExt.addElement(extention);
                        }
                    }
                }
            }
        }
        registerNewElement();

        return newElementVector.size();
    }

    private void registerNewElement() {
        int nnew = newElementVector.size();
        for (int i = 0; i < nnew; i++) {
            String newel = (String) newElementVector.get(i);
            String newelext = (String) newElementVectorExt.get(i);
            logger.debug("found new element ... ");
            logger.debug("base: " + newel + ", extention: " + newelext);
            int elementIndex = 0;
            for (int ifind = 0; ifind < element.length; ifind++) {
                if (element[ifind].equalsIgnoreCase(newel)) {
                    elementIndex = ifind;
                    break;
                }
            }

            float[] color = mACVD.getColor()[elementIndex];
            double covrad = mACVD.getCovRad()[elementIndex];
            float rad = mACVD.getRad()[elementIndex];

            mACVD.addElementInfo(newel + newelext, rad, covrad, color);
        }
    }

    private boolean isUnique(String string) {
        boolean ret = true;
        for (int i = 0; i < newElementVector.size(); i++) {
            String comp = (String) newElementVector.get(i)
                    + (String) newElementVectorExt.get(i);
            if (string.equals(comp.toLowerCase())) {
                ret = false;
            }
        }

        return ret;
    }

}
