/* ====================================================================
 *
 * Skin Look And Feel 6.2 License.
 *
 * Copyright (c) 2000-2006 L2FProd.com.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by L2FProd.com
 *        (http://www.L2FProd.com/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "Skin Look And Feel", "SkinLF" and "L2FProd.com" must not
 *    be used to endorse or promote products derived from this software
 *    without prior written permission. For written permission, please
 *    contact info@L2FProd.com.
 *
 * 5. Products derived from this software may not be called "SkinLF"
 *    nor may "SkinLF" appear in their names without prior written
 *    permission of L2FProd.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL L2FPROD.COM OR ITS CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.icon.ArrowIcon;
import com.l2fprod.gui.plaf.skin.DefaultButton;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.SwingConstants;

final class GtkDefaultButton extends DefaultButton {

  /** mainly used by optionmenu */
  boolean hasArrow = true;

  public GtkDefaultButton(Image bitmap, int imageWidth, int imageHeight,
                          int topHeight, int rightWidth, int bottomHeight, int leftWidth) {
    super(bitmap, imageWidth, imageHeight,
          topHeight, rightWidth, bottomHeight, leftWidth, false);
  }

  public GtkDefaultButton(Image bitmap, Image gap, Image gap_start, Image gap_end, int imageWidth, int imageHeight,
          			      int topHeight, int rightWidth, int bottomHeight, int leftWidth) {
    super(bitmap, gap, gap_start, gap_end, imageWidth, imageHeight,
          topHeight, rightWidth, bottomHeight, leftWidth);
  }  
  
  public GtkDefaultButton(Image top, Image bottom, Image left, Image right,
                          Image topLeft, Image topRight, Image bottomLeft, Image bottomRight) {
    super(top, bottom, left, right,
          topLeft, topRight, bottomLeft, bottomRight);
  }

  public GtkDefaultButton(Image bitmap, int imageWidth, int imageHeight,
                          int topHeight, int rightWidth, int bottomHeight, int leftWidth, boolean tile) {
    super(bitmap, imageWidth, imageHeight,
          topHeight, rightWidth, bottomHeight, leftWidth, tile);
  }
      
  public void paint(Graphics g, Component c) {
    super.paint(g, c);
    if (!hasArrow) {
      ArrowIcon.paintArrow(g, 5,
                           c.getWidth() - rightWidth,
                           c.getHeight() / 2 - 3,
                           rightWidth,
                           c.getHeight(),
                           SwingConstants.SOUTH,
                           c.isEnabled());
    }
  }

}

