/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2005/07/15, 16:46
!  AUTHOR(S): KOGA, Junichiro
!  File : ProjectRemover.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.projectbrowser.projectstatemanipulator;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

import org.apache.log4j.Logger;

import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;

/**
 * 
 * @author KOGA, Junichiro
 */
public class ProjectRemover extends InternalFrameChase implements
        ProjectStateChanger {
    private Logger logger = Logger.getLogger(ProjectRemover.class.getName());
    private JCheckBox removeFiles;
    private ProjectDirBrowserNode node;
    private Vector listeners = new Vector();
    private ProjectDirBrowser dirBrowser;

    /** Creates a new instance of ProjectRemover */
    public ProjectRemover(String title, ProjectDirBrowserNode node,
            ProjectDirBrowser dirBrowser) {
        super(title, false, false, false, false, new Dimension(300, 120));
        this.node = node;
        this.dirBrowser = dirBrowser;
        init();
    }

    public void addProjectStateChangeListener(
            ProjectStateChangeListener listener) {
        listeners.addElement(listener);
    }

    private void init() {
        Container cont = getContentPane();
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(2, 1));
        p.add(removeFilesTooPanel());
        p.add(buttonPanel());
        cont.add(p);
    }

    private JPanel removeFilesTooPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        removeFiles = new JCheckBox("remove files and directories too");
        p.add(removeFiles);
        return p;
    }

    private JPanel buttonPanel() {
        JPanel p = new JPanel();
        // p.setLayout(new BoxLayout(p,BoxLayout.X_AXIS));
        JButton ok = new JButton("ok");
        JButton can = new JButton("cancel");
        can.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                dispose();
            }
        });

        ok.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                manipulateProjectState();
                dispose();
            }
        });

        p.add(ok);
        p.add(can);

        return p;
    }

    public void manipulateProjectState() {
        if (removeFiles.isSelected()) {
            ProjectInfo info = node.getProjectInfo();
            String dir = info.getProjectDirectory();
            boolean b = ciss.phase_viewer.common.Utils
                    .deleteDir(new java.io.File(dir));
            if (!b) {
                logger.error("failed to delete directory: " + dir);
                return;
            }
        }
        dirBrowser.removeCurrentNode();
        if (node.getProjectBrowser() != null
                && node.getProjectBrowser().isVisible()) {
            node.getProjectBrowser().dispose();
        }
        notifyListeners();
        logger.info("removed project.");
    }

    private void notifyListeners() {
        for (int i = 0; i < listeners.size(); i++) {
            ProjectStateChangeListener listener = (ProjectStateChangeListener) listeners
                    .elementAt(i);
            listener.projectStateChanged(new ProjectStateChangeEvent(this));
        }
    }

}
