package ciss.phase_viewer.plugins.projectmanipulator.phase.preparationpanel;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseInputItems;
import ciss.phase_viewer.primitiveguis.AddButton;
import ciss.phase_viewer.primitiveguis.CheckPanelPhase;
import ciss.phase_viewer.primitiveguis.ChoicePanelPhase;
import ciss.phase_viewer.primitiveguis.DeleteButton;
import ciss.phase_viewer.primitiveguis.InputPanelPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputPanelInterface;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableForInputInterface;

public class CmixPanelPanel extends PhaseInputItems {
    public CmixPanelPanel(InputInterface inputInterface) {
        super(inputInterface);
    }

    public void createGUI() {
        // setLayout(new GridLayout());
        // JPanel p = new JPanel();
        JPanel p = this;
        p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));
        // p.setPreferredSize(new Dimension(600,400));

        JPanel p_cmix = new JPanel();
        p_cmix.setLayout(new BoxLayout(p_cmix, BoxLayout.X_AXIS));

        String[] specCmix = { "charge_mixing.mixing_methods" };
        TableForInputInterface cmixTable = new TableForInputInterface(specCmix,
                inputInterface, this);

        cmixTable.setColumnSelectionAllowed(true);
        cmixTable.setRowSelectionAllowed(true);

        JScrollPane scrPane = new JScrollPane();
        scrPane.getViewport().setView(cmixTable.getPanel());
        scrPane.setPreferredSize(new Dimension(500, 150));
        // p_cmix.add(Box.createVerticalStrut(100));
        p_cmix.add(scrPane);
        // p_cmix.add(Box.createVerticalStrut(100));
        p.add(p_cmix);
        // p.add(Box.createVerticalStrut(5));

        JPanel p_cmix_new = new JPanel();
        p_cmix_new.setLayout(new GridLayout(3, 4, 1, 1));

        String[] dummy = { "" };
        InputPanelPhase no = new InputPanelPhase(dummy, inputInterface, "no.",
                InputPanelPhase.NONE, 5);

        String[] method_list = { "simple", "broyden2", "pulay" };
        ChoicePanelPhase method = new ChoicePanelPhase(dummy, inputInterface,
                "method", method_list);

        InputPanelPhase rmxs = new InputPanelPhase(dummy, inputInterface,
                "rmxs.", InputPanelPhase.NONE, 5);
        InputPanelPhase rmxe = new InputPanelPhase(dummy, inputInterface,
                "rmxe.", InputPanelPhase.NONE, 5);
        // InputPanelPhase itr = new InputPanelPhase(dummy,inputInterface,
        // "itr .",InputPanelPhase.NONE,5);

        // String[] var_list = { "linear", "tanh" };
        String[] ON_OFF_FORCE = { "on", "off" };
        // ChoicePanelPhase var = new ChoicePanelPhase(dummy,
        // inputInterface,"var",var_list);
        // ChoicePanelPhase prec = new ChoicePanelPhase(dummy, inputInterface,
        // "prec", ON_OFF_FORCE);
        InputPanelPhase istr = new InputPanelPhase(dummy, inputInterface,
                "istr", InputPanelPhase.NONE, 5);
        InputPanelPhase nbmix = new InputPanelPhase(dummy, inputInterface,
                "nbmix", InputPanelPhase.NONE, 5);

        String[] update_list = { "renew", "anew" };
        ChoicePanelPhase update = new ChoicePanelPhase(dummy, inputInterface,
                "update", update_list);

        /*
         * TableColumn column; column = cmixTable.getColumnModel().getColumn(1);
         * column.setCellEditor(new DefaultCellEditor(new
         * JComboBox(method_list))); column =
         * cmixTable.getColumnModel().getColumn(5); column.setCellEditor(new
         * DefaultCellEditor(new JComboBox(var_list))); column =
         * cmixTable.getColumnModel().getColumn(6); column.setCellEditor(new
         * DefaultCellEditor(new JComboBox(ON_OFF_FORCE))); column =
         * cmixTable.getColumnModel().getColumn(9); column.setCellEditor(new
         * DefaultCellEditor(new JComboBox(update_list)));
         */

        p_cmix_new.add(no);
        p_cmix_new.add(method);
        p_cmix_new.add(rmxs);
        p_cmix_new.add(rmxe);
        // p_cmix_new.add(itr);
        // p_cmix_new.add(var);
        // p_cmix_new.add(prec);
        p_cmix_new.add(istr);
        p_cmix_new.add(nbmix);
        p_cmix_new.add(update);
        p_cmix_new.setBorder(new TitledBorder("add new cmix method"));

        p.add(p_cmix_new);

        JPanel p_cmixbtn = new JPanel();
        p_cmixbtn.setLayout(new BoxLayout(p_cmixbtn, BoxLayout.X_AXIS));

        // PhaseInputPanelInterface[] guis =
        // {no,method,rmxs,rmxe,itr,var,prec,istr,nbmix,update};
        PhaseInputPanelInterface[] guis = { no, method, rmxs, rmxe, istr,
                nbmix, update };
        p_cmixbtn.add(new AddButton(cmixTable, guis, this));
        p_cmixbtn.add(new DeleteButton(cmixTable, this));
        JButton choose = new JButton("from file");
        p_cmixbtn.add(choose);
        p.add(p_cmixbtn);
        p.add(Box.createVerticalStrut(5));

        // charge_preconditioning pane
        JPanel p_chg_prcn = new JPanel();
        p_chg_prcn.setLayout(new GridLayout(1, 4, 1, 1));

        String[] specAmix = { "charge_mixing.charge_preconditioning.amix" };
        String[] specBmix = { "charge_mixing.charge_preconditioning.bmix" };
        InputPanelPhase amix = new InputPanelPhase(specAmix, inputInterface,
                "amix", InputPanelPhase.NONE, 5, this);
        InputPanelPhase bmix = new InputPanelPhase(specBmix, inputInterface,
                "bmix", InputPanelPhase.NONE, 5, this);
        p_chg_prcn.add(new JPanel());
        p_chg_prcn.add(amix);
        p_chg_prcn.add(bmix);
        // p_chg_prcn.add(new JPanel());
        // p.add(p_chg_prcn);

        String[] specRecomposing = { "charge_mixing.sw_recomposing" };
        CheckPanelPhase cpprecompose = new CheckPanelPhase(specRecomposing,
                inputInterface, "recompose", this, false);
        p_chg_prcn.add(cpprecompose);

        // this.add(p);
        choose.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                fromFile(InputInterface.__ROOT__, "charge_mixing");
            }
        });
    }

}