/*
!=======================================================================
!
!  PROGRAM  PHASE-Viewer  (PHASE-Viewer 2014.01 ver.3.3.0)
!
!  Created on 2006/06/22, 20:17
!  AUTHOR(S): KOGA, Junichiro
!  File : StdOutMonitor.java
!  
!  Contact address :  Phase System Consortium
!                     E-mail: phase_system@nims.go.jp URL https://azuma.nims.go.jp
!
!
!   Since 2002, this program set had been intensively developed as a part of the following 
!  national projects supported by the Ministry of Education, Culture, Sports, Science and
!  Technology (MEXT) of Japan; "Frontier Simulation Software for Industrial Science
!  (FSIS)" from 2002 to 2005, "Revolutionary Simulation Software (RSS21)" from 2006 to
!  2008. "Research and Development of Innovative Simulation Software (RISS)" from 2008
!  to 2013. These projects is lead by the Center for Research on Innovative Simulation 
!  Software (CISS), the Institute of Industrial Science (IIS), the University of Tokyo.
!   Since 2013, this program set has been further developed centering on PHASE System
!  Consortium. 
!   The activity of development of this program set has been supervised by Takahisa Ohno.
!
!=======================================================================
 */

package ciss.phase_viewer.plugins.projectmanipulator.phase.file;

import java.awt.Dimension;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.jfree.chart.axis.AxisLocation;

import ciss.phase_viewer.file.ChaseFile;
import ciss.phase_viewer.file.SimpleMonitor;
import ciss.phase_viewer.graph.GraphPanel;
import ciss.phase_viewer.graph.SimpleChart;
import ciss.phase_viewer.graph.XYData;
import ciss.phase_viewer.projectbrowser.ProjectInfo;

/**
 * 
 * F_OUTt@Cj^[NX.
 * 
 * @author
 */
public class StdOutMonitor extends SimpleMonitor {
    private Logger logger = Logger.getLogger(StdOutMonitor.class.getName());

    /** Creates a new instance of StdOutMonitor */
    public StdOutMonitor(ProjectInfo projectInfo) {
        super(projectInfo);
    }

    public String getFileToMonitor() {
        return projectInfo.getChaseFileManager().getFile("F_OUT")
                .getDefaultName().getValue();
    }

    public ChaseFile getChaseFile() {
        ChaseFile cf = projectInfo.getChaseFileManager().getFile("F_OUT");
        return cf;
    }

    private String TOTAL_ENERGY = "TOTAL ENERGY";

    protected void doGraph(String[] lines) {
        logger.debug("at doGraph");
        if (lines == null || lines.length == 0)
            return;
        Vector dataVector = new Vector();
        for (int i = 0; i < lines.length; i++) {
            String line = lines[i].trim();
            logger.debug(line);

            if (!line.startsWith(TOTAL_ENERGY))
                continue;
            String[] ar = line.split("\\s+");
            if (ar.length < 10)
                continue;
            try {
                double[] tmp = new double[3];
                tmp[0] = Double.parseDouble(ar[3]);
                tmp[1] = Double.parseDouble(ar[6].replaceAll("D", "E"));
                tmp[2] = Math
                        .abs(Double.parseDouble(ar[9].replaceAll("D", "E")));
                dataVector.add(tmp);
            } catch (NumberFormatException nfe) {
                logger.error("invalid line...: " + line);
                logger.error("3,6,9: " + ar[3] + ", " + ar[6] + ", " + ar[9]);
                continue;
            }
        }
        if (dataVector.size() == 0 && !isGraphCreatable(textArea))
            return;

        if (xyData == null) {
            xyData = new XYData[2];
            xyData[0] = new XYData("total energy");
            xyData[0].xValType = XYData.INTEGER;
            xyData[0].xAxisName = "iteration";
            xyData[0].yAxisName = "total energy(hartree)";
            xyData[0].collectionIndex = 0;

            xyData[1] = new XYData("edelta");
            xyData[1].xValType = XYData.INTEGER;
            xyData[1].yAxisLocation = AxisLocation.BOTTOM_OR_RIGHT;
            xyData[1].yisLog = true;
            xyData[1].yAxisName = "edelta (hartree)";
            xyData[1].collectionIndex = 1;
        }
        double[][] data = new double[dataVector.size()][];
        dataVector.copyInto(data);
        for (int i = 0; i < data.length; i++) {
            xyData[0].add(data[i][0], data[i][1]);
            xyData[1].add(data[i][0], data[i][2]);
        }

        if (!graph)
            return;

        if (graphPanel == null) {
            SimpleChart simpleChart = new SimpleChart(xyData);
            simpleChart.setSize(new Dimension(512, 400));
            simpleChart.setTitle("monitoring " + fileName);
            simpleChart.setChartTitle("total energy and dE");
            simpleChart.setChartProgressListener(this);
            graphPanel = new GraphPanel(simpleChart);
            graphPanel.addInternalFrameListener(this);
        }
        if (!graphPanel.isVisible())
            graphPanel.setVisible(true);
    }
}
